/*
 * Decompiled with CFR 0.152.
 */
package pgx;

import com.itextpdf.text.DocumentException;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.swing.JideButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.dialog.IndividualSelector;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.appdevapi.AppColors;
import org.ut.biolab.medsavant.shared.appdevapi.Variant;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.AnnotationManagerAdapter;
import pgx.PGXAnalysis;
import pgx.PGXDisclaimer;
import pgx.PGXException;
import pgx.PGXGene;
import pgx.PGXGenotype;
import pgx.PGXPDFExporter;
import pgx.PGXTextExporter;
import pgx.localDB.PGXDBFunctions;

public class PGXPanel {
    private static Log log = LogFactory.getLog(MedSavantClient.class);
    private static final int CHOOSE_PATIENT_BUTTON_WIDTH = 250;
    private static final int SIDE_PANE_WIDTH = 380;
    private static final int SIDE_PANE_WIDTH_OFFSET = 20;
    private static final String baseDBSNPUrl = "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=";
    private static final String basePubmedUrl = "http://www.ncbi.nlm.nih.gov/pubmed/";
    private static final Color DEFAULT_LABEL_COLOUR = new JTextField().getForeground();
    private static final Color DEFAULT_SUBHEADING_DARK_BLUE = new Color(26, 13, 171);
    private static final String CANCEL_TEXT = "Cancel";
    private static final String REFRESH_TEXT = "Refresh";
    private static List<String> afColumnNames;
    private CountDownLatch cancelLatch = new CountDownLatch(1);
    private String currentHospitalID;
    private String currentDNAID;
    private PGXAnalysis currentPGXAnalysis;
    private MedSavantWorker pgxAnalysisThread;
    private JPanel appView;
    private JScrollPane patientSidePane;
    private JPanel patientSideJP;
    private JScrollPane reportPane;
    private JideButton choosePatientButton;
    private IndividualSelector patientSelector;
    private JLabel status;
    private ProgressWheel statusWheel;
    private JPanel reportInitJP;
    private JLabel reportStartLabel;
    private JButton cancelOrRefresh;
    private JButton exportToPDFButton;
    private JTabbedPane tabs;
    private JButton exportToTextButton;

    public PGXPanel() {
        this.setupApp();
    }

    public JPanel getView() {
        return this.appView;
    }

    private void setupApp() {
        this.appView = new JPanel();
        this.appView.setLayout((LayoutManager)new MigLayout("insets 0px, gapx 0px"));
        this.initPatientSidePanel();
        this.initReportPanel();
        this.appView.add(this.patientSidePane);
        this.appView.add(this.reportPane);
        this.appView.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                Dimension d = PGXPanel.this.appView.getSize();
                PGXPanel.this.reportPane.setPreferredSize(new Dimension(d.width - 380, d.height));
                PGXPanel.this.reportPane.setMinimumSize(new Dimension(d.width - 380, d.height));
                PGXPanel.this.reportPane.setMaximumSize(new Dimension(d.width - 380, d.height));
                PGXPanel.this.appView.updateUI();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.componentShown(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }
        });
    }

    private ActionListener choosePatientAction() {
        ActionListener outputAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PGXPanel.this.patientSelector.setVisible(true);
                Set selectedIndividuals = PGXPanel.this.patientSelector.getHospitalIDsOfSelectedIndividuals();
                if (PGXPanel.this.patientSelector.hasMadeSelection()) {
                    PGXPanel.this.currentHospitalID = (String)PGXPanel.this.patientSelector.getHospitalIDsOfSelectedIndividuals().iterator().next();
                    String newDNAID = (String)PGXPanel.this.patientSelector.getDNAIDsOfSelectedIndividuals().iterator().next();
                    if (newDNAID != null) {
                        PGXPanel.this.currentDNAID = newDNAID;
                        PGXPanel.this.choosePatientButton.setText(PGXPanel.this.currentHospitalID);
                    } else {
                        PGXPanel.this.errorDialog("Can't find a DNA ID for " + PGXPanel.this.currentHospitalID);
                    }
                }
                PGXPanel.this.choosePatientButton.setEnabled(false);
                PGXPanel.this.analyzePatient();
            }
        };
        return outputAL;
    }

    private ActionListener cancelOrRefreshAction() {
        ActionListener outputAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!PGXPanel.this.pgxAnalysisThread.isDone()) {
                    MedSavantWorker<Object> cancellationThread = new MedSavantWorker<Object>(PGXPanel.class.getCanonicalName()){

                        protected Object doInBackground() throws SQLException, RemoteException, SessionExpiredException, PGXException {
                            PGXPanel.this.status.setText("Cancelling...");
                            PGXPanel.this.cancelOrRefresh.setEnabled(false);
                            PGXPanel.this.pgxAnalysisThread.cancel(true);
                            try {
                                PGXPanel.this.cancelLatch.await();
                                PGXPanel.this.currentPGXAnalysis.cancel();
                            }
                            catch (InterruptedException ie) {
                                PGXPanel.this.errorDialog(ie.getMessage());
                                ie.printStackTrace();
                            }
                            return null;
                        }

                        protected void showSuccess(Object t) {
                            PGXPanel.this.cancelReportPanel();
                            PGXPanel.this.cancelOrRefresh.setEnabled(true);
                            PGXPanel.this.cancelOrRefresh.setText(PGXPanel.REFRESH_TEXT);
                            PGXPanel.this.status.setText("Analysis cancelled.");
                            PGXPanel.this.statusWheel.setVisible(false);
                            PGXPanel.this.choosePatientButton.setEnabled(true);
                        }
                    };
                    cancellationThread.execute();
                } else {
                    PGXPanel.this.analyzePatient();
                }
            }
        };
        return outputAL;
    }

    private ActionListener exportToPDFAction() {
        ActionListener outputAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PGXPanel.this.status.setText("Exporting PDF...");
                PGXPanel.this.statusWheel.setVisible(true);
                final JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("PDF file", "pdf");
                chooser.setFileFilter(filter);
                final int chooserValue = chooser.showSaveDialog((Component)MedSavantFrame.getInstance());
                MedSavantWorker<Object> pdfThread = new MedSavantWorker<Object>(PGXPanel.class.getCanonicalName()){

                    protected Object doInBackground() {
                        if (chooserValue == 0) {
                            String chooserFileName = chooser.getSelectedFile().getPath() + ".pdf";
                            PGXPDFExporter pdfExporter = new PGXPDFExporter(PGXPanel.this.tabs, chooserFileName);
                            try {
                                pdfExporter.createMultipagePDF();
                            }
                            catch (DocumentException de) {
                                PGXPanel.this.errorDialog("Error producing PDF report: " + de.getMessage());
                                de.printStackTrace();
                            }
                        }
                        return null;
                    }

                    protected void showSuccess(Object t) {
                        PGXPanel.this.status.setText("PDF export complete.");
                        PGXPanel.this.statusWheel.setVisible(false);
                    }
                };
                pdfThread.execute();
            }
        };
        return outputAL;
    }

    private ActionListener exportToTextAction() {
        ActionListener outputAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PGXPanel.this.status.setText("Exporting text file...");
                PGXPanel.this.statusWheel.setVisible(true);
                final JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Text file", "txt");
                chooser.setFileFilter(filter);
                final int chooserValue = chooser.showSaveDialog((Component)MedSavantFrame.getInstance());
                MedSavantWorker<Object> textFileThread = new MedSavantWorker<Object>(PGXPanel.class.getCanonicalName()){

                    protected Object doInBackground() {
                        if (chooserValue == 0) {
                            String chooserFileName = chooser.getSelectedFile().getPath() + ".txt";
                            PGXTextExporter textExporter = new PGXTextExporter(PGXPanel.this.currentPGXAnalysis, chooserFileName);
                            try {
                                textExporter.createTextReport();
                            }
                            catch (FileNotFoundException fnfe) {
                                PGXPanel.this.errorDialog("Error producing text report: " + fnfe.getMessage());
                                fnfe.printStackTrace();
                            }
                        }
                        return null;
                    }

                    protected void showSuccess(Object t) {
                        PGXPanel.this.status.setText("Text file export complete.");
                        PGXPanel.this.statusWheel.setVisible(false);
                    }
                };
                textFileThread.execute();
            }
        };
        return outputAL;
    }

    private void initPatientSidePanel() {
        this.patientSideJP = new JPanel();
        this.patientSelector = new IndividualSelector(true);
        this.choosePatientButton = new JideButton("Choose Patient");
        this.choosePatientButton.setButtonStyle(0);
        this.choosePatientButton.setOpaque(true);
        this.choosePatientButton.setFont(new Font(this.choosePatientButton.getFont().getName(), 0, 18));
        this.choosePatientButton.setMinimumSize(new Dimension(250, this.choosePatientButton.getHeight()));
        this.choosePatientButton.addActionListener(this.choosePatientAction());
        this.status = new JLabel();
        this.status.setFont(new Font(this.status.getFont().getName(), 0, 15));
        this.statusWheel = new ProgressWheel();
        this.statusWheel.setIndeterminate(true);
        this.status.setVisible(false);
        this.statusWheel.setVisible(false);
        this.cancelOrRefresh = new JButton();
        this.cancelOrRefresh.setVisible(false);
        this.cancelOrRefresh.addActionListener(this.cancelOrRefreshAction());
        this.exportToPDFButton = new JButton("Export to PDF");
        this.exportToPDFButton.setVisible(false);
        this.exportToPDFButton.addActionListener(this.exportToPDFAction());
        this.exportToTextButton = new JButton("Export to text file");
        this.exportToTextButton.setVisible(false);
        this.exportToTextButton.addActionListener(this.exportToTextAction());
        CollapsiblePane disclaimer = new CollapsiblePane("Disclaimer");
        disclaimer.setStyle(2);
        disclaimer.collapse(true);
        disclaimer.setFocusable(false);
        JTextArea disclaimerTextArea = new JTextArea(PGXDisclaimer.getDisclaimer());
        disclaimerTextArea.setLineWrap(true);
        disclaimerTextArea.setWrapStyleWord(true);
        disclaimerTextArea.setRows(8);
        disclaimerTextArea.setColumns(27);
        JScrollPane disclaimerJSP = new JScrollPane();
        disclaimerJSP.setViewportView(disclaimerTextArea);
        disclaimer.add((Component)disclaimerJSP, (Object)"alignx center, wrap");
        this.patientSideJP.setLayout((LayoutManager)new MigLayout("insets 10 10 0 0, gapy 0px, fill"));
        this.patientSideJP.setBackground(AppColors.HummingBird);
        this.patientSideJP.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
        this.patientSideJP.setMinimumSize(new Dimension(380, 0));
        this.patientSideJP.add((Component)this.choosePatientButton, "alignx center, wrap");
        this.patientSideJP.add((Component)new JLabel("Results are based on CPIC guidelines"), "alignx center, gapy 20px, wrap");
        this.patientSideJP.add((Component)new JLabel("This app is intended for research purposes only"), "alignx center, gapy 10px, wrap");
        this.patientSideJP.add((Component)this.status, "alignx center, gapy 50px, wrap");
        this.patientSideJP.add((Component)this.statusWheel, "alignx center, wrap");
        this.patientSideJP.add((Component)this.cancelOrRefresh, "alignx center, gapy 20px, wrap");
        this.patientSideJP.add((Component)this.exportToPDFButton, "alignx center, gapy 40px, wrap");
        this.patientSideJP.add((Component)this.exportToTextButton, "alignx center, wrap");
        this.patientSideJP.add((Component)disclaimer, "dock south");
        this.patientSidePane = new JScrollPane();
        this.patientSidePane.setBorder(BorderFactory.createEmptyBorder());
        this.patientSidePane.setHorizontalScrollBarPolicy(31);
        this.patientSidePane.setMinimumSize(new Dimension(380, 0));
        this.patientSidePane.setPreferredSize(new Dimension(380, this.patientSideJP.getMaximumSize().height));
        this.patientSidePane.setViewportView(this.patientSideJP);
    }

    private void initReportPanel() {
        this.reportInitJP = new JPanel();
        this.reportInitJP.setLayout((LayoutManager)new MigLayout("align 50% 50%"));
        this.reportInitJP.setBackground(Color.WHITE);
        this.reportStartLabel = new JLabel("Choose a patient to start a pharmacogenomic analysis.");
        this.reportStartLabel.setFont(new Font(this.reportStartLabel.getFont().getName(), 0, 14));
        this.reportStartLabel.setForeground(Color.DARK_GRAY);
        this.reportInitJP.add(this.reportStartLabel);
        this.reportPane = new JScrollPane();
        this.reportPane.setBorder(BorderFactory.createEmptyBorder());
        this.reportPane.setViewportView(this.reportInitJP);
    }

    private void analysisRunningReportPanel() {
        this.reportStartLabel.setText("Obtaining pharmacogenomic report for " + this.currentHospitalID + "...");
        this.reportPane.setViewportView(this.reportInitJP);
    }

    private void cancelReportPanel() {
        this.reportStartLabel.setText("Analysis cancelled.");
        this.reportPane.setViewportView(this.reportInitJP);
    }

    private void analyzePatient() {
        this.status.setText("Performing pharmacogenomic analysis...");
        this.status.setVisible(true);
        this.statusWheel.setVisible(true);
        this.cancelOrRefresh.setText(CANCEL_TEXT);
        this.cancelOrRefresh.setVisible(true);
        this.exportToPDFButton.setVisible(false);
        this.exportToTextButton.setVisible(false);
        this.analysisRunningReportPanel();
        this.pgxAnalysisThread = new MedSavantWorker<Object>(PGXPanel.class.getCanonicalName()){

            protected Object doInBackground() throws SQLException, RemoteException, SessionExpiredException, PGXException {
                try {
                    PGXPanel.this.currentPGXAnalysis = new PGXAnalysis(PGXPanel.this.currentDNAID);
                    PGXPanel.this.cancelLatch.countDown();
                }
                catch (Exception e) {
                    PGXPanel.this.errorDialog(e.getMessage());
                    e.printStackTrace();
                }
                return null;
            }

            protected void showSuccess(Object t) {
                PGXPanel.this.status.setText("Analysis complete.");
                PGXPanel.this.statusWheel.setVisible(false);
                PGXPanel.this.choosePatientButton.setEnabled(true);
                PGXPanel.this.cancelOrRefresh.setText(PGXPanel.REFRESH_TEXT);
                PGXPanel.this.exportToPDFButton.setVisible(true);
                PGXPanel.this.exportToTextButton.setVisible(true);
                PGXPanel.this.updateReportPane();
            }
        };
        this.pgxAnalysisThread.execute();
    }

    private void updateReportPane() {
        this.tabs = new JTabbedPane();
        this.tabs.setTabLayoutPolicy(0);
        JPanel summary = new JPanel();
        summary.setBackground(Color.WHITE);
        summary.setLayout((LayoutManager)new MigLayout("gapx 30px"));
        summary.add(this.createLabel("Patient Hospital ID", true, 20));
        summary.add((Component)this.createLabel(this.currentHospitalID, false, 20), "wrap");
        summary.add(this.createLabel("Patient DNA ID", true, 20));
        summary.add((Component)this.createLabel(this.currentDNAID, false, 20), "wrap");
        summary.add((Component)this.createLabel("Gene", true, 20), "gapy 20px");
        summary.add(this.createLabel("Diplotype", true, 20));
        summary.add((Component)this.createLabel("Therapeutic class", true, 20), "wrap");
        for (PGXGene pg : this.currentPGXAnalysis.getGenes()) {
            summary.add(this.createLabel(pg.getGene(), false, 20));
            summary.add(this.createLabel(pg.getDiplotype(), false, 20));
            summary.add((Component)this.createLabel(pg.getMetabolizerClass(), false, 20), "wrap");
        }
        this.tabs.addTab("Summary", summary);
        for (PGXGene pg : this.currentPGXAnalysis.getGenes()) {
            JPanel reportJP = new JPanel();
            reportJP.setBackground(Color.WHITE);
            reportJP.setLayout((LayoutManager)new MigLayout("gapx 30px"));
            reportJP.add(this.createLabel("Gene", true, 22));
            reportJP.add((Component)this.createLabel(pg.getGene(), false, 22), "wrap");
            reportJP.add(this.createLabel("Diplotype", true, 22));
            reportJP.add((Component)this.createLabel(pg.getDiplotype(), false, 22), "wrap");
            reportJP.add(this.createLabel("Therapeutic class", true, 22));
            reportJP.add((Component)this.createLabel(pg.getMetabolizerClass(), false, 22), "gapafter 30px, wrap");
            reportJP.add((Component)this.createLabel("Publications", true, 22), "aligny top");
            List<String> pubmedIDs = PGXDBFunctions.getPubMedIDs(pg.getGene());
            for (int i = 0; i != pubmedIDs.size(); ++i) {
                String pubmedButtonText = "Guidelines";
                if (pubmedIDs.size() > 1) {
                    pubmedButtonText = pubmedButtonText + " #" + (i + 1);
                }
                JideButton jb = this.getURLButton(pubmedButtonText, basePubmedUrl, pubmedIDs.get(i), true);
                jb.setFont(new Font(jb.getFont().getName(), 0, 22));
                String constraintText = "aligny top, ";
                if (i == 0 && pubmedIDs.size() > 1) {
                    constraintText = constraintText + "split";
                } else if (i == pubmedIDs.size() - 1) {
                    constraintText = constraintText + "wrap";
                }
                reportJP.add((Component)jb, constraintText);
            }
            String phasedTextAddition = "";
            if (!pg.isPhased()) {
                phasedTextAddition = "NOT ";
            }
            reportJP.add((Component)this.createLabel("Genotypes are " + phasedTextAddition + "phased.", false, 22), "span");
            JPanel geneSummaryJP = new JPanel();
            geneSummaryJP.setBackground(Color.WHITE);
            geneSummaryJP.setLayout((LayoutManager)new MigLayout("gapx 20px"));
            this.addHaplotypes(geneSummaryJP, pg);
            geneSummaryJP.revalidate();
            JPanel hapDetailsJP = new JPanel();
            hapDetailsJP.setBackground(Color.WHITE);
            hapDetailsJP.setLayout((LayoutManager)new MigLayout("gapx 15px"));
            this.addHaplotypeDetails(hapDetailsJP, pg);
            JPanel testedMarkersJP = new JPanel();
            testedMarkersJP.setBackground(Color.WHITE);
            testedMarkersJP.setLayout((LayoutManager)new MigLayout("gapy 0px, gapx 30px"));
            this.addTestedMarkers(testedMarkersJP, pg);
            JPanel novelVariantsJP = this.getNovelVariantsPanel(pg);
            reportJP.add((Component)this.createLabel("Haplotype summary", true, 22, reportJP.getBackground(), DEFAULT_SUBHEADING_DARK_BLUE), "gapy 40px, span");
            reportJP.add((Component)geneSummaryJP, "span");
            reportJP.add((Component)this.createLabel("Genotype summary ", true, 22, reportJP.getBackground(), DEFAULT_SUBHEADING_DARK_BLUE), "span");
            reportJP.add((Component)hapDetailsJP, "span");
            reportJP.add((Component)this.createLabel("Novel variants (not part of guidelines)", true, 22, reportJP.getBackground(), DEFAULT_SUBHEADING_DARK_BLUE), "span");
            reportJP.add((Component)novelVariantsJP, "span");
            this.tabs.addTab(pg.getGene(), reportJP);
        }
        this.reportPane.setViewportView(this.tabs);
    }

    private void addHaplotypes(JPanel jp, PGXGene pg) {
        if (pg.isPhased()) {
            jp.add(this.createLabel("Haplotype #1", true, 16));
            jp.add((Component)this.createLabel(pg.getMaternalHaplotype(), false, 16), "wrap");
            jp.add(this.createLabel("Haplotype #2", true, 16));
            jp.add((Component)this.createLabel(pg.getPaternalHaplotype(), false, 16), "wrap");
            jp.add(this.createLabel("Haplotype #1 activity", true, 16));
            jp.add((Component)this.createLabel(pg.getMaternalActivity(), false, 16), "wrap");
            jp.add(this.createLabel("Haplotype #2 activity", true, 16));
            jp.add((Component)this.createLabel(pg.getPaternalActivity(), false, 16), "wrap");
        }
    }

    private void addHaplotypeDetails(JPanel jp, PGXGene pg) {
        int FONT_SIZE = 16;
        String column1Heading = "Haplotype #1";
        String column2Heading = "Haplotype #2";
        if (!pg.isPhased()) {
            column1Heading = "Unphased genotype #1";
            column2Heading = "Unphased genotype #2";
        }
        jp.add(this.createLabel("Marker ID", true, FONT_SIZE));
        jp.add(this.createLabel(column1Heading, true, FONT_SIZE));
        jp.add(this.createLabel(column2Heading, true, FONT_SIZE));
        jp.add(this.createLabel("Observed status", true, FONT_SIZE));
        jp.add(this.createLabel("Chr", true, FONT_SIZE));
        jp.add(this.createLabel("Position", true, FONT_SIZE));
        jp.add(this.createLabel("Ref", true, FONT_SIZE));
        jp.add(this.createLabel("Alt", true, FONT_SIZE));
        jp.add((Component)this.createLabel("Coverage", true, FONT_SIZE), "wrap");
        Map<Object, Object> markerLookup = new HashMap();
        try {
            markerLookup = PGXDBFunctions.getMarkerInfoMap(pg.getGene());
        }
        catch (Exception e) {
            this.errorDialog(e.getMessage());
            e.printStackTrace();
        }
        ArrayList<Object> allRsIDs = new ArrayList<Object>(markerLookup.keySet());
        Collections.sort(allRsIDs);
        Map<String, PGXGenotype> hap1Genotypes = pg.getMaternalGenotypes();
        Map<String, PGXGenotype> hap2Genotypes = pg.getPaternalGenotypes();
        for (String string : allRsIDs) {
            String genotypeStatus = "observed";
            PGXGenotype genotype1 = null;
            PGXGenotype genotype2 = null;
            String haplotypeGenotype1 = "N/A";
            String haplotypeGenotype2 = "N/A";
            String coverage = "N/A";
            Color fontColour = DEFAULT_LABEL_COLOUR;
            if (hap1Genotypes.containsKey(string)) {
                genotype1 = hap1Genotypes.get(string);
                genotype2 = hap2Genotypes.get(string);
                haplotypeGenotype1 = genotype1.getGenotype();
                haplotypeGenotype2 = genotype2.getGenotype();
                coverage = Integer.toString(genotype1.getCoverage());
            } else {
                genotypeStatus = "missing";
                fontColour = Color.RED;
            }
            JideButton markerURLButton = this.getURLButton(string, baseDBSNPUrl, string, false);
            markerURLButton.setFont(new Font(markerURLButton.getFont().getName(), 0, FONT_SIZE));
            markerURLButton.setForeground(fontColour);
            jp.add((Component)markerURLButton);
            jp.add(this.createLabel(haplotypeGenotype1, false, FONT_SIZE, jp.getBackground(), fontColour));
            jp.add(this.createLabel(haplotypeGenotype2, false, FONT_SIZE, jp.getBackground(), fontColour));
            jp.add(this.createLabel(genotypeStatus, false, FONT_SIZE, jp.getBackground(), fontColour));
            jp.add(this.createLabel(((PGXDBFunctions.PGXMarker)markerLookup.get((Object)string)).chromosome, false, FONT_SIZE, jp.getBackground(), fontColour));
            jp.add(this.createLabel(((PGXDBFunctions.PGXMarker)markerLookup.get((Object)string)).position, false, FONT_SIZE, jp.getBackground(), fontColour));
            jp.add(this.createLabel(((PGXDBFunctions.PGXMarker)markerLookup.get((Object)string)).ref, false, FONT_SIZE, jp.getBackground(), fontColour));
            jp.add(this.createLabel(((PGXDBFunctions.PGXMarker)markerLookup.get((Object)string)).alt, false, FONT_SIZE, jp.getBackground(), fontColour));
            jp.add((Component)this.createLabel(coverage, false, FONT_SIZE, jp.getBackground(), fontColour), "wrap");
        }
    }

    private void addTestedMarkers(JPanel jp, PGXGene pg) {
        try {
            this.makeJPanelRow(jp, Arrays.asList("Marker ID", "Chromosome", "Position", "Reference nucleotide", "Alternate nucleotide"), false);
            for (PGXDBFunctions.PGXMarker pgxm : PGXDBFunctions.getMarkerInfo(pg.getGene())) {
                this.makeJPanelRow(jp, Arrays.asList(pgxm.markerID, pgxm.chromosome, pgxm.position, pgxm.ref, pgxm.alt), true);
            }
        }
        catch (Exception e) {
            this.errorDialog(e.getMessage());
            e.printStackTrace();
        }
    }

    private JPanel getNovelVariantsPanel(PGXGene pg) {
        int FONT_SIZE = 14;
        JPanel novelVariantsJP = new JPanel();
        novelVariantsJP.setBackground(Color.WHITE);
        novelVariantsJP.setLayout((LayoutManager)new MigLayout("fillx, gapx 15px"));
        if (afColumnNames == null) {
            afColumnNames = new LinkedList<String>();
            TableSchema ts = ProjectController.getInstance().getCurrentVariantTableSchema();
            AnnotationManagerAdapter am = MedSavantClient.AnnotationManagerAdapter;
            Map fieldMap = null;
            try {
                LoginController.getInstance();
                fieldMap = am.getAnnotationFieldsByTag(LoginController.getSessionID(), true);
            }
            catch (Exception e) {
                this.errorDialog(e.getMessage());
                e.printStackTrace();
            }
            Set columnNames = (Set)fieldMap.get("Allele Frequency");
            for (CustomField cf : columnNames) {
                afColumnNames.add(cf.getAlias());
            }
        }
        novelVariantsJP.add((Component)this.createLabel("Novel variants are non-synonymous mutations with allele frequencies <= 0.05 (or N/A) across all available AF databases", false, FONT_SIZE), "alignx center, span");
        if (pg.getNovelVariants().size() > 0) {
            novelVariantsJP.add(this.createLabel("Chrom", true, FONT_SIZE));
            novelVariantsJP.add(this.createLabel("Position", true, FONT_SIZE));
            novelVariantsJP.add(this.createLabel("Effect", true, FONT_SIZE));
            novelVariantsJP.add(this.createLabel("Zygosity", true, FONT_SIZE));
            for (String afName : afColumnNames) {
                novelVariantsJP.add(this.createLabel(afName, true, FONT_SIZE));
            }
            novelVariantsJP.add((Component)this.createLabel("dbSNP", true, FONT_SIZE), "wrap");
        } else {
            novelVariantsJP.add((Component)this.createLabel("No rare novel variants detected.", true, 18), "alignx center");
        }
        for (Variant var : pg.getNovelVariants()) {
            novelVariantsJP.add(this.createLabel(var.getChromosome(), false, FONT_SIZE));
            novelVariantsJP.add(this.createLabel(Long.toString(var.getStart()), false, FONT_SIZE));
            novelVariantsJP.add(this.createLabel(var.getMutationType(), false, FONT_SIZE));
            novelVariantsJP.add(this.createLabel(var.getZygosity(), false, FONT_SIZE));
            for (String afName : afColumnNames) {
                BigDecimal afValue = (BigDecimal)var.getColumn(afName);
                String afValueString = "N/A";
                if (afValue != null) {
                    afValueString = afValue.toString();
                }
                novelVariantsJP.add(this.createLabel(afValueString, false, FONT_SIZE));
            }
            String rsID = (String)var.getColumn("snp138, RSID");
            JideButton markerURLButton = this.getURLButton(rsID, baseDBSNPUrl, rsID, false);
            markerURLButton.setFont(new Font(markerURLButton.getFont().getName(), 0, FONT_SIZE));
            novelVariantsJP.add((Component)markerURLButton, "wrap");
        }
        return novelVariantsJP;
    }

    private void errorDialog(String errorMessage) {
        DialogUtils.displayError((String)"Oops!", (String)errorMessage);
        log.error((Object)("[" + this.getClass().getSimpleName() + "]: " + errorMessage));
    }

    private void makeJPanelRow(JComponent container, List<String> textList, boolean markerIDFirst, Color bg) {
        int fontSize = 16;
        boolean isBold = false;
        if (!markerIDFirst) {
            isBold = true;
        }
        for (int i = 0; i != textList.size(); ++i) {
            if (markerIDFirst && i == 0) {
                JideButton jb = this.getURLButton(textList.get(i), baseDBSNPUrl, textList.get(i), false);
                jb.setFont(new Font(jb.getFont().getName(), 0, fontSize));
                jb.setBackground(bg);
                container.add((Component)jb);
                continue;
            }
            if (i < textList.size() - 1) {
                container.add(this.createLabel(textList.get(i), isBold, fontSize, bg, DEFAULT_LABEL_COLOUR));
                continue;
            }
            container.add((Component)this.createLabel(textList.get(i), isBold, fontSize, bg, DEFAULT_LABEL_COLOUR), "wrap");
        }
    }

    private void makeJPanelRow(JComponent container, List<String> textList, boolean markerIDFirst) {
        this.makeJPanelRow(container, textList, markerIDFirst, container.getBackground());
    }

    private JideButton getURLButton(String buttonText, final String baseURL, final String appendToURL, final boolean doEncode) {
        String URL_CHARSET = "UTF-8";
        JideButton urlButton = new JideButton(buttonText);
        urlButton.setButtonStyle(3);
        urlButton.setForeground(Color.BLUE);
        urlButton.setToolTipText("Lookup " + buttonText + " on the web");
        urlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL url = doEncode ? new URL(baseURL + URLEncoder.encode(appendToURL, "UTF-8")) : new URL(baseURL + appendToURL);
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError((String)"Problem launching website: %s", (Throwable)ex);
                }
            }
        });
        return urlButton;
    }

    private ActionListener toggleReferenceAction() {
        ActionListener outputAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PGXPanel.this.currentDNAID != null) {
                    PGXPanel.this.analyzePatient();
                }
            }
        };
        return outputAL;
    }

    private JTextField createLabel(String text, boolean isBold, int size, Color background, Color foreground) {
        JTextField output = new JTextField(text);
        int fontStyle = 0;
        if (isBold) {
            fontStyle = 1;
        }
        output.setFont(new Font(output.getFont().getName(), fontStyle, size));
        output.setEditable(false);
        output.setBackground(background);
        output.setForeground(foreground);
        output.setBorder(BorderFactory.createEmptyBorder());
        return output;
    }

    private JTextField createLabel(String text, boolean isBold, int size) {
        return this.createLabel(text, isBold, size, this.reportInitJP.getBackground(), DEFAULT_LABEL_COLOUR);
    }
}

