/*
 * Decompiled with CFR 0.152.
 */
package pgx;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ut.biolab.medsavant.shared.appdevapi.Variant;
import pgx.PGXGenotype;

public class PGXGene {
    private String gene;
    private List<Variant> variants;
    private String diplotype;
    private String maternalHaplotype;
    private String paternalHaplotype;
    private Map<String, PGXGenotype> maternalGenotypes;
    private Map<String, PGXGenotype> paternalGenotypes;
    private String maternalActivity;
    private String paternalActivity;
    private boolean isPhased = true;
    private String metabolizerClass;
    private List<Variant> novelVariants;

    public PGXGene(String gene) {
        this.gene = gene;
        this.variants = new LinkedList<Variant>();
        this.novelVariants = new LinkedList<Variant>();
    }

    public String getGene() {
        return this.gene;
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    public void addVariant(Variant var) {
        this.variants.add(var);
    }

    public void setDiplotype(String diplotype) {
        this.diplotype = diplotype;
    }

    public void setMaternalHaplotype(String haplotype) {
        this.maternalHaplotype = haplotype;
    }

    public void setPaternalHaplotype(String haplotype) {
        this.paternalHaplotype = haplotype;
    }

    public void setMaternalGenotypes(Map<String, PGXGenotype> genotypesMap) {
        this.maternalGenotypes = genotypesMap;
    }

    public void setPaternalGenotypes(Map<String, PGXGenotype> genotypesMap) {
        this.paternalGenotypes = genotypesMap;
    }

    public String getDiplotype() {
        return this.diplotype;
    }

    public String getMaternalHaplotype() {
        return this.maternalHaplotype;
    }

    public String getPaternalHaplotype() {
        return this.paternalHaplotype;
    }

    public Map<String, PGXGenotype> getMaternalGenotypes() {
        return this.maternalGenotypes;
    }

    public Map<String, PGXGenotype> getPaternalGenotypes() {
        return this.paternalGenotypes;
    }

    public void setUnphased() {
        this.isPhased = false;
    }

    public void setPhased() {
        this.isPhased = true;
    }

    public boolean isPhased() {
        return this.isPhased;
    }

    public void setMaternalActivity(String activity) {
        this.maternalActivity = activity;
    }

    public void setPaternalActivity(String activity) {
        this.paternalActivity = activity;
    }

    public String getMaternalActivity() {
        return this.maternalActivity;
    }

    public String getPaternalActivity() {
        return this.paternalActivity;
    }

    public void setMetabolizerClass(String metabolizer) {
        this.metabolizerClass = metabolizer;
    }

    public String getMetabolizerClass() {
        return this.metabolizerClass;
    }

    public List<Variant> getNovelVariants() {
        return this.novelVariants;
    }

    public void addNovelVariant(Variant novelVar) {
        this.novelVariants.add(novelVar);
    }
}

