/*
 * Decompiled with CFR 0.152.
 */
package pgx;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import jannovar.common.VariantType;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.appdevapi.Variant;
import org.ut.biolab.medsavant.shared.appdevapi.VariantIterator;
import org.ut.biolab.medsavant.shared.db.ColumnDef;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.AnnotationManagerAdapter;
import org.ut.biolab.medsavant.shared.serverapi.VariantManagerAdapter;
import pgx.PGXException;
import pgx.PGXGene;
import pgx.localDB.PGXDB;
import pgx.localDB.PGXDBFunctions;

public class PGXAnalysis {
    private static final String DBSNP_COLUMN = "snp138, RSID";
    private static final int DB_VARIANT_REQUEST_LIMIT = 500;
    public static final double AF_THRESHOLD = 0.05;
    private static final List<String> NOVEL_MUTATIONS = Arrays.asList(VariantType.MISSENSE.toString(), VariantType.FS_DELETION.toString(), VariantType.FS_INSERTION.toString(), VariantType.FS_SUBSTITUTION.toString(), VariantType.FS_DUPLICATION.toString(), VariantType.NON_FS_DELETION.toString(), VariantType.NON_FS_INSERTION.toString(), VariantType.NON_FS_SUBSTITUTION.toString(), VariantType.NON_FS_DUPLICATION.toString(), VariantType.SPLICING.toString(), VariantType.STOPGAIN.toString(), VariantType.START_LOSS.toString());
    private static Connection pgxdbConn;
    private static TableSchema ts;
    private static Map<String, Condition> standardPGXConditions;
    private static Map<String, String> columns;
    private static List<PGXDBFunctions.PGXMarker> listOfAllMarkers;
    private static List<Condition> novelPGXConditions;
    private String dnaID;
    private List<PGXGene> pgxGenes = new LinkedList<PGXGene>();
    private VariantManagerAdapter vma = MedSavantClient.VariantManager;
    private boolean isCancelled = false;

    public PGXAnalysis(String dnaID) throws SQLException, RemoteException, SessionExpiredException, PGXException {
        this.dnaID = dnaID;
        if (pgxdbConn == null) {
            PGXDB.initialize();
            pgxdbConn = PGXDB.getConnection();
        }
        if (standardPGXConditions == null) {
            standardPGXConditions = PGXAnalysis.buildConditionList();
        }
        if (novelPGXConditions == null) {
            novelPGXConditions = PGXAnalysis.buildNovelConditionList();
        }
        if (listOfAllMarkers == null) {
            listOfAllMarkers = PGXAnalysis.getListOfAllMarkers();
        }
        this.queryVariants();
        this.getDiplotypes();
        this.getActivities();
        this.getNovelVariants();
    }

    public List<PGXGene> getGenes() {
        return this.pgxGenes;
    }

    @Deprecated
    private static ComboCondition buildCondition() {
        ComboCondition query = new ComboCondition(ComboCondition.Op.OR);
        List<Object> genes = new LinkedList();
        try {
            genes = PGXDBFunctions.getGenes();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        LinkedList<String> markers = new LinkedList<String>();
        try {
            for (String string : genes) {
                markers.addAll(PGXDBFunctions.getMarkers(string));
            }
        }
        catch (Exception pe) {
            pe.printStackTrace();
        }
        for (String string : markers) {
            query.addCondition((Condition)BinaryCondition.equalTo((Object)ts.getDBColumn(columns.get(DBSNP_COLUMN)), (Object)string));
        }
        return query;
    }

    private static Map<String, Condition> buildConditionList() throws SQLException {
        HashMap<String, Condition> queryMap = new HashMap<String, Condition>();
        for (String g : PGXDBFunctions.getGenes()) {
            ComboCondition query = new ComboCondition(ComboCondition.Op.OR);
            try {
                for (PGXDBFunctions.PGXMarker pgxm : PGXDBFunctions.getMarkerInfo(g)) {
                    ComboCondition variantCondition = new ComboCondition(ComboCondition.Op.AND);
                    variantCondition.addCondition((Condition)BinaryCondition.equalTo((Object)ts.getDBColumn((ColumnDef)BasicVariantColumns.CHROM), (Object)pgxm.chromosome));
                    variantCondition.addCondition((Condition)BinaryCondition.equalTo((Object)ts.getDBColumn((ColumnDef)BasicVariantColumns.START_POSITION), (Object)Integer.parseInt(pgxm.position)));
                    query.addCondition((Condition)variantCondition);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            queryMap.put(g, (Condition)query);
        }
        return queryMap;
    }

    private static List<Condition> buildNovelConditionList() throws SQLException, RemoteException, SessionExpiredException {
        LinkedList<Condition> output = new LinkedList<Condition>();
        ComboCondition mutationCondition = new ComboCondition(ComboCondition.Op.OR);
        for (String mutationEffect : NOVEL_MUTATIONS) {
            mutationCondition.addCondition((Condition)BinaryCondition.iLike((Object)ts.getDBColumn((ColumnDef)BasicVariantColumns.JANNOVAR_EFFECT), (Object)(mutationEffect + "%")));
        }
        output.add((Condition)mutationCondition);
        ComboCondition afCondition = new ComboCondition(ComboCondition.Op.OR);
        AnnotationManagerAdapter am = MedSavantClient.AnnotationManagerAdapter;
        LoginController.getInstance();
        Map fieldMap = am.getAnnotationFieldsByTag(LoginController.getSessionID(), true);
        Set columnNames = (Set)fieldMap.get("Allele Frequency");
        for (CustomField cf : columnNames) {
            DbColumn afColumn = ts.getDBColumn(cf.getColumnName());
            afCondition.addCondition((Condition)BinaryCondition.lessThan((Object)afColumn, (Object)0.05, (boolean)true));
            afCondition.addCondition((Condition)UnaryCondition.isNull((Object)afColumn));
        }
        output.add((Condition)afCondition);
        return output;
    }

    private List<Variant> runRemoteQuery(Condition query) throws SQLException, RemoteException, SessionExpiredException {
        LinkedList<Variant> output = new LinkedList<Variant>();
        Condition[][] conditionMatrix = new Condition[1][1];
        conditionMatrix[0][0] = query;
        int position = 0;
        LoginController.getInstance();
        List rows = this.vma.getVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), conditionMatrix, position, 500);
        VariantIterator variantIterator = new VariantIterator(rows, ProjectController.getInstance().getCurrentAnnotationFormats());
        while (variantIterator.hasNext()) {
            while (variantIterator != null && variantIterator.hasNext()) {
                output.add(variantIterator.next());
            }
            LoginController.getInstance();
            rows = this.vma.getVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), conditionMatrix, position += 500, 500);
            variantIterator = new VariantIterator(rows, ProjectController.getInstance().getCurrentAnnotationFormats());
        }
        return output;
    }

    private void queryVariants() throws SQLException, RemoteException, SessionExpiredException {
        ArrayList<String> allGeneKeys = new ArrayList<String>(standardPGXConditions.keySet());
        Collections.sort(allGeneKeys);
        for (String geneKey : allGeneKeys) {
            PGXGene pgxVariants = new PGXGene(geneKey);
            ComboCondition query = new ComboCondition(ComboCondition.Op.AND);
            query.addCondition((Condition)BinaryCondition.equalTo((Object)ts.getDBColumn((ColumnDef)BasicVariantColumns.DNA_ID), (Object)this.dnaID));
            query.addCondition(standardPGXConditions.get(geneKey));
            List<Variant> retrievedVariants = this.runRemoteQuery((Condition)query);
            for (Variant var : retrievedVariants) {
                pgxVariants.addVariant(var);
            }
            this.pgxGenes.add(pgxVariants);
            if (!this.isCancelled) continue;
            return;
        }
    }

    private void getNovelVariants() throws SQLException, RemoteException, SessionExpiredException, PGXException {
        if (this.isCancelled) {
            return;
        }
        for (PGXGene pg : this.pgxGenes) {
            String geneSymbol = pg.getGene();
            List<PGXDBFunctions.PGXMarker> existingMarkers = PGXDBFunctions.getMarkerInfo(geneSymbol);
            ComboCondition query = new ComboCondition(ComboCondition.Op.AND);
            query.addCondition((Condition)BinaryCondition.equalTo((Object)ts.getDBColumn((ColumnDef)BasicVariantColumns.DNA_ID), (Object)this.dnaID));
            query.addCondition((Condition)BinaryCondition.iLike((Object)ts.getDBColumn((ColumnDef)BasicVariantColumns.JANNOVAR_SYMBOL), (Object)(geneSymbol + "%")));
            query.addCondition((Condition)BinaryCondition.notiLike((Object)ts.getDBColumn((ColumnDef)BasicVariantColumns.GT), (Object)"0%0"));
            for (Condition c : novelPGXConditions) {
                query.addCondition(c);
            }
            List<Variant> potentialNovelVariants = this.runRemoteQuery((Condition)query);
            for (Variant var : potentialNovelVariants) {
                if (this.isKnownPGXMarker(var.getChromosome(), Long.toString(var.getStart()))) continue;
                pg.addNovelVariant(var);
            }
        }
    }

    private void getDiplotypes() {
        if (this.isCancelled) {
            return;
        }
        for (PGXGene pg : this.pgxGenes) {
            try {
                pg.setDiplotype(PGXDBFunctions.getDiplotype(pg));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void getActivities() {
        if (this.isCancelled) {
            return;
        }
        for (PGXGene pg : this.pgxGenes) {
            pg.setMaternalActivity(PGXDBFunctions.getActivities(pg.getGene(), pg.getMaternalHaplotype()));
            pg.setPaternalActivity(PGXDBFunctions.getActivities(pg.getGene(), pg.getPaternalHaplotype()));
            pg.setMetabolizerClass(PGXDBFunctions.getMetabolizerClass(pg.getMaternalActivity(), pg.getPaternalActivity()));
        }
    }

    public static Map<String, String> getDbToHumanReadableMap() {
        HashMap<String, String> dbAliasToNameMap = new HashMap<String, String>();
        try {
            AnnotationFormat[] afs;
            for (AnnotationFormat af : afs = ProjectController.getInstance().getCurrentAnnotationFormats()) {
                for (CustomField field : af.getCustomFields()) {
                    dbAliasToNameMap.put(field.getAlias(), field.getColumnName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbAliasToNameMap;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private static List<PGXDBFunctions.PGXMarker> getListOfAllMarkers() {
        LinkedList<PGXDBFunctions.PGXMarker> output = new LinkedList<PGXDBFunctions.PGXMarker>();
        try {
            for (String gene : PGXDBFunctions.getGenes()) {
                output.addAll(PGXDBFunctions.getMarkerInfo(gene));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    private boolean isKnownPGXMarker(String chromosome, String position) throws PGXException, SQLException {
        boolean pgxMarkerExists = false;
        for (int i = 0; i != listOfAllMarkers.size() && !pgxMarkerExists; ++i) {
            PGXDBFunctions.PGXMarker currentMarker = listOfAllMarkers.get(i);
            if (!currentMarker.chromosome.equals(chromosome) || !currentMarker.position.equals(position)) continue;
            pgxMarkerExists = true;
        }
        return pgxMarkerExists;
    }

    static {
        ts = ProjectController.getInstance().getCurrentVariantTableSchema();
        columns = PGXAnalysis.getDbToHumanReadableMap();
    }
}

