/*
 * Decompiled with CFR 0.152.
 */
package org.javadev.effects;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.javadev.effects.Animation;
import org.javadev.effects.AnimationListener;
import org.javadev.effects.IrisAnimation;

public class IrisAnimation
implements Animation {
    SpecialPanel animationPanel = null;
    private AnimationListener listener = null;
    boolean direction = true;
    int animationDuration = 2000;

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration < 1000 ? 1000 : animationDuration;
    }

    public Component animate(Component toHide, Component toShow, AnimationListener listener) {
        this.listener = listener;
        this.animationPanel = new SpecialPanel(this, toHide, toShow);
        this.animationPanel.needToStartThread = true;
        this.animationPanel.beginAngle = 0.0f;
        this.animationPanel.endAngle = 180.0f;
        this.animationPanel.setAnimationDuration(this.animationDuration);
        return this.animationPanel;
    }

    public Component getAnimationPanel() {
        return this.animationPanel;
    }

    void rotationFinished() {
        SwingUtilities.invokeLater(new 1());
    }

    private final class 1
    implements Runnable {
        public void run() {
            IrisAnimation.this.animationPanel = null;
            IrisAnimation.this.listener.animationFinished();
            IrisAnimation.this.listener = null;
        }

        /* synthetic */ 1() {
        }
    }

    class SpecialPanel
    extends JPanel {
        IrisAnimation owner;
        BufferedImage firstImage;
        BufferedImage secondImage;
        Component component1;
        Component component2;
        float angle = 0.0f;
        public float beginAngle = 0.0f;
        public float endAngle = 360.0f;
        float deltaAngle = 0.5f;
        float effectTime = 2000.0f;
        long dt = Math.round(this.effectTime * this.deltaAngle / 180.0f);
        int counter = 0;
        long totalDrawTime = 0L;
        public boolean needToStartThread = false;

        SpecialPanel(IrisAnimation owner, BufferedImage firstImage, BufferedImage secondImage) {
            this.owner = owner;
            this.firstImage = firstImage;
            this.secondImage = secondImage;
            this.angle = this.beginAngle;
            this.setOpaque(false);
        }

        SpecialPanel(IrisAnimation owner, Component component1, Component component2) {
            this.owner = owner;
            this.component1 = component1;
            this.component2 = component2;
            this.angle = this.beginAngle;
            this.setOpaque(false);
        }

        public void setAnimationDuration(int animationDuration) {
            this.effectTime = animationDuration < 1000 ? 1000 : animationDuration;
            this.dt = Math.round(this.effectTime * this.deltaAngle / 180.0f);
        }

        void startThread(float val1, float val2) {
            this.counter = 0;
            this.totalDrawTime = 0L;
            this.beginAngle = val1;
            this.endAngle = val2;
            this.deltaAngle = this.endAngle < this.beginAngle ? -Math.abs(this.deltaAngle) : Math.abs(this.deltaAngle);
            this.angle = this.beginAngle;
            2 repaint = new 2(this);
            Thread t = new Thread(new 3(this));
            t.start();
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public synchronized void paint(Graphics g) {
            if (this.needToStartThread) {
                this.totalDrawTime = 0L;
                this.counter = 0;
                this.needToStartThread = false;
                this.startThread(this.beginAngle, this.endAngle);
                if (this.firstImage == null) {
                    this.firstImage = this.createImageFromComponent(this.component1);
                }
                if (this.secondImage == null) {
                    this.secondImage = this.createImageFromComponent(this.component2);
                }
            }
            if (this.firstImage == null || this.secondImage == null) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            int ww = this.firstImage.getWidth();
            int hh = this.firstImage.getHeight();
            Object currImage = null;
            Object currPixels = null;
            int w = this.firstImage.getWidth();
            int h = this.firstImage.getHeight();
            int cw = (int)((float)w * this.angle / 180.0f);
            int ch = (int)((float)h * this.angle / 180.0f);
            if (cw < 0) {
                cw = 0;
            }
            if (cw > w) {
                cw = w;
            }
            if (ch < 0) {
                ch = 0;
            }
            if (ch > h) {
                ch = h;
            }
            long beforeDraw = System.currentTimeMillis();
            g2d.drawImage(this.firstImage, null, 0, 0);
            Shape oldClip = g2d.getClip();
            g2d.setClip(new Rectangle(w / 2 - cw / 2, h / 2 - ch / 2, cw, ch));
            g2d.drawImage(this.secondImage, null, 0, 0);
            g2d.setClip(oldClip);
            this.totalDrawTime += System.currentTimeMillis() - beforeDraw;
            ++this.counter;
        }

        BufferedImage createImageFromComponent(Component comp) {
            BufferedImage retImage = null;
            if (comp == null) {
                return retImage;
            }
            try {
                GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = genv.getDefaultScreenDevice();
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                ColorModel cm = gc.getColorModel();
                boolean hasAlpha = cm.hasAlpha();
                int cw = comp.getSize().width;
                int ch = comp.getSize().height;
                retImage = hasAlpha ? gc.createCompatibleImage(cw, ch) : new BufferedImage(cw, ch, 2);
                if (retImage == null) {
                    return retImage;
                }
                Graphics og = retImage.getGraphics();
                comp.paint(og);
                og.dispose();
            }
            catch (Throwable throwable) {}
            return retImage;
        }
    }
}

