/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view;

import java.util.ArrayList;
import pedviz.algorithms.Highlighter;
import pedviz.graph.Node;
import pedviz.view.NodeEvent;
import pedviz.view.NodeListener;

public class LODHighlighter
implements NodeListener {
    public static final int MATERNAL = 2;
    public static final int PATERNAL = 4;
    public static final int MATERNAL_AND_PATERNAL = 8;
    public static final int SUCCESSORS = 16;
    public static final int ANCESTORS = 32;
    public static final int SUCCESSORS_AND_ANCESTORS = 64;
    private int mode = 32;
    private boolean enabled = true;

    public LODHighlighter() {
        this.setMode(32);
    }

    public LODHighlighter(int mode) {
        this.setMode(mode);
    }

    public void onNodeEvent(NodeEvent event) {
        if (this.enabled) {
            switch (event.getType()) {
                case 0: {
                    event.getGraphView().unHighlightAll();
                    ArrayList<Node> nodes = Highlighter.findLineOfDescents(event.getGraph(), event.getNode(), this.mode);
                    event.getGraphView().highlight(nodes);
                    break;
                }
                case 1: {
                    event.getGraphView().unHighlightAll();
                }
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

