/*
 * Decompiled with CFR 0.152.
 */
package pedviz.view;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pedviz.graph.LayoutedGraph;
import pedviz.graph.Node;
import pedviz.view.DefaultNodeView;
import pedviz.view.EdgeView;
import pedviz.view.GraphView;
import pedviz.view.NodeEvent;
import pedviz.view.NodeView;
import pedviz.view.Symbol;
import pedviz.view.rules.Rule;
import pedviz.view.symbols.Symbol2D;
import pedviz.view.symbols.SymbolSexUndesignated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphView2D
extends GraphView {
    private AffineTransform transform;
    private Vector<NodeView> visibleNodes = new Vector();
    private NodeView selNodeview = null;
    private Line2D line = new Line2D.Double();
    private JComponent component;
    private float minSize = 1.0f;
    private int lastOffsetX;
    private int lastOffsetY;
    private GraphView g = this;

    public GraphView2D() {
        this.component = new JPanel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(GraphView2D.this.getBackgroundColor());
                g.fillRect(0, 0, GraphView2D.this.component.getWidth(), GraphView2D.this.component.getHeight());
                GraphView2D.this.drawGraph((Graphics2D)g);
            }
        };
        this.component.setOpaque(true);
        this.component.setDoubleBuffered(true);
        GraphViewHandler handler = new GraphViewHandler();
        this.component.addComponentListener(handler);
        this.component.addMouseListener(handler);
        this.component.addMouseMotionListener(handler);
        this.component.addMouseWheelListener(new ScaleHandler());
    }

    public GraphView2D(LayoutedGraph graph) {
        this();
        this.setGraph(graph);
    }

    @Override
    public void centerGraph() {
        if (this.getGraph() != null) {
            super.centerGraph();
            this.setTranslateX(0.0);
            this.setTranslateY(0.0);
            this.setScale(this.getMinimumZoom());
        }
    }

    @Override
    public void exportJPEG(String filename, float scale, boolean grayscale) {
        BufferedImage img = new BufferedImage((int)(this.graph.getBounds().width * scale), (int)(this.graph.getBounds().height * scale), grayscale ? 10 : 1);
        Graphics2D g = img.createGraphics();
        double x = this.getTranslateX();
        double y = this.getTranslateY();
        double s = this.getScale();
        super.setScale(scale);
        super.setTranslateX(this.graph.getBounds().width * scale / 2.0f);
        super.setTranslateY(this.graph.getBounds().height * scale / 2.0f);
        this.autozoom = false;
        g.setColor(this.getBackgroundColor());
        g.fillRect(0, 0, (int)(this.graph.getBounds().width * scale), (int)(this.graph.getBounds().height * scale));
        g.setClip(0, 0, (int)(this.graph.getBounds().width * scale), (int)(this.graph.getBounds().height * scale));
        this.drawGraph(g);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(img);
            param.setQuality(1.0f, false);
            encoder.encode(img);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.setTranslate(x, y);
        this.setScale(s);
    }

    @Override
    public void updateGraphView() {
        this.component.repaint();
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    private float getMinimumZoom(float widthc, float heightc) {
        if (this.graph != null) {
            float width = this.graph.getBounds().width;
            float height = this.graph.getBounds().height;
            float scaleW = widthc / width;
            float scaleH = heightc / height;
            return Math.min(scaleW, scaleH);
        }
        return 1.0f;
    }

    private float getMinimumZoom() {
        if (this.component != null && this.graph != null) {
            return this.getMinimumZoom(this.component.getWidth(), this.component.getHeight());
        }
        return 1.0f;
    }

    private void drawEdge(Graphics2D g, EdgeView edgeview) {
        NodeView s = null;
        Object start = this.graph.getNodeView(edgeview.getEdge().getStart().getId());
        s = ((DefaultNodeView)start).isExpand() ? edgeview.getStart() : (NodeView)start;
        Object e = this.graph.getNodeView(edgeview.getEdge().getEnd().getId());
        Point2D.Float oldStartPnt = new Point2D.Float(s.getPosX(), s.getPosY());
        Point2D.Float startPnt = this.trans(oldStartPnt);
        Point2D.Float oldEndPnt = new Point2D.Float(((NodeView)e).getPosX(), ((NodeView)e).getPosY());
        Point2D.Float endPnt = this.trans(oldEndPnt);
        float oldSize1 = s.getSize();
        float oldSize2 = ((DefaultNodeView)e).getSize();
        float oldHegight = ((DefaultNodeView)e).getHeight().floatValue();
        float sizeTop = this.transSize(oldSize1, oldStartPnt, startPnt);
        float height = this.transSize(oldHegight, oldStartPnt, startPnt);
        float sizeBottom = this.transSize(oldSize2, oldEndPnt, endPnt);
        float sizeStart = this.transSize(s.getSize(), oldStartPnt, startPnt);
        float gt = this.transSize(this.defaultEdge.getGapTop(), oldStartPnt, startPnt);
        float gb = this.transSize(this.defaultEdge.getGapBottom(), oldEndPnt, endPnt);
        float gaptop = gt + sizeTop / 2.0f + height;
        float gapbottom = gb + sizeBottom / 2.0f;
        this.line.setLine(startPnt.x, startPnt.y + gaptop, endPnt.x, endPnt.y - gapbottom);
        if (g.getClipBounds() != null && this.line.intersects(g.getClipBounds())) {
            this.setPaintMode(g, edgeview.isHidden() && !edgeview.isHighlighted());
            if (edgeview.isHighlighted()) {
                this.setPaintAttr(g, edgeview.getHighlightedColor(), edgeview.getHighlightedWidth());
            } else {
                this.setPaintAttr(g, edgeview.getColor(), edgeview.getWidth());
            }
            g.draw(this.line);
            if (this.isVisible(gaptop)) {
                this.line.setLine(startPnt.x, startPnt.y + sizeStart / 2.0f + height, startPnt.x, startPnt.y + gaptop);
                g.draw(this.line);
            }
            if (this.isVisible(gapbottom)) {
                this.line.setLine(endPnt.x, endPnt.y - gb / 2.0f - sizeBottom / 2.0f, endPnt.x, endPnt.y - gapbottom);
                g.draw(this.line);
            }
        }
        if (edgeview.isConnectChildren() && ((DefaultNodeView)this.graph.getNodeView(edgeview.getEdge().getEnd().getId())).isExpand()) {
            this.setPaintMode(g, true);
            this.setPaintAttr(g, edgeview.getColor(), edgeview.getWidth());
            float posy = endPnt.y - gb / 2.0f - sizeBottom / 2.0f;
            Collections.sort(edgeview.getEnds(), new Comparator<NodeView>(){

                @Override
                public int compare(NodeView arg0, NodeView arg1) {
                    return arg0.compareTo(arg1);
                }
            });
            if (g.getClipBounds() != null && (g.getClipBounds().contains(new Point2D.Float(edgeview.getEnds().get(0).getPosX(), posy)) || g.getClipBounds().contains(new Point2D.Float(edgeview.getEnds().get(edgeview.getEnds().size() - 1).getPosX(), posy)))) {
                boolean u;
                boolean t;
                float posx;
                NodeView end;
                int i;
                for (i = 0; i < edgeview.getEnds().size() / 2; ++i) {
                    end = edgeview.getEnds().get(i);
                    posx = this.transX(end.getPosX());
                    t = false;
                    u = false;
                    for (EdgeView ed : end.getInEdges()) {
                        t = t || ed.isHighlighted();
                        u = u && ed.isHidden();
                    }
                    if (!end.isHidden() && !u) {
                        this.setPaintMode(g, false);
                    }
                    if (end.isHighlighted() && t) {
                        this.setPaintAttr(g, edgeview.getHighlightedColor(), edgeview.getHighlightedWidth());
                        this.setPaintMode(g, false);
                    }
                    float nposx = 0.0f;
                    nposx = i < edgeview.getEnds().size() / 2 - 1 ? this.transX(edgeview.getEnds().get(i + 1).getPosX()) : endPnt.x;
                    this.line.setLine(posx, posy, nposx, posy);
                    g.draw(this.line);
                }
                this.setPaintMode(g, true);
                this.setPaintAttr(g, edgeview.getColor(), edgeview.getWidth());
                for (i = edgeview.getEnds().size() - 1; i >= edgeview.getEnds().size() / 2; --i) {
                    end = edgeview.getEnds().get(i);
                    posx = this.transX(end.getPosX());
                    t = false;
                    u = false;
                    for (EdgeView ed : end.getInEdges()) {
                        t = t || ed.isHighlighted();
                        u = u && ed.isHidden();
                    }
                    if (!end.isHidden() && !u) {
                        this.setPaintMode(g, false);
                    }
                    if (end.isHighlighted() && t) {
                        this.setPaintAttr(g, edgeview.getHighlightedColor(), edgeview.getHighlightedWidth());
                        this.setPaintMode(g, false);
                    }
                    if (i > edgeview.getEnds().size() / 2 + 1) {
                        float nposx = this.transX(edgeview.getEnds().get(i - 1).getPosX());
                        this.line.setLine(posx, posy, nposx, posy);
                    } else {
                        this.line.setLine(posx, posy, endPnt.x, posy);
                    }
                    g.draw(this.line);
                }
            }
        }
    }

    private void drawNode(Graphics2D g, NodeView nodeview) {
        Node node = nodeview.getNode();
        Point2D.Float oldPoint = new Point2D.Float(nodeview.getPosX(), nodeview.getPosY());
        Point2D.Float point = this.trans(oldPoint);
        float size = this.transSize(nodeview.getSize(), oldPoint, point);
        float defaultSize = this.transSize(this.defaultNode.getSize(), oldPoint, point);
        float gapBottom = this.transSize(this.defaultEdge.getGapBottom(), oldPoint, point);
        nodeview.setBounds(point.x, point.y, size);
        if (g.getClipBounds() != null && !g.getClipBounds().intersects(nodeview.getBounds())) {
            return;
        }
        if (!this.isVisible(size)) {
            return;
        }
        if (!nodeview.getNode().isDummy() || nodeview.getNode().isDummy() && !nodeview.isExpand() && nodeview.getNode().getNodeCount() > 0) {
            if (nodeview.getNode().getParent() == null || nodeview.getNode().getParent() != null && ((DefaultNodeView)this.graph.getNodeView(nodeview.getNode().getParent().getId())).isExpand()) {
                Object dad;
                boolean parentsHighlighted = false;
                Object mom = this.graph.getNodeView(node.getIdMom());
                if (mom != null) {
                    boolean bl = parentsHighlighted = parentsHighlighted || ((NodeView)mom).isHighlighted();
                }
                if ((dad = this.graph.getNodeView(node.getIdDad())) != null) {
                    boolean bl = parentsHighlighted = parentsHighlighted || ((NodeView)dad).isHighlighted();
                }
                if (this.defaultEdge.isConnectChildren() && node.hasParents() && this.isVisible(gapBottom / 2.0f)) {
                    Color color = null;
                    float width = -1.0f;
                    if (nodeview.isHighlighted() && parentsHighlighted) {
                        color = this.defaultEdge.getHighlightedColor();
                        width = this.defaultEdge.getHighlightedWidth();
                    } else {
                        color = this.defaultEdge.getColor();
                        width = this.defaultEdge.getWidth();
                    }
                    this.setPaintMode(g, nodeview.isHidden() && !nodeview.isHighlighted());
                    this.setPaintAttr(g, color, width);
                    this.line.setLine(point.x, point.y - size / 2.0f, point.x, point.y - gapBottom / 2.0f - size / 2.0f);
                    g.draw(this.line);
                }
                Color border = nodeview.getBorderColor();
                Color fill = null;
                fill = nodeview.isSelected() ? nodeview.getSelectedColor() : (nodeview.isHighlighted() ? nodeview.getHighlightedColor() : (nodeview.isMouseOver() ? nodeview.getMouseOverColor() : nodeview.getColor()));
                this.setPaintAttr(g, border, nodeview.getBorderWidth());
                this.setPaintMode(g, nodeview.isHidden() && !nodeview.isHighlighted());
                if (nodeview.getSymbols().size() > 0) {
                    for (Symbol symbol1 : nodeview.getSymbols()) {
                        if (!(symbol1 instanceof Symbol2D)) continue;
                        Symbol2D symbol = (Symbol2D)symbol1;
                        symbol.setColors(nodeview.getColors());
                        symbol.drawSymbol(g, point, size, border, fill, nodeview);
                    }
                    if ((double)size * this.getScale() > 1.0) {
                        this.visibleNodes.add(nodeview);
                    }
                } else {
                    SymbolSexUndesignated symbol = new SymbolSexUndesignated();
                    symbol.setColors(nodeview.getColors());
                    ((Symbol2D)symbol).drawSymbol(g, point, defaultSize, border, fill, nodeview);
                    this.visibleNodes.add(nodeview);
                }
            }
        } else if (nodeview.getNode().isDummy() && node.getNodeCount() == 0) {
            this.setPaintMode(g, nodeview.isHidden() && !nodeview.isHighlighted());
            Color color = null;
            float lineWidth = -1.0f;
            if (nodeview.isHighlighted()) {
                color = this.defaultEdge.getHighlightedColor();
                lineWidth = this.defaultEdge.getHighlightedWidth();
            } else if (this.defaultEdge.getColorForLongLines() != null) {
                color = this.defaultEdge.getColorForLongLines();
                lineWidth = this.defaultEdge.getWidth();
            } else {
                color = this.defaultEdge.getColor();
                lineWidth = this.defaultEdge.getWidth();
            }
            this.setPaintAttr(g, color, lineWidth);
            this.line.setLine(point.x, point.y - size / 2.0f - gapBottom / 2.0f, point.x, point.y + size / 2.0f);
            g.draw(this.line);
        }
    }

    private void setPaintAttr(Graphics2D g, Color color, float width) {
        if (!color.equals(g.getColor())) {
            g.setColor(color);
        }
        g.setStroke(new BasicStroke(width));
    }

    private void setPaintMode(Graphics2D g, boolean useAlpha) {
        AlphaComposite composite = null;
        composite = useAlpha ? AlphaComposite.getInstance(3, this.getAlpha()) : AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(composite);
    }

    private void drawHint(Graphics2D g) {
        String text;
        if (this.selNodeview != null && (text = this.selNodeview.getHint()) != null) {
            String[] lines = text.split("\n");
            int hintWidth = 0;
            int lineHeight = g.getFontMetrics().getHeight() + 4;
            int hintHeight = 0;
            for (String hint : lines) {
                if (hint == null) continue;
                if (hint.equals("{line}")) {
                    hintHeight += lineHeight / 2;
                    continue;
                }
                hintHeight += lineHeight;
            }
            for (String hint : lines) {
                int currentWidth = g.getFontMetrics().stringWidth(hint);
                if (currentWidth <= hintWidth) continue;
                hintWidth = currentWidth;
            }
            this.setPaintMode(g, false);
            this.setPaintAttr(g, new Color(255, 255, 225), 1.0f);
            Point2D pos = this.nodeToMouse((float)this.selNodeview.getBounds().getMaxX(), (float)this.selNodeview.getBounds().getMaxY() - this.selNodeview.getHeight().floatValue());
            if (pos.getX() + (double)hintWidth + 20.0 > g.getClipBounds().getMaxX()) {
                pos.setLocation(pos.getX() - (pos.getX() + (double)hintWidth + 20.0 - g.getClipBounds().getMaxX()), pos.getY());
            }
            if (pos.getY() + (double)hintHeight + 17.0 > g.getClipBounds().getMaxY()) {
                pos.setLocation(pos.getX(), pos.getY() - (pos.getY() + (double)hintHeight + 17.0 - g.getClipBounds().getMaxY()));
            }
            g.fillRect((int)pos.getX() + 10, (int)pos.getY() + 4, hintWidth + 6, hintHeight + 3);
            this.setPaintAttr(g, Color.BLACK, 1.0f);
            g.drawRect((int)pos.getX() + 10, (int)pos.getY() + 4, hintWidth + 6, hintHeight + 3);
            int y = lineHeight + (int)pos.getY();
            for (String hint : lines) {
                if (hint == null) continue;
                if (hint.equals("{line}")) {
                    this.setPaintAttr(g, Color.GRAY, 1.0f);
                    g.drawLine((int)pos.getX() + 10, y - lineHeight / 2, (int)pos.getX() + 10 + hintWidth + 6, y - lineHeight / 2);
                    y += lineHeight / 2;
                    this.setPaintAttr(g, Color.BLACK, 1.0f);
                    continue;
                }
                g.drawString(hint, (int)pos.getX() + 13, y);
                y += lineHeight;
            }
        }
    }

    private void drawGraph(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.autozoom) {
            this.centerGraph();
        }
        this.transform = new AffineTransform();
        this.transform.translate(this.getTranslateX(), this.getTranslateY());
        this.transform.scale(this.getScale(), this.getScale());
        g.setTransform(this.transform);
        if (this.graph != null) {
            if (this.isEdgeVisible()) {
                for (Object edgeview : this.graph.getEdges()) {
                    this.drawEdge(g, (EdgeView)edgeview);
                }
            }
            this.visibleNodes.clear();
            for (Object nodeview : this.graph.getAllNodes().values()) {
                this.drawNode(g, (NodeView)nodeview);
            }
            AffineTransform trans = new AffineTransform();
            g.setTransform(trans);
            this.drawHint(g);
        }
    }

    private Point2D mouseToNode(int x, int y) {
        if (this.transform != null) {
            double[] posMouse = new double[4];
            posMouse[0] = x;
            posMouse[1] = y;
            AffineTransform toInternal = null;
            try {
                toInternal = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException nite) {
                // empty catch block
            }
            toInternal.transform(posMouse, 0, posMouse, 0, 1);
            return new Point2D.Double(posMouse[0], posMouse[1]);
        }
        return null;
    }

    private Point2D nodeToMouse(float x, float y) {
        if (this.transform != null) {
            double[] posMouse = new double[4];
            posMouse[0] = x;
            posMouse[1] = y;
            this.transform.transform(posMouse, 0, posMouse, 0, 1);
            return new Point2D.Double(posMouse[0], posMouse[1]);
        }
        return null;
    }

    @Override
    public void setScale(double scale) {
        super.setScale(Math.max((double)this.getMinimumZoom(), scale));
    }

    @Override
    public void setTranslateX(double translateX) {
        if (this.graph != null) {
            if (this.getComponent() != null && (double)this.getComponent().getWidth() >= (double)this.graph.getBounds().width * this.getScale()) {
                super.setTranslateX((float)this.getComponent().getWidth() / 2.0f);
                return;
            }
            if (translateX - this.getTranslateX() >= 0.0) {
                if (-translateX >= (double)this.graph.getBounds().x * this.getScale()) {
                    super.setTranslateX(translateX);
                } else {
                    super.setTranslateX((double)(-this.graph.getBounds().x) * this.getScale());
                }
            }
            if (translateX - this.getTranslateX() <= 0.0) {
                if (this.getComponent() != null) {
                    if (-(translateX - (double)this.getComponent().getWidth()) <= (double)(this.graph.getBounds().x + this.graph.getBounds().width) * this.getScale()) {
                        super.setTranslateX(translateX);
                    } else {
                        super.setTranslateX(-((double)(this.graph.getBounds().x + this.graph.getBounds().width) * this.getScale()) + (double)this.getComponent().getWidth());
                    }
                } else {
                    super.setTranslateX(translateX);
                }
            }
        }
    }

    @Override
    public void setTranslateY(double translateY) {
        if (this.graph != null) {
            if (this.getComponent() != null && (double)this.getComponent().getHeight() >= (double)this.graph.getBounds().height * this.getScale()) {
                super.setTranslateY((float)this.getComponent().getHeight() / 2.0f);
                return;
            }
            if (translateY - this.getTranslateY() >= 0.0) {
                if (-translateY >= (double)this.graph.getBounds().y * this.getScale()) {
                    super.setTranslateY(translateY);
                } else {
                    super.setTranslateY((double)(-this.graph.getBounds().y) * this.getScale());
                }
            }
            if (translateY - this.getTranslateY() <= 0.0) {
                if (this.getComponent() != null) {
                    if (-(translateY - (double)this.getComponent().getHeight()) <= (double)(this.graph.getBounds().y + this.graph.getBounds().height) * this.getScale()) {
                        super.setTranslateY(translateY);
                    } else {
                        super.setTranslateY(-((double)(this.graph.getBounds().y + this.graph.getBounds().height) * this.getScale()) + (double)this.getComponent().getHeight());
                    }
                } else {
                    super.setTranslateY(0.0);
                }
            }
        }
    }

    private float transX(float x) {
        return this.getEffect().transformPoint((float)x, (float)0.0f).x;
    }

    private Point2D.Float trans(Point2D.Float point) {
        return this.getEffect().transformPoint(point.x, point.y);
    }

    private float transSize(float size, Point2D.Float point, Point2D.Float newPoint) {
        return this.getEffect().transformSize(size, point.x, point.y, newPoint.x, newPoint.y);
    }

    private boolean isVisible(float size) {
        return (double)size * this.getScale() > (double)this.minSize;
    }

    @Override
    public void updateNodes(Set<Node> nodes) {
        this.updateGraphView();
    }

    @Override
    public void updateRules() {
        if (this.getGraph() != null) {
            for (Object o : this.getGraph().getAllNodes().values()) {
                NodeView node = (NodeView)o;
                node.reset(this.graph.getDefaultNodeView());
                for (Rule rule : this.getRules()) {
                    if (!rule.isEnabled() || rule.getMode() != 1 && rule.getMode() != 0) continue;
                    rule.applyRule(node);
                }
            }
            this.updateGraphView();
        }
    }

    class GraphViewHandler
    implements ComponentListener,
    MouseListener,
    MouseMotionListener {
        GraphViewHandler() {
        }

        public void componentShown(ComponentEvent arg0) {
            GraphView2D.this.centerGraph();
        }

        public void componentResized(ComponentEvent arg0) {
            GraphView2D.this.centerGraph();
            GraphView2D.this.updateGraphView();
        }

        public void componentMoved(ComponentEvent arg0) {
        }

        public void componentHidden(ComponentEvent arg0) {
        }

        public void mousePressed(MouseEvent e) {
            GraphView2D.this.lastOffsetX = e.getX();
            GraphView2D.this.lastOffsetY = e.getY();
        }

        public void mouseDragged(MouseEvent e) {
            if (GraphView2D.this.graph != null) {
                GraphView2D.this.autozoom = false;
                int newX = e.getX() - GraphView2D.this.lastOffsetX;
                int newY = e.getY() - GraphView2D.this.lastOffsetY;
                GraphView2D.this.lastOffsetX += newX;
                GraphView2D.this.lastOffsetY += newY;
                Point2D point = GraphView2D.this.mouseToNode(e.getX(), e.getY());
                if (point != null && GraphView2D.this.getEffect() != null && GraphView2D.this.graph.getBounds() != null && GraphView2D.this.getEffect().isAutoUpdateOnDrag()) {
                    GraphView2D.this.getEffect().moveFocus((float)(-newX) * GraphView2D.this.effect.getSpeed(), (float)(-newY) * GraphView2D.this.effect.getSpeed());
                    GraphView2D.this.updateGraphView();
                    GraphView2D.this.setCursor(13);
                }
                if ((e.getModifiers() & 0x10) == 16 && GraphView2D.this.isMovingEnabled()) {
                    GraphView2D.this.setTranslateX(GraphView2D.this.getTranslateX() + (double)newX);
                    GraphView2D.this.setTranslateY(GraphView2D.this.getTranslateY() + (double)newY);
                    GraphView2D.this.setCursor(13);
                    GraphView2D.this.component.repaint();
                }
                if ((e.getModifiers() & 4) == 4 && GraphView2D.this.isZoomEnabled()) {
                    GraphView2D.this.setScale(GraphView2D.this.getScale() + (double)newY * 0.1);
                    GraphView2D.this.setCursor(8);
                    GraphView2D.this.component.repaint();
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (GraphView2D.this.graph != null && GraphView2D.this.isSelectionEnabled() && GraphView2D.this.graph.getAllNodes() != null) {
                Point2D point = GraphView2D.this.mouseToNode(e.getX(), e.getY());
                for (NodeView nodeview : GraphView2D.this.visibleNodes) {
                    if (!nodeview.getBounds().contains(point)) continue;
                    if (nodeview.isSelected()) {
                        GraphView2D.this.deselect(nodeview.getNode());
                        GraphView2D.this.fireNodeEvent(new NodeEvent(GraphView2D.this.g, nodeview.getNode(), 3));
                        GraphView2D.this.setCursor(12);
                    } else {
                        GraphView2D.this.select(nodeview.getNode());
                        GraphView2D.this.setCursor(12);
                        GraphView2D.this.fireNodeEvent(new NodeEvent(GraphView2D.this.g, nodeview.getNode(), 2));
                    }
                    return;
                }
                GraphView2D.this.deselect();
                GraphView2D.this.fireNodeEvent(new NodeEvent(GraphView2D.this.g, null, 4));
            }
        }

        public void mouseMoved(MouseEvent e) {
            Point2D point;
            if (GraphView2D.this.graph != null && (point = GraphView2D.this.mouseToNode(e.getX(), e.getY())) != null) {
                if (GraphView2D.this.getEffect() != null && GraphView2D.this.graph.getBounds() != null && GraphView2D.this.getEffect().isAutoUpdateOnMove()) {
                    GraphView2D.this.getEffect().setFocus((float)point.getX(), (float)point.getY());
                    GraphView2D.this.updateGraphView();
                }
                if (GraphView2D.this.graph.getAllNodes() != null && point != null) {
                    for (NodeView nodeview : GraphView2D.this.visibleNodes) {
                        if (!nodeview.getBounds().contains(point)) continue;
                        GraphView2D.this.setCursor(12);
                        if (GraphView2D.this.selNodeview != nodeview) {
                            if (GraphView2D.this.selNodeview != null) {
                                GraphView2D.this.fireNodeEvent(new NodeEvent(GraphView2D.this.g, GraphView2D.this.selNodeview.getNode(), 1));
                                GraphView2D.this.selNodeview.setMouseOver(false);
                            }
                            GraphView2D.this.selNodeview = nodeview;
                            GraphView2D.this.fireNodeEvent(new NodeEvent(GraphView2D.this.g, nodeview.getNode(), 0));
                            nodeview.setMouseOver(true);
                            GraphView2D.this.updateGraphView();
                        }
                        return;
                    }
                    if (GraphView2D.this.selNodeview != null) {
                        GraphView2D.this.selNodeview.setMouseOver(false);
                        GraphView2D.this.component.setCursor(null);
                        GraphView2D.this.fireNodeEvent(new NodeEvent(GraphView2D.this.g, GraphView2D.this.selNodeview.getNode(), 1));
                        GraphView2D.this.selNodeview = null;
                        GraphView2D.this.updateGraphView();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            GraphView2D.this.component.setCursor(null);
        }
    }

    private class ScaleHandler
    implements MouseWheelListener {
        private ScaleHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 0 && GraphView2D.this.isZoomEnabled()) {
                GraphView2D.this.autozoom = false;
                GraphView2D.this.setScale(GraphView2D.this.getScale() + 0.1 * (double)e.getWheelRotation());
                GraphView2D.this.component.repaint();
            }
        }
    }
}

