/*
 * Decompiled with CFR 0.152.
 */
package pedviz.rpedviz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import pedviz.graph.Graph;
import pedviz.view.GraphView;
import pedviz.view.LODHighlighter;
import pedviz.view.rules.ColorRule;
import pedviz.view.rules.Rule;

public abstract class RPedviz
extends JFrame
implements ActionListener {
    protected Graph graph;
    protected GraphView graphView;
    protected ArrayList<Rule> rules;
    protected int mode = 2;
    protected HashMap<String, Integer> data;
    protected LODHighlighter lodHighlighter;
    protected JPanel toolBar;

    public RPedviz(String title) {
        super(title);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.setSize(800, 600);
        this.rules = new ArrayList();
        this.createControls();
    }

    private void createControls() {
        this.data = new HashMap();
        this.data.put("maternal", 2);
        this.data.put("paternal", 4);
        this.data.put("maternal and paternal", 8);
        this.data.put("all ancestors", 32);
        this.data.put("all successors", 16);
        this.data.put("all ancestors and successors", 64);
        JMenuBar menu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem exportGraph = new JMenuItem("Save as csv...");
        exportGraph.setActionCommand("export_graph");
        exportGraph.addActionListener(this);
        JMenuItem exportJpeg = new JMenuItem("Save as jpeg...");
        exportJpeg.setActionCommand("export_jpeg");
        exportJpeg.addActionListener(this);
        JSeparator seperator = new JSeparator();
        JMenuItem exit = new JMenuItem("Exit");
        exit.setActionCommand("exit");
        exit.addActionListener(this);
        fileMenu.add(exportGraph);
        fileMenu.add(exportJpeg);
        fileMenu.add(seperator);
        fileMenu.add(exit);
        menu.add(fileMenu);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.setJMenuBar(menu);
        this.toolBar = new JPanel();
        this.toolBar.setLayout(new BorderLayout());
        this.toolBar.setBackground(Color.WHITE);
        JPanel toolBar2 = new JPanel();
        this.toolBar.add((Component)toolBar2, "After");
        toolBar2.setLayout(new GridLayout(1, 2));
        toolBar2.setBackground(Color.WHITE);
        JComboBox<Object> dataList = new JComboBox<Object>(this.data.keySet().toArray());
        dataList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JComboBox item = (JComboBox)e.getSource();
                RPedviz.this.mode = RPedviz.this.data.get(item.getSelectedItem());
                RPedviz.this.lodHighlighter.setMode(RPedviz.this.mode);
            }
        });
        JLabel caption = new JLabel("Line of Descents: ");
        caption.setHorizontalAlignment(4);
        toolBar2.add((Component)caption, "After");
        toolBar2.add(dataList, "After");
        this.getContentPane().add((Component)this.toolBar, "Last");
    }

    public abstract void plot(String var1, String var2, String[] var3, String[] var4, boolean var5);

    public void plot(String format, String[] args, boolean highlighter) {
        this.plot(format, ";", args, null, highlighter);
    }

    public void plot(String format, String seperator, String[] args, boolean highlighter) {
        this.plot(format, seperator, args, null, highlighter);
    }

    public void plot(String format, String[] args) {
        this.plot(format, ";", args, null, true);
    }

    public void plot(String format, String seperator, String[] args) {
        this.plot(format, seperator, args, null, true);
    }

    public void plot(String format, String[] args, String[] hints) {
        this.plot(format, ";", args, hints, true);
    }

    public void plot(String format, String seperator, String[] args, String[] hints) {
        this.plot(format, seperator, args, hints, true);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addColorRule(String trait, String value, int r, int g, int b) {
        this.rules.add(new ColorRule(trait, value, new Color(r, g, b)));
    }

    public void addColorRule(String[] trait, String[] value, int[] r, int[] g, int[] b) {
        ColorRule rule = new ColorRule(trait[0], value[0], new Color(r[0], g[0], b[0]));
        for (int i = 1; i < trait.length; ++i) {
            rule.addRule(trait[i], value[i], new Color(r[i], g[i], b[i]));
        }
        this.rules.add(rule);
    }

    public void addColorRule(String[] trait, String[] value) {
        int[] r = new int[]{255, 0, 0, 0};
        int[] g = new int[]{0, 255, 0, 255};
        int[] b = new int[]{0, 0, 255, 255};
        this.addColorRule(trait, value, r, g, b);
    }

    public void actionPerformed(ActionEvent arg0) {
        String filename;
        JFileChooser dialog;
        if (arg0.getActionCommand().equals("export_graph")) {
            dialog = new JFileChooser();
            dialog.addChoosableFileFilter(new CSVFilter());
            dialog.setMultiSelectionEnabled(false);
            dialog.showSaveDialog(this);
            if (dialog.getSelectedFile() != null) {
                filename = dialog.getSelectedFile().getPath();
                if (!filename.toLowerCase().endsWith(".csv")) {
                    filename = filename + ".csv";
                }
                this.graph.exportAsCsvFile(filename);
                JOptionPane.showMessageDialog(this, "Wrote File: " + filename, "Export CSV", 1);
            }
        }
        if (arg0.getActionCommand().equals("export_jpeg")) {
            dialog = new JFileChooser();
            dialog.addChoosableFileFilter(new JPEGFilter());
            dialog.setMultiSelectionEnabled(false);
            dialog.showSaveDialog(this);
            if (dialog.getSelectedFile() != null) {
                filename = dialog.getSelectedFile().getPath();
                if (!filename.toLowerCase().endsWith(".jpg")) {
                    filename = filename + ".jpg";
                }
                this.graphView.exportJPEG(filename, 2.0f, false);
                JOptionPane.showMessageDialog(this, "Wrote File: " + filename, "Export JPEG", 1);
            }
        }
        if (arg0.getActionCommand().equals("exit")) {
            this.setVisible(false);
        }
    }

    private class JPEGFilter
    extends FileFilter {
        private JPEGFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".jpg");
        }

        public String getDescription() {
            return "JPEG files (*.jpg)";
        }
    }

    private class CSVFilter
    extends FileFilter {
        private CSVFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".csv");
        }

        public String getDescription() {
            return "CSV files (*.csv)";
        }
    }
}

