/*
 * Decompiled with CFR 0.152.
 */
package pedviz.loader;

import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import pedviz.loader.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDatabase
implements Database {
    private Connection connection;
    private boolean connected = false;
    private String user;
    private String password;
    private String host;
    private String driver;
    private String label;

    public MultiDatabase(String user, String password, String host, String driver) {
        this.user = user;
        this.password = password;
        this.host = host;
        this.driver = driver;
    }

    public MultiDatabase(String filename) {
        try {
            Properties properties = new Properties();
            FileInputStream stream = new FileInputStream(filename);
            properties.load(stream);
            this.user = properties.getProperty("pedvizapi.database.username");
            this.password = properties.getProperty("pedvizapi.database.password");
            this.host = properties.getProperty("pedvizapi.database.url");
            this.driver = properties.getProperty("pedvizapi.database.driver_class");
            this.label = properties.getProperty("pedvizapi.database.label");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public boolean connect(String user, String passord, String host) {
        return this.connect();
    }

    public boolean connect() {
        try {
            this.connected = false;
            Class<?> driver_class = Class.forName(this.driver);
            Constructor<?> c = driver_class.getConstructor(null);
            DriverManager.registerDriver((Driver)c.newInstance(null));
            this.connection = DriverManager.getConnection(this.host, this.user, this.password);
            this.connection.setAutoCommit(false);
            this.connected = true;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return this.connected;
    }

    @Override
    public void close() {
        try {
            this.connection.close();
            this.connected = false;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String getInfo() {
        String result = "";
        try {
            DatabaseMetaData dma = this.connection.getMetaData();
            result = result + "Connected to " + dma.getURL() + "\n";
            result = result + "Driver: " + dma.getDriverName() + "\n";
            result = result + "Version: " + dma.getDriverVersion() + "\n";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    @Override
    public ResultSet executeQuerie(String querie) {
        try {
            Statement stmt = this.connection.createStatement(1004, 1007);
            return stmt.executeQuery(querie);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public Vector<String> getTables() {
        try {
            Vector<String> result = new Vector<String>();
            DatabaseMetaData dbm = this.connection.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet rs = dbm.getTables(null, null, null, types);
            rs.beforeFirst();
            while (rs.next()) {
                String str = rs.getString("TABLE_NAME");
                result.add(str);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public Vector<String> getColumns(String table) {
        try {
            Vector<String> result = new Vector<String>();
            DatabaseMetaData dbm = this.connection.getMetaData();
            ResultSet columns = dbm.getColumns(null, "%", table, "%");
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                result.add(columnName);
            }
            return result;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public String getLabel() {
        return this.label;
    }
}

