/*
 * Decompiled with CFR 0.152.
 */
package pedviz.loader;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Vector;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Node;
import pedviz.loader.Database;
import pedviz.loader.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseGraphLoader
extends Loader {
    private String table;
    private String query = "";
    private Vector<String> columns = null;
    private ArrayList<String> attributes;
    private Database database;

    public DatabaseGraphLoader(Database database, String table) {
        this.database = database;
        this.table = table;
        this.attributes = new ArrayList();
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public void load(Graph graph) {
        ArrayList<Object[]> myEdges = new ArrayList<Object[]>();
        if (this.query.equals("")) {
            this.query = "SELECT * FROM " + this.table;
        }
        try {
            ResultSet rs = this.database.executeQuerie(this.query);
            rs.beforeFirst();
            while (rs.next()) {
                Object id = rs.getObject(this.getIdColumn());
                Node node = new Node(id);
                graph.addNode(node);
                Object idMom = rs.getObject(this.getMomColumn());
                myEdges.add(new Object[]{idMom, id});
                node.setIdMom(idMom);
                Object idDad = rs.getObject(this.getDadColumn());
                myEdges.add(new Object[]{idDad, id});
                node.setIdDad(idDad);
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    node.setUserData(rs.getMetaData().getColumnName(i), rs.getObject(i));
                    if (!rs.isFirst()) continue;
                    this.attributes.add(rs.getMetaData().getColumnName(i));
                }
            }
            for (Object[] edge : myEdges) {
                Node start = graph.getNode(edge[0]);
                Node end = graph.getNode(edge[1]);
                if (start == null || end == null) continue;
                graph.addEdge(new Edge(start, end));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public Vector<String> getColumns() {
        if (this.columns == null) {
            try {
                DatabaseMetaData meta = this.database.getConnection().getMetaData();
                ResultSet rsColumns = meta.getColumns(null, "%", this.table, "%");
                this.columns = new Vector();
                rsColumns.beforeFirst();
                while (rsColumns.next()) {
                    this.columns.add(rsColumns.getString("COLUMN_NAME"));
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return this.columns;
    }

    public ArrayList<String> getAttributes() {
        return this.attributes;
    }
}

