/*
 * Decompiled with CFR 0.152.
 */
package pedviz.haplotype;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import pedviz.haplotype.MerlinError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MerlinErrorChecking {
    private HashMap<Object, MerlinError> errors = new HashMap();

    public MerlinErrorChecking(String filename) {
        this(filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MerlinErrorChecking(String filename, boolean resource) {
        BufferedReader reader = null;
        FileInputStream fis = null;
        try {
            if (resource) {
                reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
            } else {
                File f = new File(filename);
                fis = new FileInputStream(f);
                reader = new BufferedReader(new InputStreamReader(fis));
            }
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                if (line.equals("")) continue;
                String[] tiles = line.trim().split("\\s+");
                String famId = tiles[0];
                String id = tiles[1];
                String marker = tiles[2];
                String ratio = tiles[3];
                this.errors.put(id, new MerlinError(id, marker));
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
        }
    }

    public HashMap<Object, MerlinError> getErrors() {
        return this.errors;
    }
}

