/*
 * Decompiled with CFR 0.152.
 */
package pedviz.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import pedviz.graph.Edge;
import pedviz.graph.Hierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private ArrayList<Edge> outEdges;
    private ArrayList<Edge> inEdges;
    private ArrayList<Node> subNodes;
    protected HashMap<String, Object> userdata;
    private Node parent = null;
    private Object idMom;
    private Object idDad;
    private Object id;
    private boolean dummy = false;
    private int familieRank = -1;
    private Hierarchy hierachie = null;
    private int level = -1;

    public Node(Object id) {
        this.id = id;
        this.outEdges = new ArrayList();
        this.inEdges = new ArrayList();
        this.subNodes = new ArrayList();
        this.userdata = new HashMap();
    }

    public Object clone() {
        Node node = new Node(this.id);
        node.setDummy(this.dummy);
        node.setIdMom(this.idMom);
        node.setIdDad(this.idDad);
        for (Node subNode : this.getNodes()) {
            Node subNodeClone = (Node)subNode.clone();
            subNodeClone.setParent(node);
            node.addNode(subNodeClone);
        }
        node.userdata = (HashMap)this.userdata.clone();
        return node;
    }

    public int getInDegree() {
        return this.inEdges.size();
    }

    public int getOutDegree() {
        return this.outEdges.size();
    }

    public Object getId() {
        return this.id;
    }

    public ArrayList<Edge> getInEdges() {
        return this.inEdges;
    }

    public ArrayList<Edge> getOutEdges() {
        return this.outEdges;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public ArrayList<Node> getNodes() {
        return this.subNodes;
    }

    public void setUserData(String title, Object data) {
        this.userdata.put(title.toUpperCase(), data);
    }

    public Object getUserData(String title) {
        return this.userdata.get(title.toUpperCase());
    }

    public Object[] getUserDataList() {
        return this.userdata.keySet().toArray();
    }

    public Node getParent() {
        return this.parent;
    }

    public int getFamilieRank() {
        return this.familieRank;
    }

    public void setFamilieRank(int familieRank) {
        this.familieRank = familieRank;
    }

    public Set<Node> getParentsAndChilds(int max) {
        HashSet<Node> result = new HashSet<Node>();
        result.addAll(this.getParents(0, max - 1));
        result.addAll(this.getChilds(this.getId(), 0, max - 1));
        return result;
    }

    public Set<Node> getParentsAndChilds() {
        HashSet<Node> result = new HashSet<Node>();
        result.addAll(this.getParents(0, -1));
        result.addAll(this.getChilds(this.getId(), 0, -1));
        return result;
    }

    public Set<Node> getParents() {
        return this.getParents(0, -1);
    }

    public Set<Node> getParents(int max) {
        return this.getParents(0, max - 1);
    }

    public Set<Node> getChilds() {
        return this.getChilds(this.getId(), 0, -1);
    }

    public Set<Node> getChilds(int max) {
        return this.getChilds(this.getId(), 0, max - 1);
    }

    public Object getIdDad() {
        return this.idDad;
    }

    public void setIdDad(Object idDad) {
        this.idDad = idDad;
    }

    public Object getIdMom() {
        return this.idMom;
    }

    public void setIdMom(Object idMom) {
        this.idMom = idMom;
    }

    public int getNodeCount() {
        return this.subNodes.size();
    }

    public int getDegree() {
        return this.getInDegree() + this.getOutDegree();
    }

    public boolean hasParents() {
        if (this.parent == null) {
            return this.getInDegree() > 0;
        }
        return this.parent.getInDegree() > 0;
    }

    public Set<Node> getPathTo(Node node) {
        HashSet<Node> result = new HashSet<Node>();
        if (this.parent == null) {
            for (Edge edge : this.getInEdges()) {
                if (edge.getStart().isDummy() && edge.getStart().getNodeCount() == 0) {
                    if (!edge.getStart().getParents().contains(node)) continue;
                    result.add(edge.getStart());
                    result.addAll(edge.getStart().getPathTo(node));
                    continue;
                }
                if (!edge.getStart().isDummy()) {
                    if (!edge.getStart().getParents().contains(node)) continue;
                    result.add(edge.getStart());
                    result.addAll(edge.getStart().getPathTo(node));
                    continue;
                }
                for (Node node3 : edge.getStart().getNodes()) {
                    Set<Node> l;
                    if (!node3.getId().equals(this.getIdMom()) && !node3.getId().equals(this.getIdDad()) || !(l = node3.getParents()).contains(node)) continue;
                    result.add(node3);
                    result.addAll(node3.getPathTo(node));
                }
            }
        } else {
            result.addAll(this.parent.getPathTo(node));
        }
        return result;
    }

    public int getLevel() {
        return this.level;
    }

    public Hierarchy getHierarchy() {
        return this.hierachie;
    }

    protected void removeNode(Node node) {
        this.subNodes.remove(node);
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    protected void addNode(Node node) {
        this.subNodes.add(node);
    }

    protected void addInEdge(Edge edge) {
        this.inEdges.add(edge);
    }

    protected void removeInEdge(Edge edge) {
        this.inEdges.remove(edge);
    }

    protected void addOutEdge(Edge edge) {
        this.outEdges.add(edge);
    }

    protected void removeOutEdge(Edge edge) {
        this.outEdges.remove(edge);
    }

    private Set<Node> getParents(int current, int max) {
        HashSet<Node> result = new HashSet<Node>();
        if (this.parent == null) {
            for (Edge edgeIn : this.getInEdges()) {
                Node parent = edgeIn.getStart();
                for (Node node : parent.getNodes()) {
                    if (!node.getId().equals(this.getIdMom()) && !node.getId().equals(this.getIdDad())) continue;
                    result.add(node);
                }
                result.add(parent);
                if (max != -1 && current >= max && (!parent.isDummy() || parent.getNodeCount() != 0)) continue;
                result.addAll(parent.getParents(current + 1, max));
            }
        } else {
            result.addAll(this.parent.getParents(current + 1, max));
        }
        return result;
    }

    private Set<Node> getChilds(Object id, int current, int max) {
        HashSet<Node> result = new HashSet<Node>();
        if (this.parent == null) {
            for (Edge edgeOut : this.getOutEdges()) {
                Node child = edgeOut.getEnd();
                if (child.getNodes().size() == 0 && (id.equals(-1) || id.equals(child.getIdMom()) || id.equals(child.getIdDad()))) {
                    result.add(edgeOut.getEnd());
                    if (max == -1 || current < max || child.isDummy() && child.getNodeCount() == 0) {
                        result.addAll(child.getChilds(-1, current + 1, max));
                    }
                }
                for (Node node : child.getNodes()) {
                    if (!id.equals(-1) && !id.equals(node.getIdMom()) && !id.equals(node.getIdDad())) continue;
                    result.add(node);
                    if (max != -1 && current >= max && (!node.isDummy() || node.getNodeCount() != 0)) continue;
                    result.addAll(node.getChilds(-1, current + 1, max));
                }
            }
        } else {
            result.addAll(this.parent.getChilds(id, current, max));
        }
        return result;
    }

    protected void setLevel(int layer) {
        this.level = layer;
        for (Node node : this.getNodes()) {
            node.setLevel(layer);
        }
    }

    protected void setHierachie(Hierarchy hierachie) {
        this.hierachie = hierachie;
    }

    public String toString() {
        return this.getId().toString();
    }
}

