/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms.sugiyama;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import pedviz.algorithms.sugiyama.SugiyamaEdgeView;
import pedviz.graph.Node;
import pedviz.view.DefaultNodeView;
import pedviz.view.EdgeView;
import pedviz.view.NodeView;

public class SugiyamaNodeView
extends NodeView {
    private float barycentric = Float.MAX_VALUE;

    public SugiyamaNodeView(Node node, DefaultNodeView defaultNodeView) {
        super(node, defaultNodeView);
    }

    public float getBarycentric() {
        return this.barycentric;
    }

    public void setBarycentric(float barycentric) {
        this.barycentric = barycentric;
    }

    public void sortSubNodes() {
        final HashMap<Object, SugiyamaNodeView> n = new HashMap<Object, SugiyamaNodeView>();
        for (NodeView v : this.getNodes()) {
            SugiyamaNodeView subNodeView = (SugiyamaNodeView)v;
            n.put(subNodeView.getNode().getId(), subNodeView);
            float barycenter = 0.0f;
            float sum = 0.0f;
            for (EdgeView edge : subNodeView.getOutEdges()) {
                SugiyamaEdgeView e = (SugiyamaEdgeView)edge;
                sum += e.getEnd().getPosX() - this.getPosX();
            }
            if (subNodeView.getOutEdges().size() > 0) {
                barycenter = sum / (float)subNodeView.getOutEdges().size();
            }
            subNodeView.setBarycentric(barycenter);
        }
        Collections.sort(this.getNode().getNodes(), new Comparator<Node>(){

            @Override
            public int compare(Node arg0, Node arg1) {
                return new Float(((SugiyamaNodeView)n.get(arg0.getId())).getBarycentric()).compareTo(Float.valueOf(((SugiyamaNodeView)n.get(arg1.getId())).getBarycentric()));
            }
        });
        n.clear();
    }

    public int compareTo(Object arg0) {
        return new Float(this.getBarycentric()).compareTo(Float.valueOf(((SugiyamaNodeView)arg0).getBarycentric()));
    }
}

