/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.event.ChangeListener;
import pedviz.algorithms.sugiyama.Splitter;
import pedviz.algorithms.sugiyama.SugiyamaEdgeView;
import pedviz.algorithms.sugiyama.SugiyamaNodeView;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Hierarchy;
import pedviz.graph.Layout;
import pedviz.graph.Node;
import pedviz.view.DefaultEdgeView;
import pedviz.view.DefaultNodeView;
import pedviz.view.NodeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugiyamaLayout
extends Layout<SugiyamaNodeView, SugiyamaEdgeView> {
    private Splitter splitter = null;
    ChangeListener changeListener;
    int percent = 0;

    public SugiyamaLayout(Graph graph, DefaultNodeView defaultNodeView, DefaultEdgeView defaulEdgeView) {
        super(graph, defaultNodeView, defaulEdgeView);
    }

    public Splitter getSplitter() {
        return this.splitter;
    }

    public void setSplitter(Splitter splitter) {
        this.splitter = splitter;
    }

    @Override
    public void run() {
        if (this.graph.getHierachiesCount() <= 0) {
            System.out.println("Error: Sugiyama needs a graph with a hierarchie.");
            return;
        }
        this.split();
        this.minCrossing(200);
        this.graph.setLayouted(true);
    }

    @Override
    public String getMessage() {
        return "Layout Pedigree...";
    }

    @Override
    public int getPercentComplete() {
        return this.percent;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    private void updateIndex(ArrayList<Node> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            Object t = this.layoutedGraph.getNodeView(nodes.get(i).getId());
            if (t == null) continue;
            ((NodeView)t).setPosX(i);
        }
    }

    private boolean improveLayer(int id, int layer1, int layer2) {
        ArrayList<Node> oldOrder = this.graph.getHierachy(id).getNodes(layer2);
        boolean change = false;
        if (oldOrder != null) {
            for (Node currentNode : oldOrder) {
                int sum = 0;
                int n = 0;
                if (layer2 > layer1) {
                    n = currentNode.getInDegree();
                    for (Edge edge : currentNode.getInEdges()) {
                        sum = (int)((float)sum + ((NodeView)this.layoutedGraph.getNodeView(edge.getStart().getId())).getPosX());
                    }
                } else {
                    n = currentNode.getOutDegree();
                    for (Edge edge : currentNode.getOutEdges()) {
                        sum = (int)((float)sum + ((NodeView)this.layoutedGraph.getNodeView(edge.getEnd().getId())).getPosX());
                    }
                }
                float value = ((SugiyamaNodeView)this.layoutedGraph.getNodeView(currentNode.getId())).getBarycentric();
                if (n > 0) {
                    value = (float)sum / (float)n;
                }
                ((SugiyamaNodeView)this.layoutedGraph.getNodeView(currentNode.getId())).setBarycentric(value);
                change = true;
            }
            if (change) {
                Collections.sort(oldOrder, new Comparator<Node>(){

                    @Override
                    public int compare(Node arg0, Node arg1) {
                        return new Float(((SugiyamaNodeView)SugiyamaLayout.this.layoutedGraph.getNodeView(arg0.getId())).getBarycentric()).compareTo(Float.valueOf(((SugiyamaNodeView)SugiyamaLayout.this.layoutedGraph.getNodeView(arg1.getId())).getBarycentric()));
                    }
                });
                this.updateIndex(oldOrder);
            }
        }
        return change;
    }

    private void minCrossing(int maxIteration) {
        for (int i = 0; i < this.graph.getHierachiesCount(); ++i) {
            Hierarchy hierarchie = this.graph.getHierachy(i);
            for (Integer j : hierarchie.getNodes().keySet()) {
                ArrayList<Node> nodes = this.graph.getHierachy(i).getNodes(j);
                if (nodes == null) continue;
                this.updateIndex(nodes);
            }
        }
        for (int iteration = 0; iteration < maxIteration; ++iteration) {
            int id;
            for (id = 0; id < this.graph.getHierachiesCount(); ++id) {
                for (int i = this.graph.getHierachy(id).getLevelSize() - 1; i > 0; --i) {
                    this.improveLayer(id, i, i - 1);
                }
            }
            for (id = 0; id < this.graph.getHierachiesCount(); ++id) {
                for (int i = 0; i < this.graph.getHierachy(id).getLevelSize() - 1; ++i) {
                    this.improveLayer(id, i, i + 1);
                }
            }
            this.fireChangeListener(Math.round(iteration * 100 / maxIteration));
        }
        for (int id = 0; id < this.graph.getHierachiesCount(); ++id) {
            for (int i = this.graph.getHierachy(id).getLevelSize() - 1; i > 0; --i) {
                this.improveLayer(id, i, i - 1);
            }
        }
    }

    private void split() {
        if (this.splitter != null) {
            this.graph.removeAllHierachies();
            this.splitter.beforeSplit(this.graph);
            int index = 0;
            new Hierarchy(this.graph);
            new Hierarchy(this.graph);
            for (Node node : this.graph.getNodes()) {
                int wall = this.splitter.getWall(this.graph, node, index);
                this.graph.getHierachy(wall).addNode(node.getLevel(), node);
                ++index;
            }
            this.splitter.afterSplit(this.graph);
        } else {
            this.graph.removeAllHierachies();
            Hierarchy h = new Hierarchy(this.graph);
            for (Node node : this.graph.getNodes()) {
                h.addNode(node.getLevel(), node);
            }
        }
    }

    private void fireChangeListener(int percent) {
        if (this.changeListener != null) {
            this.percent = percent;
            this.changeListener.stateChanged(null);
        }
    }

    @Override
    public SugiyamaNodeView createNodeView(Node node, DefaultNodeView defaultNodeView) {
        return new SugiyamaNodeView(node, defaultNodeView);
    }

    @Override
    public SugiyamaEdgeView createEdgeView(Edge edge, DefaultEdgeView defaultEdgeView) {
        return new SugiyamaEdgeView(edge, defaultEdgeView);
    }
}

