/*
 * Decompiled with CFR 0.152.
 */
package pedviz.algorithms.magiceye;

import java.util.Iterator;
import javax.vecmath.Point3d;
import pedviz.algorithms.magiceye.MagicEyeEdgeView;
import pedviz.algorithms.magiceye.MagicEyeNodeView;
import pedviz.algorithms.magiceye.MagicEyeTree;
import pedviz.graph.Edge;
import pedviz.graph.Graph;
import pedviz.graph.Layout;
import pedviz.graph.Node;
import pedviz.view.DefaultEdgeView;
import pedviz.view.DefaultNodeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagicEyeLayout
extends Layout<MagicEyeNodeView, MagicEyeEdgeView> {
    private int maxDepth;
    private final double siblingSeparation = 0.8;
    private final double subtreeSeparation = 2.0;
    private double xTopAdjustment;
    private MagicEyeNodeView Root;
    private MagicEyeNodeView[] prevNodeList;
    private MagicEyeNodeView[] prevNodeListSav;
    private final double _PI = Math.PI;
    private double minx;
    private double maxx;
    private double scalex;
    private double scaley;
    private double start;
    private double end;
    private double size;
    private boolean hemisphere = true;
    private boolean CURVED_EDGES = false;
    private float radius = 100.0f;
    public static final int LINES_PER_EDGE = 10;
    private double REZ_LINES_PER_EDGE = 0.1;
    public static final int INNER_EDGE_POINTS = 9;
    public static final float MIN_EDGE_WIDTH = 1.3f;
    public static final float MAX_EDGE_WIDTH = 6.0f;
    public static final float MARKED_EDGE_WIDTH_OFFSET = 1.0f;
    public static final double SATURATION_EXP = 0.167;
    public static final float MIN_EDGE_SATURATION = 0.1f;
    public static final float MAX_EDGE_SATURATION = 1.0f;
    public static final float EDGE_H = 0.7f;
    public static final float EDGE_B = 0.75f;
    public static final float MARKED_EDGE_H = 0.35f;
    public static final float MARKED_EDGE_B = 0.6f;
    public static final int SPHERE_DETAIL = 20;
    public static final boolean USE_SMOOTH_LINES = false;
    public static final boolean STARTUP_WITH_FOCUS_NODES = true;
    public static final boolean FOCUS_ANIMATION = true;
    static int FOLDING_THRESHOLD = 20;
    static int FFEV_THRESHOLD = 5;
    private final int LAYOUT_WALKER = 0;
    private final int LAYOUT_WALKER_MOD1 = 1;
    private final int LAYOUT_WALKER_MOD2 = 2;
    private final int LAYOUT_WALKER_MOD3 = 3;
    private final int LAYOUT_WALKER_MOD4 = 4;
    private final int LAYOUT_WALKER_MOD5 = 5;
    int layouter = 1;

    public MagicEyeLayout(Graph graph, DefaultNodeView defaultNodeView, DefaultEdgeView defaulEdgeView) {
        super(graph, defaultNodeView, defaulEdgeView);
    }

    @Override
    public void run() {
        Node root = this.graph.getHierachy(0).getNodes(0).get(0);
        MagicEyeTree npTree = new MagicEyeTree(this.getLayoutGraph(), root);
        this.layout(this.layouter, npTree.root);
        this.layout(this.layouter, npTree.root);
        Iterator<MagicEyeNodeView> i$ = npTree.nodes.values().iterator();
        while (i$.hasNext()) {
            MagicEyeNodeView o;
            MagicEyeNodeView p = o = i$.next();
            if (this.hemisphere) {
                p.setPosX(p.getPosX() * this.radius);
                float temp = p.getPosY();
                p.setPosY(p.getPosZ() * this.radius - this.radius / 2.0f);
                p.setPosZ(temp * this.radius);
                continue;
            }
            p.setPosX(p.getPosX() * this.radius * 6.0f);
            p.setPosY(p.getPosY() * this.radius * 6.0f - 50.0f);
            p.setPosZ(p.getPosZ() * this.radius * 6.0f);
        }
    }

    @Override
    public MagicEyeNodeView createNodeView(Node node, DefaultNodeView defaultNodeView) {
        return new MagicEyeNodeView(node, defaultNodeView);
    }

    @Override
    public MagicEyeEdgeView createEdgeView(Edge edge, DefaultEdgeView defaultEdgeView) {
        return new MagicEyeEdgeView(edge, defaultEdgeView);
    }

    public void layout(int layouter, MagicEyeNodeView root) {
        if (root == null) {
            return;
        }
        this.Root = root;
        this.init();
        this.firstWalk(this.Root, 0);
        this.xTopAdjustment = this.Root.x - this.Root.prelim;
        this.secondWalk(this.Root, 0, 0.0);
        if (layouter != 0) {
            this.project2Hemisphere(Math.PI, 0.0, this.Root);
            double weightSum = 0.0;
            double[] weight = new double[this.Root.numChilds];
            switch (layouter) {
                case 1: {
                    int i;
                    for (i = 0; i < this.Root.numChilds; ++i) {
                        weight[i] = this.Root.getChild((int)i).strahlerNumber;
                        weightSum += weight[i];
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < this.Root.numChilds; ++i) {
                        weight[i] = this.Root.getChild((int)i).numChilds;
                        weightSum += weight[i];
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < this.Root.numChilds; ++i) {
                        weight[i] = this.Root.getChild((int)i).leaves;
                        weightSum += weight[i];
                    }
                    break;
                }
                case 4: {
                    int i;
                    for (i = 0; i < this.Root.numChilds; ++i) {
                        weight[i] = this.Root.getChild((int)i).nodes;
                        weightSum += weight[i];
                    }
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < this.Root.numChilds; ++i) {
                        weight[i] = 1.0;
                    }
                    weightSum = this.Root.numChilds;
                }
            }
            if (layouter != 5) {
                double minSize = weightSum / 18.0;
                boolean[] correction = new boolean[this.Root.numChilds];
                double correctionSum = 0.0;
                double restWeightSum = weightSum;
                for (int i = 0; i < this.Root.numChilds; ++i) {
                    if (weight[i] > minSize) {
                        correction[i] = true;
                        continue;
                    }
                    correction[i] = false;
                    correctionSum += minSize - weight[i];
                    restWeightSum -= weight[i];
                    weight[i] = minSize;
                }
                if (restWeightSum > 0.0) {
                    double div = correctionSum / restWeightSum;
                    for (int i = 0; i < this.Root.numChilds; ++i) {
                        if (!correction[i]) continue;
                        int n = i;
                        weight[n] = weight[n] - weight[i] * div;
                    }
                }
            }
            this.start = 0.0;
            this.scaley = 1.5707963267948966 / (double)this.Root.depth;
            for (int i = 0; i < this.Root.numChilds; ++i) {
                MagicEyeNodeView n = this.Root.getChild(i);
                this.size = Math.PI * 2 * weight[i] / weightSum;
                this.end = this.start + this.size;
                this.minx = this.getMinX(n);
                this.maxx = this.getMaxX(n);
                this.adjustMaxX();
                this.scalex = (this.end - this.start) / (this.maxx - this.minx);
                this.project2Hemisphere((n.x - this.minx) * this.scalex + this.start, (double)n.level * this.scaley, n);
                this.edgeToRoot(n);
                this.subtree2Flatmap(n);
                this.start = this.end;
            }
        } else {
            this.adjustMaxX();
            this.start = 0.0;
            this.end = Math.PI * 2;
            this.scalex = (this.end - this.start) / (this.maxx - this.minx);
            this.scaley = 1.5707963267948966 / (double)this.Root.depth;
            this.makeFlatMap(this.Root);
        }
    }

    private void init() {
        this.initPrevNodeList();
        this.maxDepth = Integer.MAX_VALUE;
        this.minx = Double.MAX_VALUE;
        this.maxx = Double.MIN_VALUE;
    }

    private void firstWalk(MagicEyeNodeView n, int level) {
        n.leftNeighbor = this.getPrevNodeAtLevel(level);
        this.setPrevNodeAtLevel(level, n);
        n.modifier = 0.0;
        if (n.isLeaf() || n.firstChild() == null || level == this.maxDepth) {
            n.prelim = n.hasLeftSibling() ? n.leftSibling().prelim + 0.8 + this.meanNodeSize(n.leftSibling(), n) : 0.0;
        } else {
            MagicEyeNodeView rightMost;
            MagicEyeNodeView leftMost = rightMost = n.firstChild();
            this.firstWalk(leftMost, level + 1);
            while (rightMost.hasRightSibling()) {
                rightMost = rightMost.rightSibling();
                this.firstWalk(rightMost, level + 1);
            }
            double midPoint = (leftMost.prelim + rightMost.prelim) / 2.0;
            if (n.hasLeftSibling()) {
                n.prelim = n.leftSibling().prelim + 0.8 + this.meanNodeSize(n.leftSibling(), n);
                n.modifier = n.prelim - midPoint;
                this.apportion(n, level);
            } else {
                n.prelim = midPoint;
            }
        }
    }

    private void secondWalk(MagicEyeNodeView n, int level, double modSum) {
        if (n.visible && level <= this.maxDepth) {
            double xTemp;
            n.x = xTemp = this.xTopAdjustment + n.prelim + modSum;
            if (n.x > this.maxx) {
                this.maxx = n.x;
            } else if (n.x < this.minx) {
                this.minx = n.x;
            }
            for (int i = 0; i < n.numChilds; ++i) {
                this.secondWalk(n.getChild(i), level + 1, modSum + n.modifier);
            }
        }
    }

    private void apportion(MagicEyeNodeView n, int level) {
        MagicEyeNodeView leftMost = n.firstChild();
        MagicEyeNodeView neighbor = null;
        if (leftMost != null) {
            neighbor = leftMost.leftNeighbor;
        }
        int compareDepth = 1;
        int depthToStop = this.maxDepth - level;
        while (leftMost != null && neighbor != null && compareDepth <= depthToStop) {
            double rightModSum = 0.0;
            double leftModSum = 0.0;
            MagicEyeNodeView ancestorLeftMost = leftMost;
            MagicEyeNodeView ancestorNeighbor = neighbor;
            for (int i = 0; i < compareDepth; ++i) {
                ancestorLeftMost = ancestorLeftMost.parent;
                ancestorNeighbor = ancestorNeighbor.parent;
                rightModSum += ancestorLeftMost.modifier;
                leftModSum += ancestorNeighbor.modifier;
            }
            double moveDistance = neighbor.prelim + leftModSum + 2.0 + this.meanNodeSize(leftMost, neighbor) - (leftMost.prelim + rightModSum);
            if (moveDistance > 0.0) {
                MagicEyeNodeView temp;
                int leftSiblings = 0;
                for (temp = n; temp != null && temp != ancestorNeighbor; temp = temp.leftSibling()) {
                    ++leftSiblings;
                }
                if (temp == null) break;
                double portion = moveDistance / (double)leftSiblings;
                for (temp = n; temp != ancestorNeighbor; temp = temp.leftSibling()) {
                    temp.prelim += moveDistance;
                    temp.modifier += moveDistance;
                    moveDistance -= portion;
                }
            }
            if ((leftMost = leftMost.isLeaf() ? this.getLeftMost(n, 0, ++compareDepth) : leftMost.firstChild()) == null) continue;
            neighbor = leftMost.leftNeighbor;
        }
    }

    private MagicEyeNodeView getLeftMost(MagicEyeNodeView n, int level, int depth) {
        MagicEyeNodeView rightMost = null;
        MagicEyeNodeView leftMost = null;
        if (level >= depth) {
            return n;
        }
        if (n.isLeaf()) {
            return null;
        }
        rightMost = n.firstChild();
        leftMost = this.getLeftMost(rightMost, level + 1, depth);
        while (leftMost == null && rightMost.hasRightSibling()) {
            rightMost = rightMost.rightSibling();
            leftMost = this.getLeftMost(rightMost, level + 1, depth);
        }
        return leftMost;
    }

    private void initPrevNodeList() {
        this.prevNodeList = new MagicEyeNodeView[this.Root.depth + 1];
        this.prevNodeListSav = new MagicEyeNodeView[this.Root.depth + 1];
        for (int i = 0; i < this.prevNodeList.length; ++i) {
            this.prevNodeList[i] = null;
            this.prevNodeListSav[i] = null;
        }
    }

    private MagicEyeNodeView getPrevNodeAtLevel(int level) {
        return this.prevNodeList[level];
    }

    private void setPrevNodeAtLevel(int level, MagicEyeNodeView n) {
        this.prevNodeListSav[level] = this.prevNodeList[level];
        this.prevNodeList[level] = n;
    }

    private double meanNodeSize(MagicEyeNodeView leftNode, MagicEyeNodeView rightNode) {
        return 0.0;
    }

    private void adjustMaxX() {
        this.maxx += 1.0;
        this.minx -= 1.0;
    }

    private void makeFlatMap(MagicEyeNodeView n) {
        this.project2Hemisphere(this.scalex * (n.x - this.minx) + this.start, this.scaley * (double)n.level, n);
        if (n.parent != null) {
            if (n.parent == this.Root) {
                double xInc = (double)(n.getPosX() - this.Root.getPosX()) * this.REZ_LINES_PER_EDGE;
                double yInc = (double)(n.getPosY() - this.Root.getPosY()) * this.REZ_LINES_PER_EDGE;
                double zInc = (double)(n.getPosZ() - this.Root.getPosZ()) * this.REZ_LINES_PER_EDGE;
                double x = this.Root.getPosX();
                double y = this.Root.getPosY();
                double z = this.Root.getPosZ();
                for (int i = 0; i < 9; ++i) {
                    n.pEdgePoints[i].set(x += xInc, y += yInc, z += zInc);
                }
            } else if (this.CURVED_EDGES) {
                double lambdaInc = (n.lambda - n.parent.lambda) * this.REZ_LINES_PER_EDGE;
                double phiInc = (n.phi - n.parent.phi) * this.REZ_LINES_PER_EDGE;
                double lambda = n.parent.lambda;
                double phi = n.parent.phi;
                for (int i = 0; i < 9; ++i) {
                    this.project2Hemisphere(lambda += lambdaInc, phi += phiInc, n.pEdgePoints[i]);
                }
            } else {
                MagicEyeNodeView np = n.parent;
                double xInc = (double)(n.getPosX() - np.getPosX()) * this.REZ_LINES_PER_EDGE;
                double yInc = (double)(n.getPosY() - np.getPosY()) * this.REZ_LINES_PER_EDGE;
                double zInc = (double)(n.getPosZ() - np.getPosZ()) * this.REZ_LINES_PER_EDGE;
                double x = np.getPosX();
                double y = np.getPosY();
                double z = np.getPosZ();
                for (int j = 0; j < 9; ++j) {
                    n.pEdgePoints[j].set(x += xInc, y += yInc, z += zInc);
                }
            }
        }
        if (n.visible) {
            for (int i = 0; i < n.numChilds; ++i) {
                this.makeFlatMap(n.getChild(i));
            }
        }
    }

    private void project2Hemisphere(double lambda, double phi, Point3d p) {
        if (this.hemisphere) {
            double a = Math.sin(phi);
            p.set(Math.cos(lambda) * a, Math.sin(lambda) * a, Math.cos(phi));
        } else {
            double l = phi / Math.PI;
            p.set(Math.cos(lambda) * l, Math.sin(lambda) * l, 0.0);
        }
    }

    private void project2Hemisphere(double lambda, double phi, MagicEyeNodeView n) {
        n.lambda = lambda;
        n.phi = phi;
        if (this.hemisphere) {
            double a = Math.sin(phi);
            n.setPosX((float)(Math.cos(lambda) * a));
            n.setPosY((float)(Math.sin(lambda) * a));
            n.setPosZ((float)Math.cos(phi));
        } else {
            double l = phi / Math.PI;
            n.setPosX((float)(Math.cos(lambda) * l));
            n.setPosY((float)(Math.sin(lambda) * l));
            n.setPosZ(0.0f);
        }
    }

    private double getMinX(MagicEyeNodeView n) {
        double minx = n.x;
        for (int i = 0; i < n.numChilds; ++i) {
            double tmp;
            MagicEyeNodeView ni = n.getChild(i);
            if (!ni.visible || !((tmp = this.getMinX(ni)) < minx)) continue;
            minx = tmp;
        }
        return minx;
    }

    private double getMaxX(MagicEyeNodeView n) {
        double maxx = n.x;
        for (int i = 0; i < n.numChilds; ++i) {
            double tmp;
            MagicEyeNodeView ni = n.getChild(i);
            if (!ni.visible || !((tmp = this.getMaxX(ni)) > maxx)) continue;
            maxx = tmp;
        }
        return maxx;
    }

    private void edgeToRoot(MagicEyeNodeView n) {
        double xInc = (double)(n.getPosX() - this.Root.getPosX()) * this.REZ_LINES_PER_EDGE;
        double yInc = (double)(n.getPosY() - this.Root.getPosY()) * this.REZ_LINES_PER_EDGE;
        double zInc = (double)(n.getPosZ() - this.Root.getPosZ()) * this.REZ_LINES_PER_EDGE;
        double x = this.Root.getPosX();
        double y = this.Root.getPosY();
        double z = this.Root.getPosZ();
        for (int i = 0; i < 9; ++i) {
            n.pEdgePoints[i].set(x += xInc, y += yInc, z += zInc);
        }
    }

    private void subtree2Flatmap(MagicEyeNodeView n) {
        if (n.visible) {
            for (int i = 0; i < n.numChilds; ++i) {
                MagicEyeNodeView ni = n.getChild(i);
                this.project2Hemisphere((ni.x - this.minx) * this.scalex + this.start, (double)ni.level * this.scaley, ni);
                if (this.CURVED_EDGES) {
                    double lambdaInc = (ni.lambda - ni.parent.lambda) * this.REZ_LINES_PER_EDGE;
                    double phiInc = (ni.phi - ni.parent.phi) * this.REZ_LINES_PER_EDGE;
                    double lambda = ni.parent.lambda;
                    double phi = ni.parent.phi;
                    for (int j = 0; j < 9; ++j) {
                        this.project2Hemisphere(lambda += lambdaInc, phi += phiInc, ni.pEdgePoints[j]);
                    }
                } else {
                    MagicEyeNodeView nip = ni.parent;
                    double xInc = (double)(ni.getPosX() - nip.getPosX()) * this.REZ_LINES_PER_EDGE;
                    double yInc = (double)(ni.getPosY() - nip.getPosY()) * this.REZ_LINES_PER_EDGE;
                    double zInc = (double)(ni.getPosZ() - nip.getPosZ()) * this.REZ_LINES_PER_EDGE;
                    double x = nip.getPosX();
                    double y = nip.getPosY();
                    double z = nip.getPosZ();
                    for (int j = 0; j < 9; ++j) {
                        ni.pEdgePoints[j].set(x += xInc, y += yInc, z += zInc);
                    }
                }
                this.subtree2Flatmap(ni);
            }
        }
    }

    public boolean isHemisphere() {
        return this.hemisphere;
    }

    public void setHemisphere(boolean hemisphere) {
        this.hemisphere = hemisphere;
    }
}

