/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.common.util;

import com.healthmarketscience.common.util.ReflectionFactory;
import java.io.Serializable;
import org.apache.commons.lang.exception.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PassthroughException
extends RuntimeException
implements Serializable {
    private static final long serialVersionUID = 20071230L;
    private static final ReflectionFactory<Throwable, IllegalArgumentException> THROWABLE_FACTORY = new ReflectionFactory<Throwable, IllegalArgumentException>(Throwable.class, IllegalArgumentException.class, String.class, Throwable.class);
    private final String _originalException;

    public PassthroughException(Throwable original, PassthroughException cause) {
        this(PassthroughException.getOriginalExceptionName(original), original.getMessage(), original.getStackTrace(), cause);
    }

    public PassthroughException(String originalException, String originalMessage, StackTraceElement[] originalStackTrace, PassthroughException cause) {
        super(originalMessage, cause);
        this._originalException = originalException;
        this.setStackTrace(originalStackTrace);
    }

    @Override
    public String toString() {
        String msg = this.getMessage();
        return msg == null ? this._originalException : this._originalException + ": " + msg;
    }

    public String getOriginalExceptionName() {
        return this._originalException;
    }

    static String getOriginalExceptionName(Throwable t) {
        if (t instanceof PassthroughException) {
            return ((PassthroughException)t).getOriginalExceptionName();
        }
        return t.getClass().getName();
    }

    public static PassthroughException create(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t.getClass() == PassthroughException.class) {
            return (PassthroughException)t;
        }
        Throwable[] ts = ExceptionUtils.getThrowables((Throwable)t);
        PassthroughException last = null;
        for (int i = ts.length - 1; i >= 0; --i) {
            Throwable next = ts[i];
            last = new PassthroughException(next, last);
        }
        return last;
    }

    public static <ExType extends Throwable> ExType create(Throwable t, Class<ExType> exType, String defaultMsg) {
        return PassthroughException.create(t, exType, defaultMsg, true);
    }

    public static <ExType extends Throwable> ExType create(Throwable t, Class<ExType> exType, String defaultMsg, boolean throwError) {
        if (t == null) {
            return null;
        }
        if (throwError && t instanceof Error) {
            throw (Error)t;
        }
        Throwable topT = t;
        ExType origT = PassthroughException.findException(t, exType);
        if (t.equals(origT)) {
            t = ExceptionUtils.getCause((Throwable)t);
        }
        PassthroughException passthroughCause = PassthroughException.create(t);
        if (origT != null && t.equals(passthroughCause)) {
            return origT;
        }
        String className = null;
        String msg = null;
        if (origT != null) {
            msg = ((Throwable)origT).getMessage();
            className = origT.getClass().getName();
        } else {
            msg = defaultMsg != null ? defaultMsg : (passthroughCause != null ? passthroughCause.getMessage() : "");
            className = exType.getName();
        }
        Throwable rtn = (Throwable)exType.cast(THROWABLE_FACTORY.create(className, msg, passthroughCause));
        rtn.setStackTrace(topT.getStackTrace());
        return (ExType)rtn;
    }

    private static <ThrowType extends Throwable> ThrowType findException(Throwable t, Class<ThrowType> throwClass) {
        int idx = ExceptionUtils.indexOfType((Throwable)t, throwClass);
        if (idx >= 0) {
            return (ThrowType)((Throwable)throwClass.cast(ExceptionUtils.getThrowables((Throwable)t)[idx]));
        }
        return null;
    }
}

