/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.StringUtil;

public class AsciiWriter
extends Writer {
    private final OutputStream os;
    private final byte[] buffer = new byte[IOUtil.STANDARD_BUFFER_SIZE];
    private int numBytes;

    public AsciiWriter(OutputStream os) {
        this.os = os;
        this.numBytes = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.write(this.buffer, 0, this.numBytes);
        this.numBytes = 0;
        this.os.flush();
    }

    public void write(char[] chars, int offset, int length) throws IOException {
        while (length > 0) {
            int charsToConvert = Math.min(length, this.buffer.length - this.numBytes);
            StringUtil.charsToBytes(chars, offset, charsToConvert, this.buffer, this.numBytes);
            this.numBytes += charsToConvert;
            offset += charsToConvert;
            length -= charsToConvert;
            if (this.numBytes != this.buffer.length) continue;
            this.os.write(this.buffer, 0, this.numBytes);
            this.numBytes = 0;
        }
    }
}

