/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.SystemColor;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.Strings;
import org.genemania.plugin.SystemUtils;
import org.genemania.plugin.view.util.FileSelectionMode;
import org.genemania.plugin.view.util.ImageCache;

public class UiUtils {
    private final ImageCache images = new ImageCache();

    public JEditorPane createLinkEnabledEditorPane(Component parent, String text) {
        return this.createLinkEnabledEditorPane(parent, text, null);
    }

    public JEditorPane createEditorPane(String text) {
        JEditorPane pane = new JEditorPane();
        pane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        pane.setEditorKit(new HTMLEditorKit());
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setText(text);
        return pane;
    }

    public JEditorPane createLinkEnabledEditorPane(final Component parent, String text, URL baseUrl) {
        if (baseUrl != null) {
            text = this.filter(text, baseUrl);
        }
        JEditorPane pane = this.createEditorPane(text);
        HyperlinkListener linkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !SystemUtils.openBrowser(e.getURL())) {
                    JOptionPane.showMessageDialog(parent, Strings.openHyperlink_error, Strings.default_title, 0);
                }
            }
        };
        pane.addHyperlinkListener(linkListener);
        return pane;
    }

    private String filter(String text, URL baseUrl) {
        Pattern pattern = Pattern.compile("\\@\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(text);
        HashSet<String> keys = new HashSet<String>();
        int offset = 0;
        while (matcher.find(offset)) {
            String key = matcher.group(1);
            keys.add(key);
            offset = matcher.end();
        }
        String base = baseUrl.toString();
        for (String key : keys) {
            String url = String.format("%s%s", base, key);
            text = text.replace(String.format("@{%s}", key), url);
        }
        return text;
    }

    public void setPreferredWidth(Component component, int width) {
        component.setSize(width, Short.MAX_VALUE);
        Dimension size = component.getPreferredSize();
        component.setPreferredSize(new Dimension(width, size.height));
    }

    public JToggleButton createToggleButton() {
        JToggleButton expandButton = new JToggleButton();
        expandButton.setIcon(this.getIcon("arrow_collapsed.gif"));
        expandButton.setSelectedIcon(this.getIcon("arrow_expanded.gif"));
        expandButton.setBorderPainted(false);
        expandButton.setContentAreaFilled(false);
        expandButton.setFocusable(false);
        expandButton.setBorder(BorderFactory.createEmptyBorder());
        return expandButton;
    }

    private Icon getIcon(String id) {
        return this.getImageCache().getIcon(id);
    }

    public String filterImages(String text) {
        return text.replaceAll("</?[Ii][Mm][Gg].*?>", "");
    }

    public void packColumns(JTable table) {
        int padding = 5;
        TableModel model = table.getModel();
        int[] widths = new int[model.getColumnCount()];
        for (int j = 0; j < model.getRowCount(); ++j) {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                TableCellRenderer renderer = table.getCellRenderer(j, i);
                Component component = renderer.getTableCellRendererComponent(table, model.getValueAt(j, i), true, true, j, i);
                widths[i] = (int)Math.max((double)widths[i], component.getPreferredSize().getWidth() + table.getIntercellSpacing().getWidth() + (double)padding);
            }
        }
        TableColumnModel columnModel = table.getColumnModel();
        JTableHeader header = table.getTableHeader();
        for (int i = 0; i < widths.length; ++i) {
            TableColumn column = columnModel.getColumn(i);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = header.getDefaultRenderer();
            }
            Component component = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), true, true, 0, i);
            widths[i] = (int)Math.max((double)widths[i], component.getPreferredSize().getWidth());
            header.setResizingColumn(column);
            column.setWidth(widths[i]);
        }
    }

    public Frame getFrame(Component parent) {
        while (parent != null) {
            if (parent instanceof Frame) {
                return (Frame)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public Component createFillerPanel(Color background) {
        JPanel panel = new JPanel();
        panel.setBackground(background);
        return panel;
    }

    public Component createFillerPanel() {
        return this.createFillerPanel(SystemColor.text);
    }

    public JPanel createJPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        return panel;
    }

    public JCheckBox createCheckBox(String label) {
        if (label == null) {
            label = "";
        }
        JCheckBox checkBox = new JCheckBox(label);
        checkBox.setOpaque(false);
        return checkBox;
    }

    public JCheckBox createCheckBox() {
        return this.createCheckBox(null);
    }

    public JRadioButton createRadioButton(String label) {
        JRadioButton button = new JRadioButton(label);
        button.setOpaque(false);
        return button;
    }

    private File getFileAWT(Component parent, String title, File initialFile, String typeDescription, Set<String> extensions, FileSelectionMode mode) throws ApplicationException {
        FileDialog dialog;
        switch (mode) {
            case OPEN_FILE: 
            case OPEN_DIRECTORY: {
                dialog = new FileDialog(this.getFrame(parent), title, 0);
                break;
            }
            case SAVE_FILE: {
                dialog = new FileDialog(this.getFrame(parent), title, 1);
                break;
            }
            default: {
                throw new ApplicationException(String.valueOf((Object)mode));
            }
        }
        File directory = null;
        if (initialFile.isDirectory()) {
            directory = initialFile;
        }
        if (initialFile.isFile() || !initialFile.exists()) {
            dialog.setFile(initialFile.getName());
            directory = initialFile.getParentFile();
        }
        if (directory != null) {
            dialog.setDirectory(directory.getAbsolutePath());
        }
        dialog.setTitle(title);
        dialog.setVisible(true);
        String file = dialog.getFile();
        if (file == null) {
            return null;
        }
        String targetDirectory = dialog.getDirectory();
        if (targetDirectory == null) {
            return null;
        }
        return new File(String.format("%s%s%s", targetDirectory, File.separator, file));
    }

    private File getFileSwing(Component parent, String title, File initialFile, final String typeDescription, final Set<String> extensions, FileSelectionMode mode) throws ApplicationException {
        int option;
        JFileChooser chooser = new JFileChooser(initialFile);
        chooser.setDialogTitle(title);
        chooser.setSelectedFile(initialFile);
        if (typeDescription != null && extensions != null && extensions.size() > 0) {
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String[] parts = file.getName().split("[.]");
                    String lastPart = parts[parts.length - 1];
                    for (String extension : extensions) {
                        if (!extension.equalsIgnoreCase(lastPart)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return typeDescription;
                }
            });
        }
        switch (mode) {
            case OPEN_FILE: {
                chooser.setFileSelectionMode(0);
                option = chooser.showOpenDialog(parent);
                break;
            }
            case OPEN_DIRECTORY: {
                chooser.setFileSelectionMode(1);
                option = chooser.showOpenDialog(parent);
                break;
            }
            case SAVE_FILE: {
                chooser.setFileSelectionMode(0);
                option = chooser.showSaveDialog(parent);
                break;
            }
            default: {
                throw new ApplicationException(String.valueOf((Object)mode));
            }
        }
        if (option != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File getFile(Component parent, String title, File initialFile, String typeDescription, Set<String> extensions, FileSelectionMode mode) throws ApplicationException {
        if (this.isMacOSX()) {
            return this.getFileAWT(parent, title, initialFile, typeDescription, extensions, mode);
        }
        return this.getFileSwing(parent, title, initialFile, typeDescription, extensions, mode);
    }

    public boolean isMacOSX() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Mac OS X");
    }

    public Dimension computeTextSizeHint(FontMetrics metrics, int columns, int rows) {
        int emSize = SwingUtilities.computeStringWidth(metrics, "M");
        return new Dimension(columns * emSize, metrics.getHeight() * rows);
    }

    public ImageCache getImageCache() {
        return this.images;
    }

    public Image getFrameIcon() {
        return this.images.getImage("helix.png");
    }
}

