/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.plugin.Strings;

public class NetworkGroupComboBox
extends JComboBox {
    private final List<InteractionNetworkGroup> groups;
    private final DefaultComboBoxModel groupModel = (DefaultComboBoxModel)this.getModel();

    public NetworkGroupComboBox() {
        super(new DefaultComboBoxModel());
        this.groups = new ArrayList<InteractionNetworkGroup>();
    }

    public void updateNetworkGroups(Collection<InteractionNetworkGroup> groups) {
        this.groupModel.removeAllElements();
        this.groups.clear();
        if (groups == null) {
            return;
        }
        for (InteractionNetworkGroup group : groups) {
            this.groups.add(group);
        }
        Collections.sort(this.groups, new Comparator<InteractionNetworkGroup>(){

            @Override
            public int compare(InteractionNetworkGroup o1, InteractionNetworkGroup o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.groupModel.addElement(Strings.networkGroupComboBoxCreateGroup_label);
        for (InteractionNetworkGroup group : this.groups) {
            this.groupModel.addElement(group.getName());
        }
    }

    public InteractionNetworkGroup getGroup() {
        int index = this.getSelectedIndex();
        switch (index) {
            case -1: {
                return null;
            }
            case 0: {
                InteractionNetworkGroup group = new InteractionNetworkGroup();
                group.setId(-1L);
                return group;
            }
        }
        return this.groups.get(index - 1);
    }

    public void setGroup(InteractionNetworkGroup target) {
        for (int i = 0; i < this.groups.size(); ++i) {
            InteractionNetworkGroup group = this.groups.get(i);
            if (target.getId() != group.getId()) continue;
            this.groupModel.setSelectedItem(group.getName());
            return;
        }
    }

    public boolean containsGroup(String groupName) {
        for (InteractionNetworkGroup group : this.groups) {
            if (!group.getName().equalsIgnoreCase(groupName)) continue;
            return true;
        }
        return false;
    }
}

