/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ProgressReporter;

public class TaskDialog
extends JDialog
implements ProgressReporter {
    private JEditorPane descriptionLabel;
    private JProgressBar progressBar;
    private JButton cancelButton;
    private boolean isCanceled;
    private int maximumProgress;
    private int progress;
    private String status;
    private JLabel statusLabel;
    private String description;
    private JButton closeButton;
    private JLabel statusImage;
    private JProgressBar memoryBar;
    private JLabel elapsedTimeLabel;
    private long startTime;
    private final UiUtils uiUtils;

    public TaskDialog(Frame owner, String title, boolean modal, boolean cancelable, UiUtils uiUtils) {
        super(owner, title, modal);
        this.uiUtils = uiUtils;
        this.initialize(cancelable);
    }

    public TaskDialog(Dialog owner, String title, boolean modal, boolean cancelable, UiUtils uiUtils) {
        super(owner, title, modal);
        this.uiUtils = uiUtils;
        this.initialize(cancelable);
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public void initialize(boolean cancelable) {
        this.setDefaultCloseOperation(0);
        this.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setDoubleBuffered(true);
        this.statusLabel = new JLabel();
        this.descriptionLabel = this.uiUtils.createLinkEnabledEditorPane(this, Strings.taskDialogInitialization_status);
        this.descriptionLabel.setDoubleBuffered(true);
        Dimension minimumSize = this.descriptionLabel.getMinimumSize();
        minimumSize.height = Math.max(minimumSize.height, this.descriptionLabel.getFontMetrics(this.descriptionLabel.getFont()).getHeight() * 3);
        this.descriptionLabel.setMinimumSize(minimumSize);
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
        this.memoryBar = new JProgressBar();
        this.memoryBar.setMinimum(0);
        this.memoryBar.setMaximum(100);
        this.memoryBar.setValue(0);
        this.cancelButton = new JButton(Strings.taskDialogCancelButton_label);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDialog.this.isCanceled = true;
            }
        });
        this.cancelButton.setVisible(cancelable);
        final TaskDialog dialog = this;
        this.closeButton = new JButton(Strings.taskDialogCloseButton_label);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        this.closeButton.setVisible(false);
        this.statusImage = new JLabel();
        JLabel progressLabel = new JLabel(Strings.taskDialogProgress_label);
        JLabel memoryLabel = new JLabel(Strings.taskDialogMemory_label);
        JLabel timeLabel = new JLabel(Strings.taskDialogTime_label);
        this.elapsedTimeLabel = new JLabel();
        Insets insets = new Insets(4, 4, 4, 4);
        panel.add((Component)this.statusImage, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 19, 0, insets, 0, 0));
        panel.add((Component)this.statusLabel, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        panel.add((Component)this.descriptionLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 23, 2, insets, 0, 0));
        panel.add((Component)progressLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)this.progressBar, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        panel.add((Component)memoryLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)this.memoryBar, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        panel.add((Component)this.cancelButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 24, 0, insets, 0, 0));
        panel.add((Component)this.closeButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 24, 0, insets, 0, 0));
        panel.add((Component)timeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)this.elapsedTimeLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.startTime = System.currentTimeMillis();
        this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 16, 16, 16), 0, 0));
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!TaskDialog.this.isCanceled) {
                    TaskDialog.this.updateMemoryUsage();
                    TaskDialog.this.updateTime();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }).start();
    }

    public void setStatusIcon(Icon icon) {
        this.statusImage.setIcon(icon);
    }

    public void enableCloseButton(boolean enabled) {
        this.cancelButton.setVisible(!enabled);
        this.closeButton.setVisible(enabled);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.invalidate();
    }

    public int getMaximumProgress() {
        return this.maximumProgress;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setMaximumProgress(int maximum) {
        this.maximumProgress = maximum;
        this.progressBar.setMaximum(maximum);
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(progress);
    }

    public void setStatus(final String status) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TaskDialog.this.setStatus(status);
                    }
                });
            }
            catch (InterruptedException e) {
                LogUtils.log(this.getClass(), e);
            }
            catch (InvocationTargetException e) {
                LogUtils.log(this.getClass(), e);
            }
        }
        this.status = status;
        this.statusLabel.setText(status);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(final String description) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TaskDialog.this.setDescription(description);
                    }
                });
            }
            catch (InterruptedException e) {
                LogUtils.log(this.getClass(), e);
            }
            catch (InvocationTargetException e) {
                LogUtils.log(this.getClass(), e);
            }
        }
        this.description = description;
        this.descriptionLabel.setText(description);
    }

    void updateMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        double free = runtime.freeMemory();
        double size = runtime.totalMemory();
        double used = size - free;
        double maxMemory = runtime.maxMemory();
        int usage = (int)Math.round((maxMemory - used) / maxMemory * 100.0);
        this.memoryBar.setValue(usage);
    }

    void updateTime() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        int seconds = (int)((double)elapsedTime / 1000.0);
        int minutes = seconds / 60;
        int hours = seconds / 3600;
        this.elapsedTimeLabel.setText(String.format("%d:%02d:%02d", hours, minutes % 60, seconds % 60));
    }
}

