/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.NumberFormatter;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.domain.Statistics;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.AttributeMediator;
import org.genemania.mediator.StatsMediator;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.apps.IQueryErrorHandler;
import org.genemania.plugin.completion.CompletionPanel;
import org.genemania.plugin.controllers.RetrieveRelatedGenesController;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetChangeListener;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IConfiguration;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.ModelElement;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.model.impl.InteractionNetworkGroupImpl;
import org.genemania.plugin.model.impl.QueryAttributeGroupImpl;
import org.genemania.plugin.model.impl.QueryAttributeNetworkImpl;
import org.genemania.plugin.parsers.IQueryParser;
import org.genemania.plugin.parsers.JsonQueryParser;
import org.genemania.plugin.parsers.Query;
import org.genemania.plugin.parsers.WebsiteQueryParser;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.NetworkSelectionPanel;
import org.genemania.plugin.view.util.FileSelectionMode;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.type.CombiningMethod;
import org.genemania.type.ScoringMethod;
import org.genemania.util.ProgressReporter;

public class RetrieveRelatedGenesDialog<NETWORK, NODE, EDGE>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel networkSubPanel;
    private Organism selectedOrganism;
    private JComboBox organismComboBox;
    private JTextField limitTextField;
    private JComboBox weightingMethodComboBox;
    private JLabel dataSourceLabel;
    private CompletionPanel genePanel;
    private JLabel totalOrganismsLabel;
    private JLabel totalNetworksLabel;
    private JLabel totalGenesLabel;
    private JLabel totalInteractionsLabel;
    private JButton startButton;
    private JButton removeButton;
    private JButton clearButton;
    private NetworkSelectionPanel selectionPanel;
    private JButton configureButton;
    private JPanel networkPanel;
    private JButton chooseFileButton;
    private Map<Long, List<String>> selectedGenes;
    private RetrieveRelatedGenesController<NETWORK, NODE, EDGE> controller;
    private DataSetManager dataSetManager;
    private TitledBorder networkBorder;
    private TitledBorder geneBorder;
    private TitledBorder organismBorder;
    private TitledBorder loadQueryBorder;
    private final NetworkUtils networkUtils;
    private final UiUtils uiUtils;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final FileUtils fileUtils;
    private final TaskDispatcher taskDispatcher;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    private JFormattedTextField attributeLimitTextField;

    public RetrieveRelatedGenesDialog(Frame owner, boolean modality, RetrieveRelatedGenesController<NETWORK, NODE, EDGE> controller, DataSetManager dataSetManager, NetworkUtils networkUtils, UiUtils uiUtils, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, FileUtils fileUtils, TaskDispatcher taskDispatcher, GeneMania<NETWORK, NODE, EDGE> plugin) {
        super(owner, Strings.default_title, modality);
        this.controller = controller;
        this.networkUtils = networkUtils;
        this.uiUtils = uiUtils;
        this.cytoscapeUtils = cytoscapeUtils;
        this.fileUtils = fileUtils;
        this.taskDispatcher = taskDispatcher;
        this.plugin = plugin;
        this.selectedGenes = new HashMap<Long, List<String>>();
        this.dataSetManager = dataSetManager;
        dataSetManager.addDataSetChangeListener(new DataSetChangeListener(){

            @Override
            public void dataSetChanged(DataSet activeDataSet, ProgressReporter progress) {
                RetrieveRelatedGenesDialog.this.handleDataSetChanged(activeDataSet);
            }
        });
        JRootPane root = this.getRootPane();
        final RetrieveRelatedGenesDialog dialog = this;
        AbstractAction action = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        String key = (String)action.getValue("Name");
        root.getActionMap().put(key, action);
        root.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), key);
        Container contents = this.getContentPane();
        contents.setLayout(new BoxLayout(contents, 3));
        this.addComponents();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                RetrieveRelatedGenesDialog.this.genePanel.handleParentMoved();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                RetrieveRelatedGenesDialog.this.genePanel.handleParentMoved();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                RetrieveRelatedGenesDialog.this.genePanel.hideProposals();
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent event) {
                Window window = event.getOppositeWindow();
                if (window == RetrieveRelatedGenesDialog.this.genePanel.getProposalDialog()) {
                    return;
                }
                RetrieveRelatedGenesDialog.this.genePanel.hideProposals();
            }

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
            }
        });
        this.createMenu();
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu(Strings.edit_menuLabel);
        JMenuItem pasteMenu = new JMenuItem(Strings.paste_menuLabel);
        pasteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RetrieveRelatedGenesDialog.this.genePanel.requestFocus();
                new DefaultEditorKit.PasteAction().actionPerformed(event);
            }
        });
        editMenu.add(pasteMenu);
        menuBar.add(editMenu);
        this.setJMenuBar(menuBar);
    }

    protected void handleDataSetChanged(DataSet dataSet) {
        try {
            this.setDataSet(dataSet);
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
        }
    }

    public void setDataSet(DataSet data) throws ApplicationException {
        if (data == null) {
            this.dataSourceLabel.setText(Strings.retrieveRelatedGenesNoDataSet_label);
        } else {
            this.dataSourceLabel.setText(data.getDescription());
            try {
                Vector<ModelElement<Organism>> model = this.controller.createModel(data);
                this.organismComboBox.setModel(new DefaultComboBoxModel<ModelElement<Organism>>(model));
            }
            catch (DataStoreException e) {
                throw new ApplicationException((Throwable)e);
            }
            this.updateStatistics(data);
            this.configureButton.setEnabled(data.getConfiguration().hasUi());
        }
        this.handleOrganismSelected();
    }

    private JPanel createOrganismSelector() {
        JPanel header = this.uiUtils.createJPanel();
        this.organismBorder = BorderFactory.createTitledBorder(Strings.retrieveRelatedGenesOrganism_label);
        header.setBorder(this.organismBorder);
        header.setLayout(new FlowLayout(1, 0, 0));
        String tipText = Strings.retrieveRelatedGenesOrganismComboBox_label;
        header.setToolTipText(tipText);
        this.organismComboBox = new JComboBox();
        this.organismComboBox.setToolTipText(tipText);
        header.add(this.organismComboBox);
        this.organismComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RetrieveRelatedGenesDialog.this.handleOrganismSelected();
            }
        });
        return header;
    }

    private void handleOrganismSelected() {
        try {
            ModelElement element = (ModelElement)this.organismComboBox.getSelectedItem();
            if (element != null) {
                this.handleOrganismChange((Organism)element.getItem());
            } else {
                this.handleOrganismChange(null);
            }
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
        }
        this.validateQuery();
    }

    private JComponent createGeneAndNetworkPane() {
        JPanel panel = this.uiUtils.createJPanel();
        panel.setLayout(new GridBagLayout());
        JPanel organismSelectionPanel = this.createOrganismSelector();
        panel.add((Component)organismSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel loadQueryPanel = this.uiUtils.createJPanel();
        loadQueryPanel.setLayout(new FlowLayout(1, 0, 0));
        this.loadQueryBorder = BorderFactory.createTitledBorder(Strings.retrieveRelatedGenesLoadParameters_label);
        loadQueryPanel.setBorder(this.loadQueryBorder);
        this.chooseFileButton = new JButton(Strings.retrieveRelatedGenesChooseFileButton_label);
        this.chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RetrieveRelatedGenesDialog.this.handleChooseFile();
            }
        });
        loadQueryPanel.add(this.chooseFileButton);
        panel.add((Component)loadQueryPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel geneSelectionPanel = this.uiUtils.createJPanel();
        this.geneBorder = BorderFactory.createTitledBorder(Strings.retrieveRelatedGenesGenePanel_label);
        geneSelectionPanel.setBorder(this.geneBorder);
        geneSelectionPanel.setLayout(new GridBagLayout());
        this.genePanel = new CompletionPanel(2, this.networkUtils, this.uiUtils, this.taskDispatcher);
        geneSelectionPanel.add((Component)this.genePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonPanel = this.uiUtils.createJPanel();
        buttonPanel.setLayout(new GridBagLayout());
        final JLabel statusField = new JLabel("");
        statusField.setBorder(BorderFactory.createEmptyBorder());
        buttonPanel.add((Component)statusField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.genePanel.setProgressReporter(new ProgressReporter(){

            public void setStatus(String status) {
                statusField.setText(status);
                statusField.invalidate();
            }

            public String getStatus() {
                return statusField.getText();
            }

            public void cancel() {
            }

            public int getMaximumProgress() {
                return 0;
            }

            public int getProgress() {
                return 0;
            }

            public boolean isCanceled() {
                return false;
            }

            public void setMaximumProgress(int maximum) {
            }

            public void setProgress(int progress) {
            }

            public String getDescription() {
                return null;
            }

            public void setDescription(String description) {
            }
        });
        this.removeButton = new JButton(Strings.retrieveRelatedGenesRemoveGeneButton_label);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RetrieveRelatedGenesDialog.this.genePanel.removeSelection();
                RetrieveRelatedGenesDialog.this.validateQuery();
            }
        });
        buttonPanel.add((Component)this.removeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.clearButton = new JButton(Strings.retrieveRelatedGenesClearGenesButton_label);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RetrieveRelatedGenesDialog.this.handleClearButton();
            }
        });
        buttonPanel.add((Component)this.clearButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.genePanel.addTableModelEventListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RetrieveRelatedGenesDialog.this.validateQuery();
            }
        });
        this.genePanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RetrieveRelatedGenesDialog.this.validateQuery();
            }
        });
        geneSelectionPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)geneSelectionPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.networkPanel = this.createNetworkPanel();
        JSplitPane splitPane = new JSplitPane(0, panel, this.networkPanel);
        splitPane.setAlignmentX(0.5f);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        return splitPane;
    }

    private void handleChooseFile() {
        File file;
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("json");
        File initialFile = this.fileUtils.getUserHome();
        try {
            file = this.uiUtils.getFile(this, Strings.retrieveRelatedGenesChooseFile_title, initialFile, Strings.jsonDescription, extensions, FileSelectionMode.OPEN_FILE);
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
            return;
        }
        if (file == null) {
            return;
        }
        GeneManiaTask task = new GeneManiaTask(Strings.retrieveRelatedGenesChooseFile_title){

            @Override
            protected void runTask() throws Throwable {
                this.progress.setStatus(Strings.retrieveRelatedGenesChooseFile_status);
                DataSet data = RetrieveRelatedGenesDialog.this.dataSetManager.getDataSet();
                IQueryErrorHandler handler = new IQueryErrorHandler(){

                    @Override
                    public void warn(String message) {
                    }

                    @Override
                    public void handleUnrecognizedGene(String gene) {
                    }

                    @Override
                    public void handleSynonym(String gene) {
                    }

                    @Override
                    public void handleNetwork(InteractionNetwork network) {
                    }

                    @Override
                    public void handleUnrecognizedNetwork(String network) {
                    }
                };
                final Query query = RetrieveRelatedGenesDialog.this.parseQuery(data, file, handler);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RetrieveRelatedGenesDialog.this.applyQuery(query);
                        }
                        catch (ApplicationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        };
        this.taskDispatcher.executeTask(task, this, true, false);
    }

    protected Query parseQuery(DataSet data, File file, IQueryErrorHandler handler) throws ApplicationException {
        IQueryParser[] parsers;
        for (IQueryParser parser : parsers = new IQueryParser[]{new JsonQueryParser(), new WebsiteQueryParser()}) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                return parser.parse(data, reader, handler);
            }
            catch (Exception e) {
            }
        }
        throw new ApplicationException(Strings.retrieveRelatedGenesChooseFile_error);
    }

    private void applyQuery(Query query) throws ApplicationException {
        Organism organism = query.getOrganism();
        ComboBoxModel model = this.organismComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ModelElement element = (ModelElement)model.getElementAt(i);
            Organism o = (Organism)element.getItem();
            if (organism.getId() != o.getId()) continue;
            model.setSelectedItem(element);
            this.handleOrganismChange(o);
            break;
        }
        this.genePanel.setItems(query.getGenes());
        this.selectionPanel.setSelection(query);
        this.limitTextField.setText(String.valueOf(query.getGeneLimit()));
        ComboBoxModel weightingMethodModel = this.weightingMethodComboBox.getModel();
        CombiningMethod combiningMethod = query.getCombiningMethod();
        for (int i = 0; i < weightingMethodModel.getSize(); ++i) {
            WeightingMethodEntry entry = (WeightingMethodEntry)weightingMethodModel.getElementAt(i);
            if (!entry.getMethod().equals((Object)combiningMethod)) continue;
            weightingMethodModel.setSelectedItem(entry);
            break;
        }
        this.validateQuery();
    }

    private void handleClearButton() {
        this.genePanel.clear();
        this.validateQuery();
    }

    private JPanel createNetworkPanel() {
        JPanel networkPanel = this.uiUtils.createJPanel();
        this.networkBorder = BorderFactory.createTitledBorder(Strings.retrieveRelatedGenesNetworkPanel_label);
        networkPanel.setBorder(this.networkBorder);
        networkPanel.setLayout(new GridBagLayout());
        JEditorPane selectionLabel = this.uiUtils.createEditorPane(Strings.retrieveRelatedGenesNetworkPanelSelection_label);
        selectionLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                RetrieveRelatedGenesDialog.this.handleLink(e);
            }
        });
        networkPanel.add((Component)selectionLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        networkPanel.setToolTipText(Strings.retrieveRelatedGenesNetworkPanel_tooltip);
        this.networkSubPanel = this.uiUtils.createJPanel();
        this.networkSubPanel.setLayout(new GridBagLayout());
        networkPanel.add((Component)this.networkSubPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return networkPanel;
    }

    private void handleLink(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (this.selectionPanel == null) {
            return;
        }
        String reference = e.getDescription();
        if ("#en-all".equals(reference)) {
            this.selectionPanel.selectAllNetworks(true);
        } else if ("#en-none".equals(reference)) {
            this.selectionPanel.selectAllNetworks(false);
        } else if ("#en-default".equals(reference)) {
            this.selectionPanel.selectDefaultNetworks();
        }
        this.validateQuery();
    }

    private void addLabel(Container component, String message, int row, int column) {
        JLabel label = new JLabel(message);
        label.setAlignmentX(0.5f);
        Insets insets = new Insets(0, 2, 0, 2);
        component.add((Component)label, new GridBagConstraints(row, column, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
    }

    private void addComponents() {
        Container contents = this.getContentPane();
        contents.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        contents.add(this.createDataSourcePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        contents.add((Component)this.createGeneAndNetworkPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        Insets insets2 = new Insets(0, 2, 0, 2);
        JPanel limitPanel = this.uiUtils.createJPanel();
        int column = 0;
        limitPanel.setLayout(new GridBagLayout());
        this.addLabel(limitPanel, Strings.retrieveRelatedGenes_label, column, 0);
        this.limitTextField = new JFormattedTextField(new NumberFormatter(new DecimalFormat("#")));
        this.limitTextField.setText("20");
        this.limitTextField.setColumns(4);
        this.limitTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                RetrieveRelatedGenesDialog.this.validateQuery();
            }
        });
        limitPanel.add((Component)this.limitTextField, new GridBagConstraints(++column, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        this.addLabel(limitPanel, Strings.retrieveRelatedGenes_label2, ++column, 0);
        this.addLabel(limitPanel, Strings.retrieveRelatedGenes_label5, ++column, 0);
        this.attributeLimitTextField = new JFormattedTextField(new NumberFormatter(new DecimalFormat("#")));
        this.attributeLimitTextField.setText("20");
        this.attributeLimitTextField.setColumns(4);
        this.attributeLimitTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                RetrieveRelatedGenesDialog.this.validateQuery();
            }
        });
        limitPanel.add((Component)this.attributeLimitTextField, new GridBagConstraints(++column, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        this.addLabel(limitPanel, Strings.retrieveRelatedGenes_label6, ++column, 0);
        this.addLabel(limitPanel, Strings.retrieveRelatedGenes_label3, ++column, 0);
        this.weightingMethodComboBox = new JComboBox();
        limitPanel.add((Component)this.weightingMethodComboBox, new GridBagConstraints(++column, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        this.addLabel(limitPanel, Strings.retrieveRelatedGenes_label4, ++column, 0);
        this.startButton = new JButton(Strings.retrieveRelatedGenesStartButton_label);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RetrieveRelatedGenesDialog.this.handleStartButton();
            }
        });
        limitPanel.add((Component)this.startButton, new GridBagConstraints(++column, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        ++column;
        contents.add((Component)limitPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        this.validateQuery();
    }

    private Query getQuery() {
        Query query = new Query();
        query.setOrganism(this.selectedOrganism);
        query.setGenes(this.genePanel.getItems());
        query.setGeneLimit(this.getLimit(this.limitTextField));
        query.setAttributeLimit(this.getLimit(this.attributeLimitTextField));
        query.setCombiningMethod(this.getCombiningMethod());
        query.setScoringMethod(this.getScoringMethod());
        return query;
    }

    private void handleStartButton() {
        Query query = this.getQuery();
        Collection<Group<?, ?>> groups = this.selectionPanel.getSelectedGroups();
        NETWORK cyNetwork = this.controller.runMania(this, query, groups);
        this.cytoscapeUtils.handleNetworkPostProcessing(cyNetwork);
        this.cytoscapeUtils.performLayout(cyNetwork);
        this.cytoscapeUtils.maximize(cyNetwork);
        NetworkSelectionManager<NETWORK, NODE, EDGE> manager = this.plugin.getNetworkSelectionManager();
        ViewState options = manager.getNetworkConfiguration(cyNetwork);
        this.plugin.applyOptions(options);
        this.plugin.showResults();
    }

    private void validateQuery() {
        if (this.selectedOrganism != null) {
            boolean hasGenes = this.genePanel.getItemCount() > 0;
            boolean hasNetworks = this.selectionPanel.getSelectionCount() > 0;
            this.setControlsEnabled(true);
            Status status = this.checkQueryStatus();
            this.startButton.setEnabled(status == Status.Ok);
            this.clearButton.setEnabled(hasGenes);
            this.removeButton.setEnabled(this.genePanel.getSelectionCount() > 0);
            this.organismBorder.setTitleColor(SystemColor.textText);
            this.geneBorder.setTitleColor(hasGenes ? SystemColor.textText : Color.red);
            this.networkBorder.setTitleColor(hasNetworks ? SystemColor.textText : Color.red);
            this.loadQueryBorder.setTitleColor(SystemColor.textText);
        } else {
            this.setControlsEnabled(false);
            this.organismBorder.setTitleColor(SystemColor.textInactiveText);
            this.networkBorder.setTitleColor(SystemColor.textInactiveText);
            this.geneBorder.setTitleColor(SystemColor.textInactiveText);
            this.loadQueryBorder.setTitleColor(SystemColor.textInactiveText);
        }
    }

    private void setControlsEnabled(boolean enabled) {
        this.organismComboBox.setEnabled(enabled);
        this.genePanel.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.clearButton.setEnabled(enabled);
        this.startButton.setEnabled(enabled);
        this.chooseFileButton.setEnabled(enabled);
        this.repaint();
    }

    private Status checkQueryStatus() {
        if (this.selectedOrganism == null) {
            return Status.NoOrganismSelected;
        }
        if (this.getLimit(this.limitTextField) < 0) {
            return Status.LimitViolation;
        }
        if (this.getLimit(this.attributeLimitTextField) < 0) {
            return Status.LimitViolation;
        }
        List<String> geneNames = this.genePanel.getItems();
        if (geneNames.size() < 1) {
            return Status.MinimumQuerySizeViolation;
        }
        int selectedNetworks = this.selectionPanel.getSelectionCount();
        if (selectedNetworks == 0) {
            return Status.MinimumNetworkSelectionViolation;
        }
        return Status.Ok;
    }

    private void handleOrganismChange(Organism organism) throws ApplicationException {
        boolean selectionChanged = this.selectedOrganism != null && organism != null && this.selectedOrganism.getId() != organism.getId() || this.selectedOrganism == null && organism != null || this.selectedOrganism != null && organism == null;
        this.updateCombiningMethods(organism);
        this.networkSubPanel.removeAll();
        List<String> genes = null;
        if (selectionChanged) {
            if (this.selectedOrganism != null) {
                this.selectedGenes.put(this.selectedOrganism.getId(), this.genePanel.getItems());
            }
            if (organism != null) {
                genes = this.selectedGenes.get(organism.getId());
            }
            this.genePanel.clear();
        }
        this.selectedOrganism = organism;
        if (organism == null) {
            return;
        }
        DataSet data = this.dataSetManager.getDataSet();
        if (data == null) {
            return;
        }
        GeneCompletionProvider2 provider = data.getCompletionProvider(this.selectedOrganism);
        this.genePanel.setProvider(provider);
        if (genes != null) {
            this.genePanel.setItems(genes);
        }
        ArrayList sortedGroups = new ArrayList();
        for (InteractionNetworkGroup group : organism.getInteractionNetworkGroups()) {
            sortedGroups.add(new InteractionNetworkGroupImpl(group));
        }
        AttributeMediator mediator = data.getMediatorProvider().getAttributeMediator();
        ArrayList<Network<AttributeGroup>> networks = new ArrayList<Network<AttributeGroup>>();
        for (AttributeGroup group : mediator.findAttributeGroupsByOrganism(organism.getId())) {
            networks.add(new QueryAttributeNetworkImpl(group, 0.0));
        }
        if (networks.size() > 0) {
            sortedGroups.add(new QueryAttributeGroupImpl((Collection<Network<AttributeGroup>>)networks));
        }
        Collections.sort(sortedGroups, this.networkUtils.getNetworkGroupComparator());
        this.selectionPanel = new NetworkSelectionPanel(this.networkUtils, this.uiUtils);
        this.selectionPanel.addListener(new SelectionListener<Object>(){

            @Override
            public void selectionChanged(SelectionEvent<Object> event) {
                RetrieveRelatedGenesDialog.this.validateQuery();
            }
        });
        this.networkSubPanel.add((Component)this.selectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectionPanel.setGroups(sortedGroups);
        this.validate();
        this.validateQuery();
    }

    private void updateCombiningMethods(Organism organism) {
        this.weightingMethodComboBox.removeAllItems();
        if (organism == null) {
            return;
        }
        boolean hasAnnotations = organism.getOntology() != null;
        this.weightingMethodComboBox.addItem(new WeightingMethodEntry(CombiningMethod.AUTOMATIC_SELECT, Strings.default_combining_method));
        this.weightingMethodComboBox.addItem(new WeightingMethodEntry(CombiningMethod.AUTOMATIC, Strings.automatic));
        if (hasAnnotations) {
            this.weightingMethodComboBox.addItem(new WeightingMethodEntry(CombiningMethod.BP, Strings.bp));
            this.weightingMethodComboBox.addItem(new WeightingMethodEntry(CombiningMethod.MF, Strings.mf));
            this.weightingMethodComboBox.addItem(new WeightingMethodEntry(CombiningMethod.CC, Strings.cc));
        }
        this.weightingMethodComboBox.addItem(new WeightingMethodEntry(CombiningMethod.AVERAGE, Strings.average));
        this.weightingMethodComboBox.addItem(new WeightingMethodEntry(CombiningMethod.AVERAGE_CATEGORY, Strings.average_category));
    }

    CombiningMethod getCombiningMethod() {
        return ((WeightingMethodEntry)this.weightingMethodComboBox.getSelectedItem()).getMethod();
    }

    ScoringMethod getScoringMethod() {
        return ScoringMethod.DISCRIMINANT;
    }

    int getLimit(JTextField textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private Component createDataSourcePanel() {
        JPanel panel = this.uiUtils.createJPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Strings.retrieveRelatedGenesStatistics_label));
        this.dataSourceLabel = new JLabel();
        this.dataSourceLabel.setName(Strings.retrieveRelatedGenesStatisticsVersion_label);
        Font labelFont = this.dataSourceLabel.getFont().deriveFont(1);
        Insets insets = new Insets(0, 8, 0, 8);
        panel.add((Component)this.createLabel(Strings.retrieveRelatedGenesStatisticsOrganisms_label, labelFont), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 5, 0));
        this.totalOrganismsLabel = new JLabel("0");
        this.totalOrganismsLabel.setName(Strings.retrieveRelatedGenesStatisticsOrganisms_label);
        panel.add((Component)this.totalOrganismsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 2, 0));
        panel.add((Component)this.createLabel(Strings.retrieveRelatedGenesStatisticsNetworks_label, labelFont), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 5, 0));
        this.totalNetworksLabel = new JLabel("0");
        this.totalNetworksLabel.setName(Strings.retrieveRelatedGenesStatisticsNetworks_label);
        panel.add((Component)this.totalNetworksLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 2, 0));
        panel.add((Component)this.createLabel(Strings.retrieveRelatedGenesStatisticsGenes_label, labelFont), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 5, 0));
        this.totalGenesLabel = new JLabel("0");
        this.totalGenesLabel.setName(Strings.retrieveRelatedGenesStatisticsGenes_label);
        panel.add((Component)this.totalGenesLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 2, 0));
        panel.add((Component)this.createLabel(Strings.retrieveRelatedGenesStatisticsInteractions_label, labelFont), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 5, 0));
        this.totalInteractionsLabel = new JLabel("0");
        this.totalInteractionsLabel.setName(Strings.retrieveRelatedGenesStatisticsInteractions_label);
        panel.add((Component)this.totalInteractionsLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 5, 0));
        panel.add((Component)this.createLabel(Strings.retrieveRelatedGenesStatisticsVersion_label, labelFont), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 5, 0));
        panel.add((Component)this.dataSourceLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.configureButton = new JButton(Strings.dataSetConfiguration_title);
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RetrieveRelatedGenesDialog.this.handleConfigureButton();
            }
        });
        panel.add((Component)this.configureButton, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void handleConfigureButton() {
        DataSet data = this.dataSetManager.getDataSet();
        if (data == null) {
            return;
        }
        IConfiguration config = data.getConfiguration();
        if (config.hasUi()) {
            config.showUi(this);
        }
    }

    private JLabel createLabel(String message, Font font) {
        JLabel label = new JLabel(message);
        label.setFont(font);
        return label;
    }

    public void updateStatistics(DataSet data) {
        StatsMediator mediator = data.getMediatorProvider().getStatsMediator();
        Statistics statistics = mediator.getLatestStatistics();
        this.totalGenesLabel.setText(String.valueOf(statistics.getGenes()));
        this.totalInteractionsLabel.setText(String.valueOf(statistics.getInteractions()));
        this.totalNetworksLabel.setText(String.valueOf(statistics.getNetworks()));
        this.totalOrganismsLabel.setText(String.valueOf(statistics.getOrganisms()));
    }

    static enum Status {
        Ok,
        NoOrganismSelected,
        MinimumQuerySizeViolation,
        MinimumNetworkSelectionViolation,
        LimitViolation;

    }

    static class WeightingMethodEntry {
        CombiningMethod method;
        String description;

        public WeightingMethodEntry(CombiningMethod method, String description) {
            this.method = method;
            this.description = description;
        }

        public CombiningMethod getMethod() {
            return this.method;
        }

        public String toString() {
            return this.description;
        }
    }
}

