/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.parsers.Query;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.view.components.BaseInfoPanel;
import org.genemania.plugin.view.components.ScrollablePanel;
import org.genemania.plugin.view.util.UiUtils;

public class NetworkSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JSplitPane pane;
    private final JPanel leftPanel;
    private final JPanel middlePanel;
    private final Map<Group<?, ?>, GroupModel> models;
    private final Map<Network<?>, JCheckBox> networkSelections;
    private final List<SelectionListener<Object>> selectionListeners;
    private final NetworkUtils networkUtils;
    private final UiUtils uiUtils;

    public NetworkSelectionPanel(NetworkUtils networkUtils, UiUtils uiUtils) {
        this.networkUtils = networkUtils;
        this.uiUtils = uiUtils;
        this.setOpaque(false);
        this.models = new HashMap();
        this.networkSelections = new HashMap();
        this.selectionListeners = new ArrayList<SelectionListener<Object>>();
        this.setLayout(new GridBagLayout());
        this.leftPanel = uiUtils.createJPanel();
        this.leftPanel.setLayout(new GridBagLayout());
        this.middlePanel = new ScrollablePanel();
        this.middlePanel.setLayout(new GridBagLayout());
        JScrollPane leftScrollPane = this.createScrollPane(this.leftPanel);
        JScrollPane middleScrollPane = this.createScrollPane(this.middlePanel);
        middleScrollPane.setHorizontalScrollBarPolicy(31);
        this.pane = new JSplitPane(1, leftScrollPane, middleScrollPane);
        this.pane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void showNetworks(Group<?, ?> group) {
        for (GroupModel model : this.models.values()) {
            model.networkPanel.setVisible(false);
            model.groupPanel.setBackground(BaseInfoPanel.defaultBackground);
        }
        if (group == null) {
            return;
        }
        GroupModel model = this.models.get(group);
        NetworkListPanel networkPanel = model.networkPanel;
        networkPanel.setVisible(true);
        model.groupPanel.setBackground(BaseInfoPanel.selectedBackground);
        this.repaint();
    }

    public void setGroups(Collection<Group<?, ?>> groups) {
        this.leftPanel.removeAll();
        this.middlePanel.removeAll();
        this.models.clear();
        this.networkSelections.clear();
        int index = 0;
        for (final Group<?, ?> group : groups) {
            final JCheckBox checkBox = this.uiUtils.createCheckBox();
            final JLabel label = new JLabel();
            JPanel groupPanel = this.uiUtils.createJPanel();
            groupPanel.setOpaque(true);
            groupPanel.setLayout(new GridBagLayout());
            groupPanel.add((Component)checkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
            groupPanel.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.leftPanel.add((Component)groupPanel, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
            final ArrayList sortedNetworks = new ArrayList(group.getNetworks());
            Collections.sort(sortedNetworks, this.networkUtils.getNetworkComparator());
            label.addMouseListener(this.createMouseListener(group));
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkSelectionPanel.this.validateSelection(label, group);
                    NetworkSelectionPanel.this.notifyListeners();
                }
            };
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkSelectionPanel.this.handleGroupCheckBoxAction(checkBox, sortedNetworks);
                    NetworkSelectionPanel.this.validateSelection(label, group);
                    NetworkSelectionPanel.this.notifyListeners();
                }
            });
            NetworkListPanel panel = new NetworkListPanel(group, sortedNetworks, listener);
            panel.setVisible(false);
            this.models.put(group, new GroupModel(checkBox, label, groupPanel, panel));
            this.validateSelection(label, group);
            this.middlePanel.add((Component)panel, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++index;
        }
        this.leftPanel.add(this.uiUtils.createFillerPanel(), new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.middlePanel.add(this.uiUtils.createFillerPanel(), new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (groups.size() > 0) {
            this.showNetworks(groups.iterator().next());
        }
        this.resetDividers();
        this.invalidate();
    }

    private MouseListener createMouseListener(final Group<?, ?> group) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NetworkSelectionPanel.this.showNetworks(group);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    private void handleGroupCheckBoxAction(JCheckBox groupCheckBox, Collection<Network<?>> networks) {
        int totalSelected = 0;
        for (Network<?> network : networks) {
            JCheckBox checkBox = this.networkSelections.get(network);
            if (!checkBox.isSelected()) continue;
            ++totalSelected;
        }
        boolean newState = totalSelected < networks.size();
        groupCheckBox.setSelected(newState);
        for (Network<?> network : networks) {
            JCheckBox checkBox = this.networkSelections.get(network);
            checkBox.setSelected(newState);
        }
    }

    private void notifyListeners() {
        SelectionEvent event = new SelectionEvent(null, true);
        for (SelectionListener<Object> listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addListener(SelectionListener<Object> listener) {
        this.selectionListeners.add(listener);
    }

    public void removeListener(SelectionListener<Object> listener) {
        this.selectionListeners.remove(listener);
    }

    private void validateSelection(JLabel label, Group group) {
        int selected = 0;
        Collection networks = group.getNetworks();
        for (Network network : networks) {
            if (!this.networkSelections.get(network).isSelected()) continue;
            ++selected;
        }
        GroupModel model = this.models.get(group);
        model.checkBox.setSelected(selected > 0);
        label.setText(String.format(Strings.detailedSelection_label, group.getName(), selected, networks.size()));
    }

    private JScrollPane createScrollPane(JPanel panel) {
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        return scrollPane;
    }

    public void resetDividers() {
        this.pane.setDividerLocation(0.5);
    }

    public Collection<Network<?>> getSelection() {
        HashSet selection = new HashSet();
        for (Map.Entry<Network<?>, JCheckBox> entry : this.networkSelections.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            selection.add(entry.getKey());
        }
        return selection;
    }

    public int getSelectionCount() {
        int count = 0;
        for (Map.Entry<Network<?>, JCheckBox> entry : this.networkSelections.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            ++count;
        }
        return count;
    }

    public Collection<Group<?, ?>> getSelectedGroups() {
        HashSet groups = new HashSet();
        for (Group<?, ?> group : this.models.keySet()) {
            boolean shouldAddGroup = false;
            ArrayList networks = new ArrayList();
            for (Network<?> network : group.getNetworks()) {
                if (!this.networkSelections.get(network).isSelected()) continue;
                networks.add(network);
                shouldAddGroup = true;
            }
            if (!shouldAddGroup) continue;
            groups.add(group.filter(networks));
        }
        return groups;
    }

    public void selectAllNetworks(boolean selected) {
        for (Map.Entry<Network<?>, JCheckBox> entry : this.networkSelections.entrySet()) {
            JCheckBox checkBox = entry.getValue();
            if (checkBox.isSelected() == selected) continue;
            checkBox.setSelected(selected);
        }
        this.synchronizeGroupCheckBoxState();
    }

    void synchronizeGroupCheckBoxState() {
        for (Map.Entry<Group<?, ?>, GroupModel> entry : this.models.entrySet()) {
            Group<?, ?> group = entry.getKey();
            GroupModel model = entry.getValue();
            this.validateSelection(model.label, group);
        }
    }

    public void selectDefaultNetworks() {
        for (Map.Entry<Network<?>, JCheckBox> entry : this.networkSelections.entrySet()) {
            Network<?> network = entry.getKey();
            JCheckBox checkBox = entry.getValue();
            boolean selected = network.isDefaultSelected();
            if (checkBox.isSelected() == selected) continue;
            checkBox.setSelected(selected);
        }
        this.synchronizeGroupCheckBoxState();
    }

    public void setSelection(Query query) {
        this.selectAllNetworks(false);
        for (Group<?, ?> group : query.getNetworks()) {
            for (Network<?> network : group.getNetworks()) {
                for (Map.Entry<Network<?>, JCheckBox> entry : this.networkSelections.entrySet()) {
                    Network<?> otherNetwork = entry.getKey();
                    if (!network.equals(otherNetwork)) continue;
                    JCheckBox checkBox = entry.getValue();
                    checkBox.setSelected(true);
                }
            }
        }
        this.synchronizeGroupCheckBoxState();
    }

    class NetworkDetailPanel
    extends JPanel {
        private JEditorPane descriptionLabel;

        public NetworkDetailPanel(JCheckBox checkBox, JLabel label, Network<?> network, Group<?, ?> group) {
            this.setOpaque(true);
            this.setBackground(SystemColor.text);
            this.setLayout(new GridBagLayout());
            final JToggleButton expander = NetworkSelectionPanel.this.uiUtils.createToggleButton();
            expander.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkDetailPanel.this.handleExpand(expander.isSelected());
                }
            });
            this.add((Component)checkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)expander, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            String description = String.format(Strings.networkDetailPanelDescription_label, NetworkSelectionPanel.this.networkUtils.buildDescriptionHtml(network, group));
            this.descriptionLabel = NetworkSelectionPanel.this.uiUtils.createLinkEnabledEditorPane(this, description);
            this.descriptionLabel.setVisible(false);
            this.descriptionLabel.setOpaque(true);
            this.descriptionLabel.setBackground(new Color(224, 224, 255));
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.add((Component)this.descriptionLabel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void handleExpand(boolean expanded) {
            this.descriptionLabel.setVisible(expanded);
            this.invalidate();
        }
    }

    class GroupModel {
        JCheckBox checkBox;
        JLabel label;
        JPanel groupPanel;
        NetworkListPanel networkPanel;

        public GroupModel(JCheckBox checkBox, JLabel label, JPanel groupPanel, NetworkListPanel networkPanel) {
            this.checkBox = checkBox;
            this.label = label;
            this.groupPanel = groupPanel;
            this.networkPanel = networkPanel;
        }
    }

    class NetworkListPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Map<Network<?>, JPanel> networkPanels;
        private Network<?> selectedNetwork;

        public NetworkListPanel(Group<?, ?> group, Collection<Network<?>> networks, ActionListener listener) {
            this.setOpaque(false);
            this.networkPanels = new HashMap();
            this.setLayout(new GridBagLayout());
            int index = 0;
            for (final Network<?> network : networks) {
                JCheckBox checkBox = NetworkSelectionPanel.this.uiUtils.createCheckBox();
                checkBox.setSelected(network.isDefaultSelected());
                checkBox.addActionListener(listener);
                JLabel label = new JLabel(network.getName());
                label.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        NetworkListPanel.this.selectedNetwork = network;
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
                NetworkDetailPanel panel = new NetworkDetailPanel(checkBox, label, network, group);
                this.add((Component)panel, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
                NetworkSelectionPanel.this.networkSelections.put(network, checkBox);
                this.networkPanels.put(network, panel);
                ++index;
            }
        }

        public Network<?> getSelectedNetwork() {
            return this.selectedNetwork;
        }
    }
}

