/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JCheckBox;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.proxies.NetworkProxy;

public class NetworkChangeListener<NETWORK, NODE, EDGE>
implements ActionListener {
    private final Group<?, ?> source;
    private final Map<Object, ViewState> configurations;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;

    public NetworkChangeListener(Group<?, ?> group, Map<Object, ViewState> configurations, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        this.source = group;
        this.configurations = configurations;
        this.cytoscapeUtils = cytoscapeUtils;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBox checkBox = (JCheckBox)e.getSource();
        NETWORK network = this.cytoscapeUtils.getCurrentNetwork();
        if (network == null) {
            return;
        }
        boolean selected = checkBox.isSelected();
        NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.cytoscapeUtils.getNetworkProxy(network);
        ViewState config = this.configurations.get(networkProxy.getIdentifier());
        if (config == null) {
            return;
        }
        this.cytoscapeUtils.setHighlight(config, this.source, network, selected);
    }
}

