/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.genemania.domain.Gene;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.controllers.ManiaResultsController;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.view.FunctionInfoPanel;
import org.genemania.plugin.view.GeneInfoPanel;
import org.genemania.plugin.view.NetworkGroupInfoPanel;
import org.genemania.plugin.view.util.UiUtils;

public class ManiaResultsPanel<NETWORK, NODE, EDGE>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel organismLabel;
    private ViewState options;
    private GeneInfoPanel genePanel;
    private NetworkGroupInfoPanel<NETWORK, NODE, EDGE> networkPanel;
    private FunctionInfoPanel functionPanel;
    private SelectionListener<Gene> geneListener;
    private SelectionListener<Group<?, ?>> networkListener;
    private SelectionListener<Gene> functionListener;
    private final ManiaResultsController<NETWORK, NODE, EDGE> controller;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    private final NetworkUtils networkUtils;
    private final UiUtils uiUtils;

    public ManiaResultsPanel(ManiaResultsController<NETWORK, NODE, EDGE> controller, GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, NetworkUtils networkUtils, UiUtils uiUtils) {
        this.controller = controller;
        this.plugin = plugin;
        this.cytoscapeUtils = cytoscapeUtils;
        this.networkUtils = networkUtils;
        this.uiUtils = uiUtils;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 3));
        this.addComponents();
    }

    private void addComponents() {
        this.organismLabel = new JLabel();
        this.organismLabel.setAlignmentX(0.5f);
        this.add(this.organismLabel);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.setAlignmentX(0.5f);
        JPanel networkContents = this.uiUtils.createJPanel();
        networkContents.setLayout(new GridBagLayout());
        this.networkPanel = new NetworkGroupInfoPanel<NETWORK, NODE, EDGE>(this.plugin, this.cytoscapeUtils, this.networkUtils, this.uiUtils);
        JScrollPane networkScrollPane = new JScrollPane(this.networkPanel);
        JPanel optionsPanel = this.networkPanel.createExpanderPanel(Strings.maniaResultsPanelNetworkOptions_label);
        networkContents.add((Component)optionsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 19, 2, new Insets(0, 0, 0, 0), 0, 0));
        networkContents.add((Component)networkScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        tabPane.add(networkContents);
        tabPane.setTitleAt(0, Strings.maniaResultsPanelNetworkTab_label);
        JPanel geneContents = this.uiUtils.createJPanel();
        geneContents.setLayout(new GridBagLayout());
        this.genePanel = new GeneInfoPanel(this.networkUtils, this.uiUtils);
        JScrollPane geneScrollPane = new JScrollPane(this.genePanel);
        optionsPanel = this.genePanel.createExpanderPanel(Strings.maniaResultsPanelGeneOptions_label);
        geneContents.add((Component)optionsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 19, 2, new Insets(0, 0, 0, 0), 0, 0));
        geneContents.add((Component)geneScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        tabPane.add(geneContents);
        tabPane.setTitleAt(1, Strings.maniaResultsPanelGeneTab_label);
        JPanel functionContents = this.uiUtils.createJPanel();
        functionContents.setLayout(new GridBagLayout());
        this.functionPanel = new FunctionInfoPanel(this.uiUtils);
        functionContents.add((Component)this.functionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        tabPane.add(functionContents);
        tabPane.setTitleAt(2, Strings.maniaResultsPanelFunctionTab_label);
        this.add(tabPane);
        JButton exportButton = new JButton(Strings.maniaResultsPanelExportButton_label);
        exportButton.setAlignmentX(0.5f);
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManiaResultsPanel.this.handleExportButton();
            }
        });
        this.add(exportButton);
        JButton attributesButton = new JButton(Strings.maniaResultsAttributesButton_label);
        attributesButton.setAlignmentX(0.5f);
        attributesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManiaResultsPanel.this.handleAttributesButton();
            }
        });
        this.add(attributesButton);
    }

    protected void handleExportButton() {
        try {
            this.controller.exportReport(this, this.options);
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
        }
    }

    private void handleAttributesButton() {
        NETWORK cyNetwork = this.cytoscapeUtils.getCurrentNetwork();
        this.controller.showAttributesDialog(cyNetwork, this.options);
    }

    public void applyOptions(ViewState options) {
        if (this.geneListener != null) {
            this.genePanel.removeSelectionListener(this.geneListener);
        }
        if (this.networkListener != null) {
            this.networkPanel.removeSelectionListener(this.networkListener);
        }
        this.options = options;
        SearchResult result = options.getSearchResult();
        Organism organism = result.getOrganism();
        this.organismLabel.setText(String.format(Strings.maniaResultsPanelOrganism_label, organism.getName()));
        NetworkSelectionManager<NETWORK, NODE, EDGE> selectionManager = this.plugin.getNetworkSelectionManager();
        this.geneListener = selectionManager.createGeneListSelectionListener(this.genePanel, options);
        this.networkListener = selectionManager.createNetworkListSelectionListener(this.networkPanel, options);
        this.functionListener = selectionManager.createFunctionListSelectionListener(this.functionPanel, result);
        this.genePanel.applyOptions(options);
        this.genePanel.addSelectionListener(this.geneListener);
        this.networkPanel.applyOptions(options);
        this.networkPanel.addSelectionListener(this.networkListener);
        this.functionPanel.applyOptions(options);
        this.functionPanel.setSelectionListener(this.functionListener);
        this.updateSelection(options);
    }

    public void updateSelection(ViewState options) {
        this.controller.computeHighlightedNetworks(options);
        this.genePanel.updateSelection(options);
        this.networkPanel.updateSelection(options);
        this.functionPanel.updateSelection(options);
    }
}

