/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.genemania.domain.Gene;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.view.components.ToggleDetailPanel;
import org.genemania.plugin.view.util.UiUtils;

public class GeneDetailPanel
extends ToggleDetailPanel<Gene> {
    private static final long serialVersionUID = 1L;
    private static final int MINIMUM_WIDTH_HINT = 350;
    final Gene gene;
    final double score;
    final JEditorPane descriptionLabel;
    final boolean isQueryGene;
    private final JToggleButton expander;
    private final Component fillerPanel;

    public GeneDetailPanel(Gene gene, double score, boolean isQueryGene, NetworkUtils networkUtils, UiUtils uiUtils) {
        super(uiUtils);
        this.gene = gene;
        this.score = score;
        this.isQueryGene = isQueryGene;
        this.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.white));
        this.setLayout(new GridBagLayout());
        String name = networkUtils.getGeneLabel(gene);
        JLabel nameLabel = new JLabel(name);
        nameLabel.setFont(nameLabel.getFont().deriveFont(1));
        this.expander = this.createToggleButton();
        this.add((Component)this.expander, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)nameLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (isQueryGene) {
            nameLabel.setForeground(new Color(32, 128, 32));
        } else {
            JLabel scoreLabel = new JLabel(String.format("%.2f", score * 100.0));
            this.add((Component)scoreLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        String description = networkUtils.buildGeneDescription(gene);
        this.descriptionLabel = uiUtils.createLinkEnabledEditorPane(this, description);
        this.descriptionLabel.setFont(this.getFont());
        this.descriptionLabel.setVisible(false);
        this.descriptionLabel.setOpaque(true);
        this.descriptionLabel.setBackground(Color.white);
        this.add((Component)this.descriptionLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.fillerPanel = uiUtils.createFillerPanel(Color.white);
        this.fillerPanel.setVisible(false);
        this.add(this.fillerPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Gene getSubject() {
        return this.gene;
    }

    public double getScore() {
        return this.score;
    }

    @Override
    protected void doShowDetails(boolean show, int depth) {
        this.expander.setSelected(show);
        this.fillerPanel.setVisible(show);
        this.descriptionLabel.setVisible(show);
        this.invalidate();
    }

    public boolean getShowDetails() {
        return this.descriptionLabel.isVisible();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        if (this.descriptionLabel.isVisible()) {
            return new Dimension(Math.max(350, size.width), size.height);
        }
        return size;
    }

    public String getGeneName() {
        return this.gene.getSymbol();
    }
}

