/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.view.util.UiUtils;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AboutDialog(Frame parent, UiUtils uiUtils, URL resourceBaseUrl) {
        super(parent, Strings.aboutDialog_title, true);
        parent.setIconImage(uiUtils.getFrameIcon());
        InputStream aboutText = this.getClass().getResourceAsStream("about.html");
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(aboutText));
        try {
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            LogUtils.log(this.getClass(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LogUtils.log(this.getClass(), e);
            }
        }
        JPanel panel = uiUtils.createJPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(32, 32, 32, 32));
        JEditorPane pane = uiUtils.createLinkEnabledEditorPane(this, buffer.toString(), resourceBaseUrl);
        pane.setFont(this.getFont());
        KeyListener listener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: 
                    case 27: {
                        AboutDialog.this.dispose();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        pane.addKeyListener(listener);
        pane.setAlignmentX(0.5f);
        panel.add(pane);
        JButton button = new JButton(Strings.aboutDialogCloseButton_label);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        button.setAlignmentX(0.5f);
        panel.add(button);
        uiUtils.setPreferredWidth(pane, 500);
        this.add(panel);
        this.pack();
    }
}

