/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.genemania.domain.Gene;
import org.genemania.domain.OntologyCategory;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.OntologyMediator;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.AnnotationEntry;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;

public class ManiaReport {
    private final List<GeneEntry> genes;
    private final List<Network<?>> networks;
    private final DataSet data;
    private final ViewState options;
    private final List<Group<?, ?>> groups;
    private final Map<String, OntologyCategory> categories;

    public ManiaReport(ViewState options, DataSet data) {
        this.options = options;
        this.data = data;
        SearchResult result = options.getSearchResult();
        this.groups = this.computeGroups(options);
        this.networks = this.populateNetworks(options, this.groups);
        this.genes = this.populateGenes(result);
        this.categories = this.populateCategories(result);
    }

    private List<Group<?, ?>> computeGroups(ViewState options) {
        ArrayList groups = new ArrayList(options.getAllGroups());
        Collections.sort(groups, new Comparator<Group<?, ?>>(){

            @Override
            public int compare(Group<?, ?> group1, Group<?, ?> group2) {
                int result = Double.compare(group1.getWeight(), group2.getWeight());
                if (result != 0) {
                    return result;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(group1.getName(), group2.getName());
            }
        });
        return groups;
    }

    private Map<String, OntologyCategory> populateCategories(SearchResult options) {
        HashMap<String, OntologyCategory> result = new HashMap<String, OntologyCategory>();
        OntologyMediator mediator = this.data.getMediatorProvider().getOntologyMediator();
        for (AnnotationEntry annotation : options.getEnrichmentSummary()) {
            String name = annotation.getName();
            try {
                result.put(name, mediator.getCategory(name));
            }
            catch (DataStoreException e) {
                Logger logger = Logger.getLogger(this.getClass());
                logger.error((Object)String.format("Can't find category: %s", new Object[]{name, e}));
            }
        }
        return result;
    }

    private List<GeneEntry> populateGenes(SearchResult options) {
        ArrayList<GeneEntry> result = new ArrayList<GeneEntry>();
        final Map<Gene, Double> scores = options.getScores();
        ArrayList<Gene> genes = new ArrayList<Gene>(scores.keySet());
        Collections.sort(genes, new Comparator<Gene>(){

            @Override
            public int compare(Gene gene1, Gene gene2) {
                return ((Double)scores.get(gene2)).compareTo((Double)scores.get(gene1));
            }
        });
        Map<Long, Gene> queryGenes = options.getQueryGenes();
        for (Gene gene : genes) {
            double score = queryGenes.containsKey(gene.getNode().getId()) ? Double.MAX_VALUE : scores.get(gene) * 100.0;
            result.add(new GeneEntry(gene, score));
        }
        return result;
    }

    private List<Network<?>> populateNetworks(final ViewState options, List<Group<?, ?>> groups) {
        ArrayList result = new ArrayList();
        for (Group<?, ?> group : groups) {
            result.addAll(group.getNetworks());
        }
        Collections.sort(result, new Comparator<Network<?>>(){

            @Override
            public int compare(Network<?> network1, Network<?> network2) {
                Group<?, ?> group1 = options.getGroup(network1);
                Group<?, ?> group2 = options.getGroup(network2);
                int result = Double.compare(group2.getWeight(), group1.getWeight());
                if (result != 0) {
                    return result;
                }
                result = String.CASE_INSENSITIVE_ORDER.compare(group1.getName(), group2.getName());
                if (result != 0) {
                    return result;
                }
                return Double.compare(network2.getWeight(), network1.getWeight());
            }
        });
        return result;
    }

    public List<GeneEntry> getGenes() {
        return this.genes;
    }

    public List<Network<?>> getNetworks() {
        return this.networks;
    }

    public String getDataVersion() {
        return this.data.getVersion().toString();
    }

    public ViewState getViewState() {
        return this.options;
    }

    public OntologyCategory getCategory(String name) {
        return this.categories.get(name);
    }

    public static class GeneEntry {
        Gene gene;
        double score;

        public GeneEntry(Gene gene, double score) {
            this.gene = gene;
            this.score = score;
        }

        public Gene getGene() {
            return this.gene;
        }

        public double getScore() {
            return this.score;
        }
    }
}

