/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.Strings;
import org.genemania.plugin.apps.IQueryErrorHandler;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.impl.InteractionNetworkGroupImpl;
import org.genemania.plugin.model.impl.InteractionNetworkImpl;
import org.genemania.plugin.parsers.AbstractQueryParser;
import org.genemania.plugin.parsers.Query;
import org.genemania.type.CombiningMethod;

public class WebsiteQueryParser
extends AbstractQueryParser {
    static Pattern pattern = Pattern.compile("(.+?)(\\s+\\((.+)\\))?");

    @Override
    public Query parse(DataSet data, Reader reader, IQueryErrorHandler handler) throws IOException {
        BufferedReader input = new BufferedReader(reader);
        Query query = new Query();
        query.setNetworks(new HashSet());
        State state = State.read_parameters;
        String line = input.readLine();
        try {
            while (line != null) {
                String[] values = line.split("\t");
                switch (state) {
                    case read_parameters: {
                        if ("Organism".equals(values[0])) {
                            this.handleOrganism(data, values, query);
                            break;
                        }
                        if ("Genes".equals(values[0])) {
                            this.handleGenes(data, values, query, handler);
                            break;
                        }
                        if ("Networks".equals(values[0])) {
                            state = State.read_networks;
                            break;
                        }
                        if ("Network weighting code".equals(values[0])) {
                            this.handleWeightingMethod(data, values, query, handler);
                            break;
                        }
                        if (!"Number of gene results".equals(values[0])) break;
                        this.handleGeneLimit(data, values, query);
                        break;
                    }
                    case read_networks: {
                        if ("".equals(values[0])) {
                            state = State.read_parameters;
                            break;
                        }
                        this.handleNetworkGroup(data, values, query, handler);
                    }
                }
                line = input.readLine();
            }
        }
        catch (DataStoreException e) {
            throw new IOException(e);
        }
        if (query.getOrganism() == null) {
            throw new IOException(Strings.websiteQueryParser_error);
        }
        return query;
    }

    private void handleNetworkGroup(DataSet data, String[] values, Query query, IQueryErrorHandler handler) throws IOException {
        String groupName = values[0];
        Organism organism = query.getOrganism();
        InteractionNetworkGroup targetGroup = null;
        for (InteractionNetworkGroup group : organism.getInteractionNetworkGroups()) {
            if (!group.getCode().equals(groupName) && !group.getName().equals(groupName)) continue;
            targetGroup = group;
        }
        if (targetGroup == null) {
            throw new IOException(String.format("Unrecognized group: %s", groupName));
        }
        ArrayList<Network<InteractionNetwork>> networks = new ArrayList<Network<InteractionNetwork>>();
        for (int i = 1; i < values.length; ++i) {
            String name = values[i];
            boolean found = false;
            for (InteractionNetwork network : targetGroup.getInteractionNetworks()) {
                if (!network.getName().equals(name)) continue;
                networks.add(new InteractionNetworkImpl(network, 0.0));
                found = true;
                break;
            }
            if (found) continue;
            handler.handleUnrecognizedNetwork(name);
        }
        if (networks.size() == 0) {
            throw new IOException("No networks were recognized");
        }
        query.getNetworks().add(new InteractionNetworkGroupImpl(targetGroup, networks));
    }

    private void handleGeneLimit(DataSet data, String[] values, Query query) {
        int limit = Integer.parseInt(values[1]);
        query.setGeneLimit(limit);
    }

    private void handleWeightingMethod(DataSet data, String[] values, Query query, IQueryErrorHandler handler) {
        Matcher matcher = pattern.matcher(values[1]);
        CombiningMethod method = null;
        if (matcher.matches()) {
            method = CombiningMethod.fromCode((String)matcher.group(1));
        }
        if (method == null || method == CombiningMethod.UNKNOWN) {
            method = CombiningMethod.AUTOMATIC_SELECT;
            handler.warn(String.format("Unrecognized combining method \"%s\".  Defaulting to: %s", values[1], method));
        }
        query.setCombiningMethod(method);
    }

    private void handleGenes(DataSet data, String[] values, Query query, IQueryErrorHandler handler) {
        ArrayList<String> genes = new ArrayList<String>();
        for (int i = 1; i < values.length; ++i) {
            genes.add(values[i]);
        }
        query.setGenes(genes);
    }

    private void handleOrganism(DataSet data, String[] values, Query query) throws DataStoreException, IOException {
        Organism organism = null;
        Matcher matcher = pattern.matcher(values[1]);
        if (matcher.matches()) {
            organism = this.parseOrganism(data, matcher.group(1));
            if (organism == null) {
                organism = this.parseOrganism(data, matcher.group(3));
            }
        } else {
            organism = this.parseOrganism(data, values[1]);
        }
        if (organism == null) {
            throw new IOException(String.format("Unrecognized organism: %s", values[1]));
        }
        query.setOrganism(organism);
    }

    static enum State {
        read_parameters,
        read_networks;

    }
}

