/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Node;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.model.ViewStateBuilder;
import org.genemania.plugin.model.impl.AbstractGroup;
import org.genemania.plugin.model.impl.InteractionNetworkGroupImpl;
import org.genemania.plugin.model.impl.InteractionNetworkImpl;
import org.genemania.plugin.model.impl.ResultAttributeGroupImpl;
import org.genemania.plugin.model.impl.ResultAttributeNetworkImpl;

public class ViewStateImpl
implements ViewStateBuilder {
    private final Map<String, Set<Network<?>>> networksByEdge;
    private final Map<String, Set<Network<?>>> networksByNode;
    private final Map<Group<?, ?>, Set<String>> edgeCache;
    private final Map<String, Long> nodeCache;
    private final Set<Group<?, ?>> enabledGroups;
    private final Set<Group<?, ?>> highlightedGroups;
    private final Set<Network<?>> highlightedNetworks;
    private final Set<String> highlightedNodes;
    private final Map<Network<?>, Group<?, ?>> groupsByNetwork;
    private final Map<String, Group<?, ?>> groupsByName;
    private String mostRecentNode;
    private Group<?, ?> mostRecentGroup;
    private SearchResult searchResult;

    public ViewStateImpl(SearchResult result) {
        this.searchResult = result;
        this.edgeCache = new HashMap();
        this.nodeCache = new WeakHashMap<String, Long>();
        this.enabledGroups = new HashSet();
        this.highlightedGroups = new HashSet();
        this.highlightedNetworks = new HashSet();
        this.highlightedNodes = new HashSet<String>();
        this.networksByEdge = new HashMap();
        this.networksByNode = new HashMap();
        this.groupsByName = new HashMap();
        this.groupsByNetwork = new HashMap();
        this.addGroups(result);
    }

    private void addGroups(SearchResult result) {
        AbstractGroup group;
        Map<InteractionNetwork, Double> weights = result.getNetworkWeights();
        for (InteractionNetworkGroup model : result.getInteractionNetworkGroups().values()) {
            ArrayList<Network<InteractionNetwork>> arrayList = new ArrayList<Network<InteractionNetwork>>();
            for (InteractionNetwork network : model.getInteractionNetworks()) {
                Double weight = weights.get(network);
                if (weight == null) continue;
                arrayList.add(new InteractionNetworkImpl(network, weight));
            }
            group = new InteractionNetworkGroupImpl(model, arrayList);
            this.groupsByName.put(model.getName(), group);
            for (Network network : group.getNetworks()) {
                this.groupsByNetwork.put(network, group);
            }
        }
        weights = result.getAttributeWeights();
        if (weights != null) {
            HashMap<AttributeGroup, ArrayList<ResultAttributeNetworkImpl>> networksByGroup = new HashMap<AttributeGroup, ArrayList<ResultAttributeNetworkImpl>>();
            for (Map.Entry<InteractionNetwork, Double> entry : weights.entrySet()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeGroup group2 = result.getAttributeGroup(attribute.getId());
                ArrayList<ResultAttributeNetworkImpl> networks = (ArrayList<ResultAttributeNetworkImpl>)networksByGroup.get(group2);
                if (networks == null) {
                    networks = new ArrayList<ResultAttributeNetworkImpl>();
                    networksByGroup.put(group2, networks);
                }
                networks.add(new ResultAttributeNetworkImpl(attribute, entry.getValue()));
            }
            for (Map.Entry<Object, Double> entry : networksByGroup.entrySet()) {
                group = new ResultAttributeGroupImpl((AttributeGroup)entry.getKey(), (Collection)((Object)entry.getValue()));
                this.groupsByName.put(((ResultAttributeGroupImpl)group).getName(), group);
                for (Network network : group.getNetworks()) {
                    this.groupsByNetwork.put(network, group);
                }
                this.setEnabled(group, true);
            }
        }
    }

    @Override
    public boolean getEnabled(Group<?, ?> group) {
        return this.enabledGroups.contains(group);
    }

    @Override
    public void setEnabled(Group<?, ?> group, boolean enabled) {
        if (enabled) {
            this.enabledGroups.add(group);
        } else {
            this.enabledGroups.remove(group);
        }
    }

    @Override
    public void setGeneHighlighted(String name, boolean highlighted) {
        if (name == null) {
            return;
        }
        if (highlighted) {
            this.highlightedNodes.add(name);
            this.mostRecentNode = name;
        } else {
            this.highlightedNodes.remove(name);
        }
    }

    @Override
    public void setGroupHighlighted(Group<?, ?> group, boolean highlighted) {
        if (highlighted) {
            this.highlightedGroups.add(group);
            this.mostRecentGroup = group;
        } else {
            this.highlightedGroups.remove(group);
        }
    }

    @Override
    public void setNetworkHighlighted(Network<?> network, boolean highlighted) {
        if (highlighted) {
            this.highlightedNetworks.add(network);
        } else {
            this.highlightedNetworks.remove(network);
        }
    }

    @Override
    public boolean getGeneHighlighted(String name) {
        return this.highlightedNodes.contains(name);
    }

    @Override
    public boolean getGroupHighlighted(Group<?, ?> group) {
        return this.highlightedGroups.contains(group);
    }

    @Override
    public boolean getNetworkHighlighted(Network<?> network) {
        return this.highlightedNetworks.contains(network);
    }

    @Override
    public int getTotalHighlightedGenes() {
        return this.highlightedNodes.size();
    }

    @Override
    public String getMostRecentNode() {
        return this.mostRecentNode;
    }

    @Override
    public Group<?, ?> getMostRecentGroup() {
        return this.mostRecentGroup;
    }

    @Override
    public void clearHighlightedNetworks() {
        this.highlightedNetworks.clear();
    }

    @Override
    public void clearHighlightedGroups() {
        this.highlightedGroups.clear();
    }

    @Override
    public Group<?, ?> getGroup(String name) {
        return this.groupsByName.get(name);
    }

    @Override
    public Long getNodeId(String nodeId) {
        return this.nodeCache.get(nodeId);
    }

    @Override
    public Set<Network<?>> getNetworksByEdge(String edgeId) {
        Set<Network<?>> networks = this.networksByEdge.get(edgeId);
        if (networks == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(networks);
    }

    @Override
    public Set<Network<?>> getNetworksByNode(String nodeId) {
        Set<Network<?>> networks = this.networksByNode.get(nodeId);
        if (networks == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(networks);
    }

    @Override
    public Group<?, ?> getGroup(Network<?> network) {
        return this.groupsByNetwork.get(network);
    }

    @Override
    public ViewState build() {
        return this;
    }

    @Override
    public void addEdge(Group<?, ?> group, String edgeId) {
        Set<String> edgeIds = this.edgeCache.get(group);
        if (edgeIds == null) {
            edgeIds = new HashSet<String>();
            this.edgeCache.put(group, edgeIds);
        }
        edgeIds.add(edgeId);
        if (group != null) {
            this.addEdge(null, edgeId);
        }
    }

    @Override
    public Set<String> getEdgeIds(Group<?, ?> group) {
        return this.edgeCache.get(group);
    }

    @Override
    public void addSourceNetworkForEdge(String edgeId, Network<?> network) {
        Set<Network<?>> networks = this.networksByEdge.get(edgeId);
        if (networks == null) {
            networks = new HashSet();
            this.networksByEdge.put(edgeId, networks);
        }
        networks.add(network);
    }

    @Override
    public void addSourceNetworkForNode(String nodeId, Network<?> network) {
        Set<Network<?>> networks = this.networksByNode.get(nodeId);
        if (networks == null) {
            networks = new HashSet();
            this.networksByNode.put(nodeId, networks);
        }
        networks.add(network);
    }

    @Override
    public void addNode(Node node, String nodeId) {
        this.nodeCache.put(nodeId, node.getId());
    }

    @Override
    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    @Override
    public Set<Group<?, ?>> getAllGroups() {
        return new HashSet(this.groupsByName.values());
    }
}

