/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.impl.AbstractGroup;
import org.genemania.plugin.model.impl.InteractionNetworkImpl;

public class InteractionNetworkGroupImpl
extends AbstractGroup<InteractionNetworkGroup, InteractionNetwork> {
    private InteractionNetworkGroup group;

    public InteractionNetworkGroupImpl(InteractionNetworkGroup group) {
        super(InteractionNetworkGroupImpl.extractNetworks(group));
        this.group = group;
    }

    private static Collection<Network<InteractionNetwork>> extractNetworks(InteractionNetworkGroup group) {
        ArrayList<Network<InteractionNetwork>> result = new ArrayList<Network<InteractionNetwork>>();
        for (InteractionNetwork network : group.getInteractionNetworks()) {
            result.add(new InteractionNetworkImpl(network, 0.0));
        }
        return result;
    }

    public InteractionNetworkGroupImpl(InteractionNetworkGroup group, Collection<Network<InteractionNetwork>> networks) {
        super(networks);
        this.group = group;
    }

    @Override
    public InteractionNetworkGroup getModel() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.group.getName();
    }

    @Override
    public String getCode() {
        return this.group.getCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof InteractionNetworkGroupImpl)) {
            return false;
        }
        return ((InteractionNetworkGroupImpl)other).getModel().getId() == this.group.getId();
    }

    public int hashCode() {
        return (int)(this.group.getId() % Integer.MAX_VALUE);
    }

    @Override
    public <T, S> Group<T, S> adapt(Class<T> groupType, Class<S> networkType) {
        if (!groupType.equals(InteractionNetworkGroup.class)) {
            return null;
        }
        if (!networkType.equals(InteractionNetwork.class)) {
            return null;
        }
        return this;
    }

    @Override
    protected Group<InteractionNetworkGroup, InteractionNetwork> create(Collection<Network<InteractionNetwork>> networks) {
        return new InteractionNetworkGroupImpl(this.group, networks);
    }
}

