/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;

public abstract class AbstractGroup<G, N>
implements Group<G, N> {
    private Collection<Network<N>> networks;
    private boolean hasInteractions;

    public AbstractGroup(Collection<Network<N>> networks) {
        this.networks = new ArrayList<Network<N>>(networks);
        this.hasInteractions = this.hasInteractions(networks);
    }

    @Override
    public Collection<Network<N>> getNetworks() {
        return this.networks;
    }

    @Override
    public double getWeight() {
        double weight = 0.0;
        for (Network<N> network : this.networks) {
            weight += network.getWeight();
        }
        return weight;
    }

    private boolean hasInteractions(Collection<Network<N>> networks) {
        for (Network<N> network : networks) {
            if (!network.hasInteractions()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInteractions() {
        return this.hasInteractions;
    }

    @Override
    public Group<G, N> filter(Collection<Network<?>> filter) {
        ArrayList<Network<N>> filtered = new ArrayList<Network<N>>();
        for (Network<N> network : this.networks) {
            if (!filter.contains(network)) continue;
            filtered.add(network);
        }
        return this.create(filtered);
    }

    protected abstract Group<G, N> create(Collection<Network<N>> var1);
}

