/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.model;

import org.codehaus.jackson.JsonNode;
import org.genemania.domain.OntologyCategory;
import org.genemania.dto.OntologyCategoryDto;

public class AnnotationEntry {
    private final String name;
    private final String description;
    private final double qValue;
    private final int sampleOccurrences;
    private final int totalOccurrences;

    public AnnotationEntry(OntologyCategory category, OntologyCategoryDto categoryVo) {
        this.name = category.getName();
        this.description = category.getDescription();
        this.qValue = categoryVo.getqValue();
        this.sampleOccurrences = categoryVo.getNumAnnotatedInSample();
        this.totalOccurrences = categoryVo.getNumAnnotatedInTotal();
    }

    public AnnotationEntry(JsonNode node) {
        this.name = node.get("name").getTextValue();
        this.description = node.get("description").getTextValue();
        this.qValue = node.get("qValue").getDoubleValue();
        this.sampleOccurrences = node.get("sample").getIntValue();
        this.totalOccurrences = node.get("total").getIntValue();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public double getQValue() {
        return this.qValue;
    }

    public int getSampleOccurrences() {
        return this.sampleOccurrences;
    }

    public int getTotalOccurrences() {
        return this.totalOccurrences;
    }
}

