/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.delegates;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.cytoscape.ResultReconstructor;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.delegates.Delegate;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.util.ProgressReporter;

public class SessionChangeDelegate<NETWORK, NODE, EDGE>
implements Delegate {
    private final File dataSetPath;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    private final ProgressReporter progress;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;

    public SessionChangeDelegate(File dataSetPath, GeneMania<NETWORK, NODE, EDGE> plugin, ProgressReporter progress, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        this.dataSetPath = dataSetPath;
        this.plugin = plugin;
        this.progress = progress;
        this.cytoscapeUtils = cytoscapeUtils;
    }

    @Override
    public void invoke() throws ApplicationException {
        DataSetManager dataSetManager = this.plugin.getDataSetManager();
        dataSetManager.setDataSourcePath(this.dataSetPath);
        try {
            DataSet data = this.findDataSet(this.dataSetPath, dataSetManager);
            if (data == null) {
                this.plugin.initializeData(this.progress, true);
                data = dataSetManager.getDataSet();
            }
            NetworkSelectionManager<NETWORK, NODE, EDGE> manager = this.plugin.getNetworkSelectionManager();
            Iterator<NETWORK> i$ = this.cytoscapeUtils.getNetworks().iterator();
            while (i$.hasNext()) {
                ResultReconstructor<NETWORK, NODE, EDGE> reconstructor = new ResultReconstructor<NETWORK, NODE, EDGE>(data, this.plugin, this.cytoscapeUtils);
                NETWORK cyNetwork = i$.next();
                ViewState options = reconstructor.reconstructCache(cyNetwork, this.progress);
                if (options == null) {
                    return;
                }
                manager.addNetworkConfiguration(cyNetwork, options);
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
        catch (DataStoreException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private DataSet findDataSet(File path, DataSetManager dataSetManager) throws ApplicationException {
        if (path == null) {
            return null;
        }
        if (path.exists()) {
            this.plugin.loadDataSet(path, this.progress, false, true);
            return dataSetManager.getDataSet();
        }
        String rawPath = path.getPath();
        for (String delimiter : new String[]{"/", "\\\\"}) {
            String[] parts = rawPath.split(delimiter);
            String name = parts[parts.length - 1];
            File candidatePath = dataSetManager.getDataSetPath(name);
            if (candidatePath == null) continue;
            this.plugin.loadDataSet(candidatePath, this.progress, false, true);
            return dataSetManager.getDataSet();
        }
        return null;
    }
}

