/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.delegates;

import org.genemania.exception.ApplicationException;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.delegates.Delegate;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.NetworkSelectionManager;

public class SelectionDelegate<NETWORK, NODE, EDGE>
implements Delegate {
    protected final boolean selected;
    protected NETWORK network;
    protected final NetworkSelectionManager<NETWORK, NODE, EDGE> manager;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    protected final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private static Object selectionMutex = new Object();

    public SelectionDelegate(boolean selected, NETWORK network, NetworkSelectionManager<NETWORK, NODE, EDGE> manager, GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        this.selected = selected;
        this.network = network;
        this.manager = manager;
        this.plugin = plugin;
        this.cytoscapeUtils = cytoscapeUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws ApplicationException {
        Object object = selectionMutex;
        synchronized (object) {
            if (!this.manager.isSelectionListenerEnabled()) {
                return;
            }
            ViewState options = this.manager.getNetworkConfiguration(this.network);
            if (options == null) {
                return;
            }
            this.handleSelection(options);
            boolean listenerState = this.manager.isSelectionListenerEnabled();
            this.manager.setSelectionListenerEnabled(false);
            try {
                this.plugin.updateSelection(options);
            }
            finally {
                this.manager.setSelectionListenerEnabled(listenerState);
            }
        }
    }

    protected void handleSelection(ViewState options) throws ApplicationException {
    }
}

