/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.delegates;

import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.controllers.RetrieveRelatedGenesController;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IConfiguration;
import org.genemania.plugin.delegates.Delegate;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.RetrieveRelatedGenesDialog;
import org.genemania.plugin.view.util.UiUtils;

public class RetrieveRelatedGenesDelegate<NETWORK, NODE, EDGE>
implements Delegate {
    private static final long MIN_HEAP_SIZE = 900000000L;
    private final RetrieveRelatedGenesDialog<NETWORK, NODE, EDGE> dialog;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    private final UiUtils uiUtils;

    public RetrieveRelatedGenesDelegate(GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, NetworkUtils networkUtils, UiUtils uiUtils, FileUtils fileUtils, TaskDispatcher taskDispatcher) {
        this.plugin = plugin;
        this.uiUtils = uiUtils;
        DataSetManager dataSetManager = plugin.getDataSetManager();
        this.dialog = new RetrieveRelatedGenesDialog<NETWORK, NODE, EDGE>(null, false, new RetrieveRelatedGenesController<NETWORK, NODE, EDGE>(plugin, cytoscapeUtils, networkUtils, taskDispatcher), dataSetManager, networkUtils, uiUtils, cytoscapeUtils, fileUtils, taskDispatcher, plugin);
        this.dialog.setAlwaysOnTop(false);
        this.dialog.setResizable(true);
        this.dialog.setSize(900, 600);
        this.dialog.setLocationByPlatform(true);
    }

    @Override
    public void invoke() {
        this.checkHeapSize();
        DataSetManager dataSetManager = this.plugin.getDataSetManager();
        DataSet data = dataSetManager.getDataSet();
        if (data == null) {
            this.plugin.initializeData(this.dialog, true);
            data = dataSetManager.getDataSet();
        }
        if (data != null) {
            try {
                List organisms = data.getMediatorProvider().getOrganismMediator().getAllOrganisms();
                if (organisms.size() == 0) {
                    IConfiguration configuration = data.getConfiguration();
                    configuration.showUi(this.dialog);
                }
            }
            catch (DataStoreException e) {
                LogUtils.log(this.getClass(), e);
            }
        }
        this.dialog.setVisible(true);
    }

    private void checkHeapSize() {
        Runtime runtime = Runtime.getRuntime();
        if (runtime.maxMemory() < 900000000L) {
            String message = String.format(Strings.heapSize_error, (int)(runtime.maxMemory() / 1000000L), 900);
            JEditorPane editor = this.uiUtils.createLinkEnabledEditorPane(this.dialog, message);
            JOptionPane.showMessageDialog(this.dialog, editor, Strings.heapSize_title, 2);
        }
    }

    public RetrieveRelatedGenesDialog<NETWORK, NODE, EDGE> getDialog() {
        return this.dialog;
    }
}

