/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.delegates;

import org.genemania.exception.ApplicationException;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.delegates.SelectionDelegate;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.plugin.selection.NetworkSelectionManager;

public class NodeSelectionDelegate<NETWORK, NODE, EDGE>
extends SelectionDelegate<NETWORK, NODE, EDGE> {
    private final NODE node;

    public NodeSelectionDelegate(NODE node, boolean selected, NETWORK network, NetworkSelectionManager<NETWORK, NODE, EDGE> manager, GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        super(selected, network, manager, plugin, cytoscapeUtils);
        this.node = node;
    }

    @Override
    protected void handleSelection(ViewState options) throws ApplicationException {
        NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(this.node, this.network);
        String name = nodeProxy.getAttribute("gene name", String.class);
        options.setGeneHighlighted(name, this.selected);
    }
}

