/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.genemania.data.normalizer.DataFileClassifier;
import org.genemania.data.normalizer.DataFileType;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.OrganismClassifier;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.validation.ValidationEventListener;
import org.genemania.plugin.view.components.NetworkGroupComboBox;
import org.genemania.plugin.view.util.FileSelectionMode;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.type.DataLayout;

public class ImportNetworkPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<Organism> organisms;
    private NetworkGroupComboBox groupCombo;
    private JComboBox organismCombo;
    private JTextField nameField;
    private JTextArea descriptionField;
    private JTextField fileField;
    private JButton chooseButton;
    private OrganismClassifier detector;
    private File detectedFile;
    private ButtonGroup typeGroup;
    private JRadioButton interactionRadioButton;
    private JRadioButton profileRadioButton;
    private JTextField groupNameField;
    private final List<ValidationEventListener> validationListeners;
    private final DataImportSettings importSettings;
    private final DataSetManager dataSetManager;
    private final UiUtils uiUtils;
    private final FileUtils fileUtils;
    private final TaskDispatcher taskDispatcher;

    public ImportNetworkPanel(DataSetManager dataSetManager, UiUtils uiUtils, FileUtils fileUtils, TaskDispatcher taskDispatcher) {
        this.dataSetManager = dataSetManager;
        this.uiUtils = uiUtils;
        this.fileUtils = fileUtils;
        this.taskDispatcher = taskDispatcher;
        this.importSettings = new DataImportSettings();
        this.validationListeners = new ArrayList<ValidationEventListener>();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportNetworkPanel.this.validateSettings();
            }
        };
        this.organismCombo = new JComboBox();
        this.organismCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportNetworkPanel.this.updateGroups();
                ImportNetworkPanel.this.validateSettings();
            }
        });
        this.groupCombo = new NetworkGroupComboBox();
        this.groupCombo.addActionListener(actionListener);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImportNetworkPanel.this.validateSettings();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImportNetworkPanel.this.validateSettings();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImportNetworkPanel.this.validateSettings();
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ImportNetworkPanel.this.validateSettings();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        this.nameField = new JTextField(30);
        this.nameField.getDocument().addDocumentListener(documentListener);
        this.descriptionField = new JTextArea();
        this.descriptionField.getDocument().addDocumentListener(documentListener);
        this.fileField = new JTextField(30);
        this.fileField.getDocument().addDocumentListener(documentListener);
        this.fileField.addFocusListener(focusListener);
        this.chooseButton = new JButton(Strings.importNetworkBrowseButton_label);
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportNetworkPanel.this.handleChoose();
            }
        });
        JPanel typePanel = uiUtils.createJPanel();
        typePanel.setLayout(new GridBagLayout());
        this.interactionRadioButton = uiUtils.createRadioButton(Strings.importNetworkNetworkRadioButton_label);
        this.interactionRadioButton.addActionListener(actionListener);
        this.profileRadioButton = uiUtils.createRadioButton(Strings.importNetworkProfileRadioButton_label);
        this.profileRadioButton.addActionListener(actionListener);
        this.typeGroup = new ButtonGroup();
        this.typeGroup.add(this.interactionRadioButton);
        this.typeGroup.add(this.profileRadioButton);
        typePanel.add((Component)this.interactionRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        typePanel.add((Component)this.profileRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel groupPanel = uiUtils.createJPanel();
        groupPanel.setLayout(new GridBagLayout());
        this.groupNameField = new JTextField(30);
        this.groupNameField.getDocument().addDocumentListener(documentListener);
        this.groupNameField.addFocusListener(focusListener);
        groupPanel.add((Component)this.groupCombo, new GridBagConstraints(0, 0, 1, 1, Double.MIN_VALUE, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        groupPanel.add((Component)this.groupNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Strings.importNetworkFilePath_label), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Strings.importNetworkFileType_label), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Strings.importNetworkOrganism_label), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Strings.importNetworkGroup_label), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Strings.importNetworkName_label), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Strings.importNetworkDescription_label), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fileField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.chooseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)typePanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.organismCombo, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)groupPanel, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.nameField, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.descriptionField), new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateGroups();
    }

    public void setOrganisms(List<Organism> organisms) {
        this.organisms = organisms;
        Vector<String> items = new Vector<String>();
        for (Organism organism : organisms) {
            items.add(String.format(Strings.importNetworkOrganism_description, organism.getName(), organism.getDescription()));
        }
        DefaultComboBoxModel organismModel = new DefaultComboBoxModel(items);
        this.organismCombo.setModel(organismModel);
        this.updateGroups();
    }

    protected void detectOrganism(final File file, final int maximumLinesToSample) {
        GeneManiaTask task = new GeneManiaTask(Strings.importNetworkDetecting_title){

            @Override
            protected void runTask() throws Throwable {
                this.progress.setStatus(Strings.importNetworkDetecting_status);
                try {
                    if (ImportNetworkPanel.this.detectedFile != null && ImportNetworkPanel.this.detectedFile.getCanonicalFile().equals(file.getCanonicalFile())) {
                        return;
                    }
                }
                catch (IOException e) {
                    LogUtils.log(this.getClass(), e);
                }
                if (!file.exists()) {
                    ImportNetworkPanel.this.detectedFile = null;
                    ImportNetworkPanel.this.detector = null;
                    return;
                }
                DataSet data = ImportNetworkPanel.this.dataSetManager.getDataSet();
                DataFileClassifier classifier = new DataFileClassifier();
                try {
                    classifier.classify(ImportNetworkPanel.this.importSettings, ImportNetworkPanel.this.fileUtils.getUncompressedStream(file), maximumLinesToSample);
                    if (ImportNetworkPanel.this.importSettings.getDataLayout().equals((Object)DataLayout.GEO_PROFILE)) {
                        ImportNetworkPanel.this.typeGroup.setSelected(ImportNetworkPanel.this.profileRadioButton.getModel(), true);
                    } else if (ImportNetworkPanel.this.importSettings.getDataLayout().equals((Object)DataLayout.WEIGHTED_NETWORK)) {
                        ImportNetworkPanel.this.typeGroup.setSelected(ImportNetworkPanel.this.interactionRadioButton.getModel(), true);
                    } else if (ImportNetworkPanel.this.importSettings.getDataLayout().equals((Object)DataLayout.BINARY_NETWORK)) {
                        ImportNetworkPanel.this.typeGroup.setSelected(ImportNetworkPanel.this.interactionRadioButton.getModel(), true);
                    } else {
                        JOptionPane.showMessageDialog(ImportNetworkPanel.this.taskDispatcher.getTaskDialog(), Strings.importNetworkPanelUnrecognizedFile_error, Strings.importNetworkFile_title, 2);
                        ImportNetworkPanel.this.fileField.setText("");
                        ImportNetworkPanel.this.typeGroup.setSelected(ImportNetworkPanel.this.profileRadioButton.getModel(), false);
                        ImportNetworkPanel.this.typeGroup.setSelected(ImportNetworkPanel.this.interactionRadioButton.getModel(), false);
                        return;
                    }
                    ImportNetworkPanel.this.detector = new OrganismClassifier(data.getGeneClassifier());
                    ImportNetworkPanel.this.detector.classify(ImportNetworkPanel.this.importSettings, ImportNetworkPanel.this.fileUtils.getUncompressedReader(file), maximumLinesToSample);
                    if (ImportNetworkPanel.this.importSettings.getOrganism() == null) {
                        return;
                    }
                    List mostLikelyOrganismIds = ImportNetworkPanel.this.detector.getMostLikelyOrganismIds();
                    Long id = mostLikelyOrganismIds.size() > 1 ? ImportNetworkPanel.this.disambiguateOrganism(mostLikelyOrganismIds) : Long.valueOf(ImportNetworkPanel.this.importSettings.getOrganism().getId());
                    ImportNetworkPanel.this.detectedFile = file;
                    if (id == null) {
                        return;
                    }
                    for (int i = 0; i < ImportNetworkPanel.this.organisms.size(); ++i) {
                        Organism organism = (Organism)ImportNetworkPanel.this.organisms.get(i);
                        if (organism.getId() != id.longValue()) continue;
                        ImportNetworkPanel.this.organismCombo.setSelectedIndex(i);
                        ImportNetworkPanel.this.importSettings.setOrganism(organism);
                        return;
                    }
                }
                catch (IOException e) {
                    LogUtils.log(this.getClass(), e);
                }
            }
        };
        this.taskDispatcher.executeTask(task, this.uiUtils.getFrame(this), true, false);
    }

    private Long disambiguateOrganism(List<OrganismClassifier.Match> mostLikelyOrganismIds) {
        Object[] choices = new OrganismChoice[mostLikelyOrganismIds.size()];
        int index = 0;
        for (OrganismClassifier.Match match : mostLikelyOrganismIds) {
            Organism organism = this.findOrganism(match.organismId);
            choices[index] = new OrganismChoice(organism, match.score);
            ++index;
        }
        OrganismChoice choice = (OrganismChoice)JOptionPane.showInputDialog(this.uiUtils.getFrame(this), Strings.importNetworkDisambiguateMessage, Strings.importNetworkDisambiguateTitle, 3, null, choices, choices[0]);
        if (choice == null) {
            return null;
        }
        return choice.organism.getId();
    }

    private Organism findOrganism(long organismId) {
        for (Organism organism : this.organisms) {
            if (organism.getId() != organismId) continue;
            return organism;
        }
        return null;
    }

    protected void updateGroups() {
        int index = this.organismCombo.getSelectedIndex();
        if (index == -1) {
            this.groupCombo.updateNetworkGroups(null);
            return;
        }
        Organism organism = this.organisms.get(index);
        this.groupCombo.updateNetworkGroups(organism.getInteractionNetworkGroups());
    }

    Organism getOrganism() {
        int index = this.organismCombo.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.organisms.get(index);
    }

    InteractionNetwork getNetwork() {
        InteractionNetwork network = new InteractionNetwork();
        network.setDefaultSelected(false);
        network.setDescription(this.descriptionField.getText());
        network.setName(this.nameField.getText());
        return network;
    }

    public File getNetworkFile() {
        return new File(this.fileField.getText());
    }

    public DataFileType getType() {
        ButtonModel selection = this.typeGroup.getSelection();
        if (selection == null) {
            return DataFileType.UNKNOWN;
        }
        if (selection.equals(this.interactionRadioButton.getModel())) {
            return DataFileType.INTERACTION_NETWORK;
        }
        if (selection.equals(this.profileRadioButton.getModel())) {
            return DataFileType.EXPRESSION_PROFILE;
        }
        return DataFileType.UNKNOWN;
    }

    public void validateSettings() {
        int groupIndex = this.groupCombo.getSelectedIndex();
        this.groupNameField.setVisible(groupIndex == 0);
        this.validate();
        ButtonModel selection = this.typeGroup.getSelection();
        boolean valid = selection != null;
        valid &= this.nameField.getText().trim().length() > 0;
        valid &= new File(this.fileField.getText()).isFile();
        valid &= this.organismCombo.getSelectedIndex() != -1;
        valid &= groupIndex != -1;
        String groupName = this.groupNameField.getText().trim();
        valid &= groupIndex != 0 || groupName.length() > 0 && !this.groupCombo.containsGroup(groupName);
        for (ValidationEventListener listener : this.validationListeners) {
            listener.validate(valid);
        }
    }

    public void clear() {
        this.nameField.setText("");
        this.descriptionField.setText("");
        this.fileField.setText("");
        this.groupNameField.setText("");
        this.detectedFile = null;
        this.detector = null;
    }

    public void addValidationEventListener(ValidationEventListener listener) {
        this.validationListeners.add(listener);
    }

    public DataImportSettings getImportSettings() {
        this.importSettings.setOrganism(this.getOrganism());
        this.importSettings.setNetwork(this.getNetwork());
        InteractionNetworkGroup group = this.groupCombo.getGroup();
        if (group.getId() == -1L) {
            String name = this.groupNameField.getText().trim();
            group.setName(name);
            group.setCode(name);
            group.setDescription("");
        }
        this.importSettings.setNetworkGroup(group);
        return this.importSettings;
    }

    private void handleChoose() {
        File file;
        int maximumLinesToSample = 250;
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("csv");
        extensions.add("txt");
        File initialFile = this.fileUtils.getUserHome();
        try {
            file = this.uiUtils.getFile(this.uiUtils.getFrame(this), Strings.importNetworkFile_title, initialFile, Strings.importNetworkPanelTypeDescription_label, extensions, FileSelectionMode.OPEN_FILE);
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), e);
            return;
        }
        if (file == null) {
            return;
        }
        this.fileField.setText(file.getAbsolutePath());
        if (file.exists()) {
            this.detectOrganism(file, maximumLinesToSample);
        }
        this.validateSettings();
    }

    public static class OrganismChoice {
        public Organism organism;
        public double score;

        public OrganismChoice(Organism organism, double score) {
            this.organism = organism;
            this.score = score;
        }

        public String toString() {
            return String.format("%s - %d%%", this.organism.getName(), (int)(this.score * 100.0));
        }
    }
}

