/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.genemania.data.normalizer.DataFileType;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.OrganismClassifier;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.OrganismMediator;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicTableModel;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetChangeListener;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.Namespace;
import org.genemania.plugin.data.lucene.view.CyNetworkImporter;
import org.genemania.plugin.formatters.IObjectFormatter;
import org.genemania.plugin.formatters.OrganismFormatter;
import org.genemania.plugin.model.ModelElement;
import org.genemania.plugin.model.OrganismComparator;
import org.genemania.plugin.proxies.NetworkProxy;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.components.NetworkGroupComboBox;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.type.DataLayout;
import org.genemania.type.ImportedDataFormat;
import org.genemania.type.NetworkProcessingMethod;
import org.genemania.util.ProgressReporter;

public class ImportCyNetworkPanel<NETWORK, NODE, EDGE>
extends JPanel {
    private static final int CHECK_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private final DataSetManager dataSetManager;
    private final UiUtils uiUtils;
    private final TaskDispatcher taskDispatcher;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private JLabel weightLabel;
    private JComboBox weightCombo;
    private JLabel expressionLabel;
    private JTable expressionTable;
    private JScrollPane expressionPane;
    private ExpressionTableModel expressionModel;
    private NetworkGroupComboBox groupCombo;
    private JTextField nameTextField;
    private JTextArea descriptionTextArea;
    private JComboBox organismCombo;
    private JComboBox idCombo;
    private JComboBox networkCombo;
    private JComboBox typeCombo;
    private JLabel helpLabel;
    private JPanel sourcePanel;
    private JPanel destinationPanel;
    private JButton importButton;
    private JTextField groupNameField;

    public ImportCyNetworkPanel(DataSetManager dataSetManager, UiUtils uiUtils, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, TaskDispatcher taskDispatcher) {
        this.dataSetManager = dataSetManager;
        this.uiUtils = uiUtils;
        this.cytoscapeUtils = cytoscapeUtils;
        this.taskDispatcher = taskDispatcher;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        int row = 0;
        this.sourcePanel = this.createSourcePanel();
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder(Strings.importCyNetworkSource_title));
        this.destinationPanel = this.createDestinationPanel();
        this.destinationPanel.setBorder(BorderFactory.createTitledBorder(Strings.importCyNetworkDestination_title));
        this.helpLabel = new JLabel();
        this.add((Component)this.helpLabel, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.sourcePanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 19, 1, insets, 0, 0));
        this.add((Component)this.destinationPanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 19, 1, insets, 0, 0));
        this.importButton = new JButton(Strings.importCyNetworkImport_label);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCyNetworkPanel.this.handleImport();
            }
        });
        this.add((Component)this.importButton, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.add((Component)uiUtils.createJPanel(), new GridBagConstraints(0, ++row, 2, 1, 0.0, Double.MIN_VALUE, 21, 0, insets, 0, 0));
        ++row;
        dataSetManager.addDataSetChangeListener(new DataSetChangeListener(){

            @Override
            public void dataSetChanged(DataSet activeDataSet, ProgressReporter progress) {
                ImportCyNetworkPanel.this.handleDataSetChange(activeDataSet);
            }
        });
        this.handleDataSetChange(dataSetManager.getDataSet());
        this.validateSettings();
    }

    private JPanel createDestinationPanel() {
        JPanel panel = this.uiUtils.createJPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        int row = 0;
        this.organismCombo = new JComboBox();
        panel.add((Component)new JLabel(Strings.importCyNetworkOrganism_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add((Component)this.organismCombo, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        ++row;
        this.organismCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCyNetworkPanel.this.handleOrganismChange();
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ImportCyNetworkPanel.this.validateSettings();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ImportCyNetworkPanel.this.validateSettings();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                ImportCyNetworkPanel.this.validateSettings();
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ImportCyNetworkPanel.this.validateSettings();
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        };
        JPanel groupPanel = this.uiUtils.createJPanel();
        groupPanel.setLayout(new GridBagLayout());
        this.groupCombo = new NetworkGroupComboBox();
        this.groupCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCyNetworkPanel.this.validateSettings();
            }
        });
        this.groupNameField = new JTextField(30);
        this.groupNameField.getDocument().addDocumentListener(documentListener);
        this.groupNameField.addFocusListener(focusListener);
        groupPanel.add((Component)this.groupCombo, new GridBagConstraints(0, 0, 1, 1, Double.MIN_VALUE, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        groupPanel.add((Component)this.groupNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(Strings.importCyNetworkNetworkGroup_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add((Component)groupPanel, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.nameTextField = new JTextField(30);
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        this.nameTextField.addFocusListener(focusListener);
        panel.add((Component)new JLabel(Strings.importCyNetworkNetworkName_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)this.nameTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        ++row;
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setRows(4);
        this.descriptionTextArea.getDocument().addDocumentListener(documentListener);
        this.descriptionTextArea.addFocusListener(focusListener);
        JScrollPane descriptionPane = new JScrollPane(this.descriptionTextArea);
        panel.add((Component)new JLabel(Strings.importCyNetworkNetworkDescription_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)descriptionPane, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        panel.add((Component)this.uiUtils.createJPanel(), new GridBagConstraints(0, ++row, 2, 1, 0.0, Double.MIN_VALUE, 10, 1, insets, 0, 0));
        ++row;
        return panel;
    }

    void validateSettings() {
        int groupIndex = this.groupCombo.getSelectedIndex();
        this.groupNameField.setVisible(groupIndex == 0);
        this.validate();
        boolean valid = this.nameTextField.getText().trim().length() > 0;
        valid &= this.organismCombo.getSelectedIndex() != -1;
        valid &= groupIndex != -1;
        String groupName = this.groupNameField.getText().trim();
        this.importButton.setEnabled(valid &= groupIndex != 0 || groupName.length() > 0 && !this.groupCombo.containsGroup(groupName));
    }

    private JPanel createSourcePanel() {
        JPanel panel = this.uiUtils.createJPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        int row = 0;
        this.networkCombo = new JComboBox();
        panel.add((Component)new JLabel(Strings.importCyNetworkSourceNetwork_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add((Component)this.networkCombo, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        this.idCombo = new JComboBox();
        panel.add((Component)new JLabel(Strings.importCyNetworkNodeIdentifier_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        panel.add((Component)this.idCombo, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        ++row;
        this.networkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCyNetworkPanel.this.handleNetworkChange();
                ImportCyNetworkPanel.this.handleSourceChange();
            }
        });
        this.idCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCyNetworkPanel.this.handleSourceChange();
            }
        });
        Comparator<NetworkType> comparator = new Comparator<NetworkType>(){

            @Override
            public int compare(NetworkType o1, NetworkType o2) {
                return o1.compareTo(o2);
            }
        };
        IObjectFormatter<NetworkType> formatter = new IObjectFormatter<NetworkType>(){

            @Override
            public String format(NetworkType type) {
                switch (type) {
                    case COEXPRESSION: {
                        return Strings.importCyNetworkTypeCoexpression_label;
                    }
                    case UNWEIGHTED: {
                        return Strings.importCyNetworkTypeUnweighted_label;
                    }
                    case WEIGHTED: {
                        return Strings.importCyNetworkTypeWeighted_label;
                    }
                }
                return Strings.importCyNetworkTypeUnknown_label;
            }
        };
        NetworkType[] allTypes = NetworkType.values();
        ModelElement[] typeModel = new ModelElement[allTypes.length];
        for (int i = 0; i < typeModel.length; ++i) {
            typeModel[i] = new ModelElement<NetworkType>(allTypes[i], comparator, formatter);
        }
        this.typeCombo = new JComboBox<ModelElement>(typeModel);
        this.typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCyNetworkPanel.this.handleTypeChange(ImportCyNetworkPanel.this.typeCombo);
            }
        });
        panel.add((Component)new JLabel(Strings.importCyNetworkType_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)this.typeCombo, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 23, 0, insets, 0, 0));
        this.weightLabel = new JLabel(Strings.importCyNetworkWeight_label);
        this.weightCombo = new JComboBox();
        panel.add((Component)this.weightLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)this.weightCombo, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 23, 0, insets, 0, 0));
        this.expressionLabel = new JLabel(Strings.importCyNetworkExpressionValues_label);
        this.expressionModel = new ExpressionTableModel();
        this.expressionTable = new JTable(this.expressionModel){

            @Override
            public void addNotify() {
                super.addNotify();
                ImportCyNetworkPanel.this.uiUtils.packColumns(this);
            }
        };
        this.expressionPane = new JScrollPane(this.expressionTable);
        panel.add((Component)this.expressionLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        panel.add((Component)this.expressionPane, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        panel.add((Component)this.uiUtils.createJPanel(), new GridBagConstraints(0, ++row, 2, 1, 0.0, Double.MIN_VALUE, 10, 1, insets, 0, 0));
        ++row;
        this.handleTypeChange(this.typeCombo);
        return panel;
    }

    private void handleOrganismChange() {
        ModelElement element = (ModelElement)this.organismCombo.getSelectedItem();
        if (element == null) {
            this.groupCombo.updateNetworkGroups(null);
            return;
        }
        Organism organism = (Organism)element.getItem();
        Collection groups = organism.getInteractionNetworkGroups();
        this.groupCombo.updateNetworkGroups(groups);
    }

    private void handleSourceChange() {
        String idAttribute = (String)this.idCombo.getSelectedItem();
        if (idAttribute == null) {
            return;
        }
        NetworkProxy networkProxy = (NetworkProxy)((ModelElement)this.networkCombo.getSelectedItem()).getItem();
        Object network = networkProxy.getProxied();
        DataSet data = this.dataSetManager.getDataSet();
        OrganismClassifier classifier = new OrganismClassifier(data.getGeneClassifier());
        for (Object node : networkProxy.getNodes()) {
            NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(node, network);
            Class<?> type = nodeProxy.getAttributeType(idAttribute);
            if (type.equals(String.class)) {
                String symbol = nodeProxy.getAttribute(idAttribute, String.class);
                try {
                    classifier.addGene(symbol, 0);
                }
                catch (ApplicationException e) {
                    this.log(e);
                }
                continue;
            }
            if (!type.equals(List.class)) continue;
            List list = nodeProxy.getAttribute(idAttribute, List.class);
            for (Object item : list) {
                if (!(item instanceof String)) continue;
                try {
                    classifier.addGene((String)item, 0);
                }
                catch (ApplicationException e) {
                    this.log(e);
                }
            }
        }
        List organismIds = classifier.getMostLikelyOrganismIds();
        if (organismIds.size() > 0) {
            OrganismClassifier.Match match = (OrganismClassifier.Match)organismIds.get(0);
            ComboBoxModel model = this.organismCombo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ModelElement element = (ModelElement)model.getElementAt(i);
                if (((Organism)element.getItem()).getId() != match.organismId) continue;
                this.organismCombo.setSelectedItem(element);
                return;
            }
        }
    }

    private void log(Throwable t) {
        Logger logger = Logger.getLogger(this.getClass());
        logger.error((Object)t.getMessage(), t);
    }

    private void handleDataSetChange(DataSet data) {
        this.populateNetworks();
        this.populateOrganisms(data);
    }

    private void populateNetworks() {
        ArrayList<ModelElement<NetworkProxy<NETWORK, NODE, EDGE>>> networkIds = new ArrayList<ModelElement<NetworkProxy<NETWORK, NODE, EDGE>>>();
        Comparator comparator = new Comparator<NetworkProxy<NETWORK, NODE, EDGE>>(){

            @Override
            public int compare(NetworkProxy<NETWORK, NODE, EDGE> o1, NetworkProxy<NETWORK, NODE, EDGE> o2) {
                return o1.getTitle().compareToIgnoreCase(o2.getTitle());
            }
        };
        IObjectFormatter formatter = new IObjectFormatter<NetworkProxy<NETWORK, NODE, EDGE>>(){

            @Override
            public String format(NetworkProxy<NETWORK, NODE, EDGE> object) {
                return object.getTitle();
            }
        };
        for (NETWORK network : this.cytoscapeUtils.getNetworks()) {
            NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.cytoscapeUtils.getNetworkProxy(network);
            networkIds.add(new ModelElement<NetworkProxy<NETWORK, NODE, EDGE>>(networkProxy, comparator, formatter));
        }
        Object[] model = new ModelElement[networkIds.size()];
        model = networkIds.toArray(model);
        Arrays.sort(model);
        this.networkCombo.setModel(new DefaultComboBoxModel<Object>(model));
        boolean hasNetworks = model.length > 0;
        this.sourcePanel.setVisible(hasNetworks);
        this.destinationPanel.setVisible(hasNetworks);
        this.importButton.setVisible(hasNetworks);
        if (hasNetworks) {
            this.helpLabel.setText(Strings.importCyNetworkHelp_label);
            this.handleNetworkChange();
        } else {
            this.helpLabel.setText(Strings.importCyNetworkHelpEmpty_label);
        }
    }

    private void handleNetworkChange() {
        NetworkProxy networkProxy = (NetworkProxy)((ModelElement)this.networkCombo.getSelectedItem()).getItem();
        this.populateAttributes(networkProxy);
    }

    private void populateOrganisms(DataSet data) {
        try {
            OrganismMediator organismMediator = data.getMediatorProvider().getOrganismMediator();
            List allOrganisms = organismMediator.getAllOrganisms();
            Object[] elements = new ModelElement[allOrganisms.size()];
            int i = 0;
            for (Organism organism : allOrganisms) {
                elements[i] = new ModelElement<Organism>(organism, OrganismComparator.getInstance(), OrganismFormatter.getInstance());
                ++i;
            }
            Arrays.sort(elements);
            this.organismCombo.setModel(new DefaultComboBoxModel<Object>(elements));
            this.handleOrganismChange();
        }
        catch (DataStoreException e) {
            this.log(e);
        }
    }

    private void populateAttributes(NetworkProxy<NETWORK, NODE, EDGE> networkProxy) {
        String[] nodeAttributes = this.sort(networkProxy.getNodeAttributeNames());
        String[] edgeAttributes = this.sort(networkProxy.getEdgeAttributeNames());
        this.idCombo.setModel(new DefaultComboBoxModel<String>(nodeAttributes));
        this.weightCombo.setModel(new DefaultComboBoxModel<String>(edgeAttributes));
        this.expressionModel.clear();
        for (String name : nodeAttributes) {
            this.expressionModel.add(new ExpressionTableElement(name));
        }
    }

    private String[] sort(Collection<String> names) {
        ArrayList<String> list = new ArrayList<String>(names);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        return list.toArray(new String[list.size()]);
    }

    private void handleTypeChange(JComboBox combo) {
        ModelElement element = (ModelElement)combo.getSelectedItem();
        boolean showWeight = element.getItem() == NetworkType.WEIGHTED;
        boolean showNone = element.getItem() == NetworkType.UNWEIGHTED;
        this.weightLabel.setVisible(showWeight && !showNone);
        this.weightCombo.setVisible(showWeight && !showNone);
        this.expressionLabel.setVisible(!showWeight && !showNone);
        this.expressionPane.setVisible(!showWeight && !showNone);
    }

    private void handleImport() {
        ModelElement element = (ModelElement)this.organismCombo.getSelectedItem();
        final Organism organism = (Organism)element.getItem();
        NetworkProxy networkProxy = (NetworkProxy)((ModelElement)this.networkCombo.getSelectedItem()).getItem();
        final Object cyNetwork = networkProxy.getProxied();
        final String idAttribute = (String)this.idCombo.getSelectedItem();
        final ModelElement typeElement = (ModelElement)this.typeCombo.getSelectedItem();
        GeneManiaTask task = new GeneManiaTask(Strings.importCyNetworkTask_title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected void runTask() throws Throwable {
                outputFile = File.createTempFile("temp", "cynetwork.txt");
                try {
                    settings = new DataImportSettings();
                    data = ImportCyNetworkPanel.access$800(ImportCyNetworkPanel.this).getDataSet();
                    networkId = data.getNextAvailableId(InteractionNetwork.class, Namespace.USER);
                    network = new InteractionNetwork();
                    network.setId(networkId);
                    network.setName(ImportCyNetworkPanel.access$900(ImportCyNetworkPanel.this).getText());
                    network.setDescription(ImportCyNetworkPanel.access$1000(ImportCyNetworkPanel.this).getText());
                    group = ImportCyNetworkPanel.access$1100(ImportCyNetworkPanel.this).getGroup();
                    settings.setNetwork(network);
                    settings.setNetworkGroup(group);
                    settings.setOrganism(organism);
                    writer = new FileWriter(outputFile);
                    fileType = null;
                    try {
                        switch (17.$SwitchMap$org$genemania$plugin$data$lucene$view$ImportCyNetworkPanel$NetworkType[((NetworkType)typeElement.getItem()).ordinal()]) {
                            case 2: {
                                fileType = DataFileType.INTERACTION_NETWORK;
                                ImportCyNetworkPanel.access$1200(ImportCyNetworkPanel.this, settings, cyNetwork, idAttribute, writer, this.progress);
                                ** break;
lbl22:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                fileType = DataFileType.INTERACTION_NETWORK;
                                weightAttribute = (String)ImportCyNetworkPanel.access$1300(ImportCyNetworkPanel.this).getSelectedItem();
                                ImportCyNetworkPanel.this.handleWeightedNetwork(settings, cyNetwork, idAttribute, weightAttribute, writer, this.progress);
                                ** break;
lbl28:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                fileType = DataFileType.EXPRESSION_PROFILE;
                                expressionAttributes = ImportCyNetworkPanel.this.getExpressionAttributes();
                                ImportCyNetworkPanel.this.handleCoexpressionNetwork(settings, cyNetwork, idAttribute, expressionAttributes, writer, this.progress);
                                break;
                            }
                            ** default:
lbl35:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        writer.close();
                    }
                    manager = data.createModelManager(Namespace.USER);
                    try {
                        manager.installNetwork(settings, outputFile.getPath(), fileType, this.progress);
                    }
                    finally {
                        manager.close();
                    }
                    ImportCyNetworkPanel.access$800(ImportCyNetworkPanel.this).reloadDataSet(this.progress);
                    ImportCyNetworkPanel.access$1400(ImportCyNetworkPanel.this);
                }
                finally {
                    outputFile.delete();
                }
            }
        };
        this.taskDispatcher.executeTask(task, this.uiUtils.getFrame(this), true, true);
    }

    protected void handleCoexpressionNetwork(DataImportSettings settings, NETWORK cyNetwork, String idAttribute, List<String> expressionAttributes, Writer writer, ProgressReporter progress) {
        ArrayList<Integer> idColumns = new ArrayList<Integer>();
        idColumns.add(0);
        settings.setDataFormat(ImportedDataFormat.PROFILE_DATA_TAB_DELIMITED);
        settings.setDataLayout(DataLayout.PROFILE);
        settings.setDelimiter("\t");
        settings.setIdColumns(idColumns);
        settings.setProcessingMethod(NetworkProcessingMethod.PEARSON);
        CyNetworkImporter<NETWORK, NODE, EDGE> importer = new CyNetworkImporter<NETWORK, NODE, EDGE>(this.cytoscapeUtils);
        importer.process(cyNetwork, idAttribute, expressionAttributes, writer, progress);
    }

    protected void handleWeightedNetwork(DataImportSettings settings, NETWORK cyNetwork, String idAttribute, String weightAttribute, Writer writer, ProgressReporter progress) {
        ArrayList<Integer> idColumns = new ArrayList<Integer>();
        idColumns.add(0);
        idColumns.add(1);
        settings.setDataFormat(ImportedDataFormat.NETWORK_DATA_TAB_DELIMITED);
        settings.setDataLayout(DataLayout.WEIGHTED_NETWORK);
        settings.setDelimiter("\t");
        settings.setIdColumns(idColumns);
        settings.setProcessingMethod(NetworkProcessingMethod.DIRECT);
        CyNetworkImporter<NETWORK, NODE, EDGE> importer = new CyNetworkImporter<NETWORK, NODE, EDGE>(this.cytoscapeUtils);
        importer.process(cyNetwork, idAttribute, weightAttribute, writer, progress);
    }

    private void handleUnweightedNetwork(DataImportSettings settings, NETWORK cyNetwork, String idAttribute, Writer writer, ProgressReporter progress) {
        ArrayList<Integer> idColumns = new ArrayList<Integer>();
        idColumns.add(0);
        idColumns.add(1);
        settings.setDataFormat(ImportedDataFormat.NETWORK_DATA_TAB_DELIMITED);
        settings.setDataLayout(DataLayout.BINARY_NETWORK);
        settings.setDelimiter("\t");
        settings.setIdColumns(idColumns);
        settings.setProcessingMethod(NetworkProcessingMethod.DIRECT);
        CyNetworkImporter<NETWORK, NODE, EDGE> importer = new CyNetworkImporter<NETWORK, NODE, EDGE>(this.cytoscapeUtils);
        importer.process(cyNetwork, idAttribute, (String)null, writer, progress);
    }

    private void resetForm() {
        this.nameTextField.setText("");
        this.descriptionTextArea.setText("");
    }

    List<String> getExpressionAttributes() {
        ArrayList<String> names = new ArrayList<String>();
        for (int row = 0; row < this.expressionTable.getRowCount(); ++row) {
            if (!((Boolean)this.expressionTable.getValueAt(row, 0)).booleanValue()) continue;
            names.add((String)this.expressionTable.getValueAt(row, 1));
        }
        return names;
    }

    static /* synthetic */ DataSetManager access$800(ImportCyNetworkPanel x0) {
        return x0.dataSetManager;
    }

    static /* synthetic */ JTextField access$900(ImportCyNetworkPanel x0) {
        return x0.nameTextField;
    }

    static /* synthetic */ JTextArea access$1000(ImportCyNetworkPanel x0) {
        return x0.descriptionTextArea;
    }

    static /* synthetic */ NetworkGroupComboBox access$1100(ImportCyNetworkPanel x0) {
        return x0.groupCombo;
    }

    static /* synthetic */ void access$1200(ImportCyNetworkPanel x0, DataImportSettings x1, Object x2, String x3, Writer x4, ProgressReporter x5) {
        x0.handleUnweightedNetwork(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ JComboBox access$1300(ImportCyNetworkPanel x0) {
        return x0.weightCombo;
    }

    static /* synthetic */ void access$1400(ImportCyNetworkPanel x0) {
        x0.resetForm();
    }

    static class ExpressionTableElement {
        boolean selected;
        String name;

        public ExpressionTableElement(String name) {
            this.name = name;
        }
    }

    static class ExpressionTableModel
    extends DynamicTableModel<ExpressionTableElement> {
        ExpressionTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return Strings.importCyNetworkExpressionNameColumn_label;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ExpressionTableElement element = (ExpressionTableElement)this.get(rowIndex);
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return element.selected;
                }
                case 1: {
                    return element.name;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ExpressionTableElement element = (ExpressionTableElement)this.get(rowIndex);
            if (element == null) {
                return;
            }
            if (columnIndex != 0) {
                return;
            }
            if (aValue instanceof Boolean) {
                element.selected = (Boolean)aValue;
            }
        }
    }

    static enum NetworkType {
        UNWEIGHTED,
        WEIGHTED,
        COEXPRESSION;

    }
}

