/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.genemania.data.normalizer.NormalizationResult;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.proxies.EdgeProxy;
import org.genemania.plugin.proxies.NetworkProxy;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.util.ProgressReporter;

public class CyNetworkImporter<NETWORK, NODE, EDGE> {
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;

    public CyNetworkImporter(CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        this.cytoscapeUtils = cytoscapeUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(NETWORK network, String idAttribute, String weightAttribute, Writer output, ProgressReporter progress) {
        PrintWriter writer = new PrintWriter(output);
        try {
            Context context = new Context();
            NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.cytoscapeUtils.getNetworkProxy(network);
            Collection<EDGE> edges = networkProxy.getEdges();
            progress.setMaximumProgress(edges.size());
            for (EDGE edge : edges) {
                if (progress.isCanceled()) {
                    return;
                }
                progress.setProgress(context.totalInteractions);
                ++context.totalInteractions;
                EdgeProxy<EDGE, NODE> edgeProxy = this.cytoscapeUtils.getEdgeProxy(edge, network);
                String sourceSymbol = this.getSymbol(this.cytoscapeUtils.getNodeProxy(edgeProxy.getSource(), network), idAttribute);
                String targetSymbol = this.getSymbol(this.cytoscapeUtils.getNodeProxy(edgeProxy.getTarget(), network), idAttribute);
                if (sourceSymbol == null || targetSymbol == null) {
                    ++context.droppedInteractions;
                    continue;
                }
                Double weight = null;
                if (weightAttribute != null) {
                    Object rawValue = edgeProxy.getAttribute(weightAttribute, Object.class);
                    if (!(rawValue instanceof Double) && !(rawValue instanceof Integer)) {
                        ++context.droppedInteractions;
                        continue;
                    }
                    weight = rawValue instanceof Double ? (Double)rawValue : Double.valueOf(((Integer)rawValue).doubleValue());
                }
                if (weightAttribute != null) {
                    writer.printf("%s\t%s\t%f\n", sourceSymbol, targetSymbol, weight);
                    continue;
                }
                writer.printf("%s\t%s\n", sourceSymbol, targetSymbol);
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(NETWORK network, String idAttribute, List<String> expressionAttributes, Writer output, ProgressReporter progress) {
        PrintWriter writer = new PrintWriter(output);
        try {
            writer.print("IDENTIFIER");
            for (String attribute : expressionAttributes) {
                writer.print("\t");
                writer.print(attribute);
            }
            writer.println();
            Context context = new Context();
            NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.cytoscapeUtils.getNetworkProxy(network);
            Collection<NODE> nodes = networkProxy.getNodes();
            progress.setMaximumProgress(nodes.size());
            for (NODE node : nodes) {
                if (progress.isCanceled()) {
                    return;
                }
                progress.setProgress(context.totalInteractions);
                ++context.totalInteractions;
                NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(node, network);
                String symbol = this.getSymbol(nodeProxy, idAttribute);
                if (symbol == null) {
                    ++context.droppedInteractions;
                    continue;
                }
                writer.print(symbol);
                writer.print("\t");
                for (String attribute : expressionAttributes) {
                    Double value = null;
                    Class<?> type = nodeProxy.getAttributeType(attribute);
                    Object rawValue = nodeProxy.getAttribute(attribute, type);
                    if (rawValue instanceof Integer) {
                        value = ((Integer)rawValue).doubleValue();
                    } else if (rawValue instanceof Double) {
                        value = (Double)rawValue;
                    }
                    if (value != null) {
                        writer.print(value);
                    }
                    writer.print("\t");
                }
                writer.println();
            }
        }
        finally {
            writer.close();
        }
    }

    private String getSymbol(NodeProxy<NODE> nodeProxy, String idAttribute) {
        Class<?> type = nodeProxy.getAttributeType(idAttribute);
        Object value = nodeProxy.getAttribute(idAttribute, type);
        if (value instanceof String) {
            return nodeProxy.getAttribute(idAttribute, String.class);
        }
        if (value instanceof List) {
            for (Object item : (List)value) {
                if (!(item instanceof String)) continue;
                return (String)item;
            }
        }
        return null;
    }

    private NormalizationResult createResult(Context context) {
        NormalizationResult result = new NormalizationResult();
        result.setDroppedEntries(context.droppedInteractions);
        result.setTotalEntries(context.totalInteractions);
        result.setInvalidSymbols(context.invalidSymbols);
        return result;
    }

    public NormalizationResult normalize(NETWORK network, String idAttribute, List<String> expressionAttributes, Writer writer, ProgressReporter progress) {
        Context context = new Context();
        return this.createResult(context);
    }

    static class Context {
        public int droppedInteractions;
        public int totalInteractions;
        public Set<String> invalidSymbols = new HashSet<String>();
        public Set<String> conflictingSymbols = new HashSet<String>();
    }
}

