/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.genemania.data.normalizer.DataFileType;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.DataNormalizer;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.data.normalizer.NormalizationResult;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Organism;
import org.genemania.dto.RemoveNetworkEngineRequestDto;
import org.genemania.dto.UploadNetworkEngineRequestDto;
import org.genemania.dto.UploadNetworkEngineResponseDto;
import org.genemania.engine.Mania2;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.ManiaUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.IConfirmationHandler;
import org.genemania.plugin.data.IModelManager;
import org.genemania.plugin.data.IModelWriter;
import org.genemania.plugin.data.Namespace;
import org.genemania.type.NetworkProcessingMethod;
import org.genemania.util.ChildProgressReporter;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;

public class LuceneModelManager
implements IModelManager {
    private final DataSet data;
    private final IConfirmationHandler confirmationHandler;
    private final IModelWriter modelWriter;
    private final Namespace namespace;
    private final FileUtils fileUtils;

    public LuceneModelManager(DataSet data, IConfirmationHandler handler, IModelWriter modelWriter, Namespace namespace, FileUtils fileUtils) {
        this.data = data;
        this.modelWriter = modelWriter;
        this.confirmationHandler = handler;
        this.namespace = namespace;
        this.fileUtils = fileUtils;
    }

    @Override
    public void installNetwork(DataImportSettings settings, String filePath, DataFileType type, ProgressReporter progress) throws ApplicationException, DataStoreException {
        this.installGroup(settings.getOrganism(), settings.getNetworkGroup(), settings.getColor());
        if (type.equals((Object)DataFileType.EXPRESSION_PROFILE)) {
            this.installProfileNetwork(settings, filePath, progress);
        } else if (type.equals((Object)DataFileType.INTERACTION_NETWORK)) {
            this.installTextNetwork(settings, filePath, progress);
        } else {
            throw new ApplicationException(String.format(Strings.unknownFileType_error, type.name()));
        }
    }

    @Override
    public void installGroup(Organism organism, InteractionNetworkGroup group, String color) throws ApplicationException {
        if (group.getId() == -1L) {
            group.setId(this.data.getNextAvailableId(InteractionNetworkGroup.class, Namespace.USER).longValue());
            this.modelWriter.addGroup(group, organism, color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installProfileNetwork(DataImportSettings settings, String filePath, ProgressReporter progress) throws ApplicationException, DataStoreException {
        try {
            progress.setMaximumProgress(3);
            int stage = 0;
            IObjectCache cache = this.data.getObjectCache(NullProgressReporter.instance(), false);
            Mania2 mania = new Mania2(new DataCache((IObjectCache)new MemObjectCache(cache)));
            File networkFile = File.createTempFile("network", "txt");
            try {
                progress.setStatus(Strings.convertProfileToNetwork_status);
                ChildProgressReporter childProgress = new ChildProgressReporter(progress);
                DataNormalizer normalizer = new DataNormalizer();
                GeneCompletionProvider2 genes = this.data.getCompletionProvider(settings.getOrganism());
                Reader reader = this.fileUtils.getUncompressedReader(filePath);
                FileWriter writer = new FileWriter(networkFile);
                NormalizationResult result = normalizer.normalize(settings, genes, reader, (Writer)writer, (ProgressReporter)childProgress);
                childProgress.close();
                ++stage;
                if (progress.isCanceled()) {
                    return;
                }
                if (result.hasErrors() && !this.confirmationHandler.acceptPartialImport(settings, result)) {
                    progress.cancel();
                    return;
                }
                progress.setStatus(Strings.convertProfileToNetwork_status2);
                childProgress = new ChildProgressReporter(progress);
                FileReader normalizedReader = new FileReader(networkFile);
                UploadNetworkEngineRequestDto request = ManiaUtils.createRequest(settings, normalizedReader, (ProgressReporter)childProgress);
                UploadNetworkEngineResponseDto response = mania.uploadNetwork(request);
                childProgress.close();
                ++stage;
                if (progress.isCanceled()) {
                    return;
                }
                progress.setStatus(Strings.installTextNetwork_status3);
                progress.setProgress(stage++);
                this.installNetworkModel(settings, response, result);
            }
            finally {
                networkFile.delete();
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void installTextNetwork(DataImportSettings settings, String networkFile, ProgressReporter progress) throws ApplicationException, DataStoreException {
        int stage = 0;
        progress.setMaximumProgress(3);
        IObjectCache cache = this.data.getObjectCache(NullProgressReporter.instance(), false);
        Mania2 mania = new Mania2(new DataCache((IObjectCache)new MemObjectCache(cache)));
        progress.setStatus(Strings.installTextNetwork_status);
        DataNormalizer normalizer = new DataNormalizer();
        GeneCompletionProvider2 genes = this.data.getCompletionProvider(settings.getOrganism());
        try {
            File normalizedFile = File.createTempFile("temp", "normalized_network.txt");
            try {
                Reader reader = this.fileUtils.getUncompressedReader(networkFile);
                try {
                    FileWriter writer = new FileWriter(normalizedFile);
                    ChildProgressReporter childProgress = new ChildProgressReporter(progress);
                    NormalizationResult result = normalizer.normalize(settings, genes, reader, (Writer)writer, (ProgressReporter)childProgress);
                    childProgress.close();
                    ++stage;
                    if (progress.isCanceled()) {
                        return;
                    }
                    if (result.hasErrors() && !this.confirmationHandler.acceptPartialImport(settings, result)) {
                        progress.cancel();
                        return;
                    }
                    progress.setStatus(Strings.installTextNetwork_status2);
                    childProgress = new ChildProgressReporter(progress);
                    FileReader normalizedReader = new FileReader(normalizedFile);
                    UploadNetworkEngineRequestDto request = ManiaUtils.createRequest(settings, normalizedReader, (ProgressReporter)childProgress);
                    request.setSparsification(50);
                    UploadNetworkEngineResponseDto response = mania.uploadNetwork(request);
                    childProgress.close();
                    ++stage;
                    if (response == null) return;
                    if (progress.isCanceled()) {
                        return;
                    }
                    progress.setStatus(Strings.installTextNetwork_status3);
                    progress.setProgress(stage++);
                    this.installNetworkModel(settings, response, result);
                    return;
                }
                finally {
                    reader.close();
                }
            }
            finally {
                normalizedFile.delete();
            }
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    @Override
    public void installNetworkModel(DataImportSettings settings, UploadNetworkEngineResponseDto response, NormalizationResult result) throws ApplicationException {
        int totalInvalidSymbols;
        InteractionNetwork network = settings.getNetwork();
        InteractionNetworkGroup group = settings.getNetworkGroup();
        NetworkMetadata metadata = new NetworkMetadata();
        metadata.setId(this.data.getNextAvailableId(NetworkMetadata.class, this.namespace).longValue());
        metadata.setInteractionCount((long)response.getNumInteractions());
        metadata.setOther(network.getDescription());
        metadata.setProcessingDescription(this.getProcessingDescription(settings));
        metadata.setSource(settings.getSource());
        StringBuilder details = new StringBuilder();
        if (result.getDroppedEntries() > 0) {
            details.append(String.format("%d/%d dropped rows", result.getDroppedEntries(), result.getDroppedEntries() + result.getTotalEntries()));
        }
        if ((totalInvalidSymbols = result.getInvalidSymbols().size()) > 0) {
            if (details.length() > 0) {
                details.append("; ");
            }
            details.append(String.format("%d unrecognized gene symbols", totalInvalidSymbols));
        }
        if (details.length() > 0) {
            metadata.setOther(details.toString());
        }
        network.setMetadata(metadata);
        this.modelWriter.addNetwork(network, group);
    }

    private String getProcessingDescription(DataImportSettings settings) {
        NetworkProcessingMethod method = settings.getProcessingMethod();
        if (NetworkProcessingMethod.DIRECT.equals((Object)method)) {
            return Strings.processingMethodDirect_label;
        }
        if (NetworkProcessingMethod.PEARSON.equals((Object)method)) {
            return Strings.processingMethodPearson_label;
        }
        if (NetworkProcessingMethod.LOG_FREQUENCY.equals((Object)method)) {
            return Strings.processingMethodLogFrequency_label;
        }
        return Strings.processingMethodUnknown_label;
    }

    @Override
    public void uninstallNetwork(InteractionNetwork network) throws ApplicationException, DataStoreException {
        Mania2 mania = new Mania2(new DataCache((IObjectCache)new MemObjectCache(this.data.getObjectCache(NullProgressReporter.instance(), false))));
        InteractionNetworkGroup group = this.data.getNetworkGroup(network.getId());
        Organism organism = this.data.getOrganism(group.getId());
        if (organism == null) {
            return;
        }
        RemoveNetworkEngineRequestDto request = new RemoveNetworkEngineRequestDto();
        request.setOrganismId(organism.getId());
        request.setNamespace("user");
        request.setNetworkId(network.getId());
        mania.removeUserNetworks(request);
        this.modelWriter.deleteNetwork(network);
    }

    @Override
    public void updateNetwork(InteractionNetwork network, InteractionNetworkGroup group) throws ApplicationException, DataStoreException {
        this.modelWriter.deleteNetwork(network);
        this.modelWriter.addNetwork(network, group);
    }

    @Override
    public void close() throws ApplicationException {
        this.modelWriter.close();
    }

    @Override
    public IModelWriter getModelWriter() {
        return this.modelWriter;
    }
}

