/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.NormalizationResult;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.IConfirmationHandler;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.TextReportDialog;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.type.DataLayout;

public class LuceneConfirmationHandler
implements IConfirmationHandler {
    private final UiUtils uiUtils;
    private final TaskDispatcher taskDispatcher;

    public LuceneConfirmationHandler(UiUtils uiUtils, TaskDispatcher taskDispatcher) {
        this.uiUtils = uiUtils;
        this.taskDispatcher = taskDispatcher;
    }

    @Override
    public boolean acceptPartialImport(DataImportSettings settings, NormalizationResult result) {
        String message;
        String report;
        if (settings.getDataLayout().equals((Object)DataLayout.PROFILE)) {
            report = this.generateProfileReport(result);
            message = Strings.reportInvalidProfileData;
        } else {
            report = this.generateNetworkReport(result);
            message = Strings.reportInvalidNetworkData;
        }
        ArrayList<String> options = new ArrayList<String>();
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        if (result.getTotalEntries() > 0) {
            message = Strings.reportPrompt_label;
            options.add(Strings.yes_label);
            options.add(Strings.no_label);
            values.put(Strings.yes_label, 0);
            values.put(Strings.no_label, 1);
        } else {
            options.add(Strings.ok_label);
            values.put(Strings.ok_label, 0);
        }
        TextReportDialog dialog = new TextReportDialog(this.taskDispatcher.getTaskDialog(), message, options, values, report, true, this.uiUtils);
        dialog.setTitle(Strings.report_title);
        dialog.setVisible(true);
        Integer selection = (Integer)dialog.getSelectedValue();
        if (selection == null) {
            return false;
        }
        return selection == 0 && result.getTotalEntries() > 0;
    }

    private String generateNetworkReport(NormalizationResult result) {
        ArrayList invalidSymbols = new ArrayList(result.getInvalidSymbols());
        Collections.sort(invalidSymbols);
        StringBuilder builder = new StringBuilder();
        builder.append("<b>");
        builder.append(Strings.reportValidInteractions);
        builder.append("</b> ");
        builder.append(result.getTotalEntries());
        builder.append("<br><b>");
        builder.append(Strings.reportInvalidInteractions);
        builder.append("</b> ");
        builder.append(result.getDroppedEntries());
        builder.append("<hr>");
        builder.append("<b>");
        builder.append(Strings.reportUnrecognizedGenes);
        builder.append("</b> ");
        builder.append(invalidSymbols.size());
        builder.append("<br>");
        builder.append("<ul>");
        for (String symbol : invalidSymbols) {
            builder.append("<li>");
            builder.append(symbol);
            builder.append("</li>");
        }
        builder.append("</ul>");
        return builder.toString();
    }

    private String generateProfileReport(NormalizationResult result) {
        ArrayList invalidSymbols = new ArrayList(result.getInvalidSymbols());
        Collections.sort(invalidSymbols);
        StringBuilder builder = new StringBuilder();
        builder.append("<b>");
        builder.append(Strings.reportValidRows);
        builder.append("</b> ");
        builder.append(result.getTotalEntries());
        builder.append("<br><b>");
        builder.append(Strings.reportInvalidRows);
        builder.append("</b> ");
        builder.append(result.getDroppedEntries());
        builder.append("<hr>");
        builder.append("<b>");
        builder.append(Strings.reportUnrecognizedGenes);
        builder.append("</b>");
        builder.append(result.getInvalidSymbols().size());
        builder.append("<br>");
        builder.append("<ul>");
        for (String symbol : invalidSymbols) {
            builder.append("<li>");
            builder.append(symbol);
            builder.append("</li>");
        }
        builder.append("</ul>");
        return builder.toString();
    }
}

