/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.compatibility;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.genemania.plugin.data.compatibility.Adapter;
import org.genemania.plugin.data.compatibility.AdapterStrategy;

public class AdaptingObjectInputStream
extends ObjectInputStream {
    private AdapterStrategy strategy;

    protected AdaptingObjectInputStream(InputStream stream, AdapterStrategy strategy) throws IOException, SecurityException {
        super(stream);
        this.enableResolveObject(true);
        this.strategy = strategy;
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        Class<?> type = obj.getClass();
        if (!this.strategy.createdThis(obj)) {
            return obj;
        }
        Adapter<?, ?> adapter = this.strategy.getAdapter(type.getName());
        if (adapter == null) {
            return obj;
        }
        try {
            return this.adapt(obj, adapter);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    Object adapt(final Object object, Adapter<?, ?> adapter) throws ClassNotFoundException {
        Class<?> actualType = object.getClass();
        if (!this.strategy.shouldAdapt(actualType.getName())) {
            return object;
        }
        Object proxy = Proxy.newProxyInstance(adapter.getClass().getClassLoader(), new Class[]{adapter.getInterface()}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
                String name = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Method targetMethod = object.getClass().getMethod(name, parameterTypes);
                targetMethod.setAccessible(true);
                Object result = targetMethod.invoke(object, arguments);
                Class<?> resultType = result.getClass();
                if (!AdaptingObjectInputStream.this.strategy.createdThis(result)) {
                    return result;
                }
                return AdaptingObjectInputStream.this.adapt(result, AdaptingObjectInputStream.this.strategy.getAdapter(resultType.getName()));
            }
        });
        return adapter.adapt(proxy);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDescription) throws IOException, ClassNotFoundException {
        String name = classDescription.getName();
        if (!this.strategy.shouldAdapt(name)) {
            return Class.forName(name, false, ClassLoader.getSystemClassLoader());
        }
        return this.strategy.resolveClass(name);
    }
}

