/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version {
    private static final Pattern PATTERN = Pattern.compile("(\\d\\d\\d\\d-\\d\\d-\\d\\d)(-(.*))?");
    private final String baseVersion;
    private final String type;

    public Version(String baseVersion, String type) {
        this.baseVersion = baseVersion;
        this.type = type;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEquivalentTo(Version version) {
        return this.baseVersion.equals(version.baseVersion);
    }

    public boolean equals(Object other) {
        Version version = (Version)other;
        return this.baseVersion.equals(version.baseVersion) && (this.type == null && version.type == null || this.type != null && this.type.equals(version.type));
    }

    public int hashCode() {
        int result = this.baseVersion.hashCode();
        if (this.type == null) {
            return result;
        }
        return result + 23 * this.type.hashCode();
    }

    public String toString() {
        if (this.type == null) {
            return this.baseVersion;
        }
        return this.baseVersion + "-" + this.type;
    }

    public static Version parse(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.matches()) {
            return new Version(matcher.group(1), matcher.group(3));
        }
        return new Version(string, null);
    }
}

