/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data;

import java.awt.Window;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.IConfiguration;

public class Configuration
implements IConfiguration {
    protected final DataSet data;

    public Configuration(DataSet data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        String configPath = this.data.getFullPath("genemania.xml");
        FileWriter writer = new FileWriter(configPath);
        try {
            this.write(writer);
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void showUi(Window parent) {
    }

    @Override
    public boolean hasUi() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer out) {
        PrintWriter writer = new PrintWriter(out);
        try {
            writer.printf("<?xml version=\"1.0\" encoding=\"utf-8\"?>", new Object[0]);
            writer.printf("<genemania>\n", new Object[0]);
            writer.printf("    <type>%s</type>\n", this.getClass().getName());
            writer.printf("    <data-version>%s</data-version>\n", this.escape(this.data.getVersion().toString()));
            writer.printf("    <access-mode>%s</access-mode>\n", this.escape(this.data.getAccessMode()));
            writer.printf("</genemania>\n", new Object[0]);
        }
        finally {
            writer.close();
        }
    }

    protected String escape(String text) {
        if (text == null) {
            return "";
        }
        text = text.replaceAll("&", "&amp;");
        return text.replaceAll("<", "&lt;");
    }
}

