/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.Interaction;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Node;
import org.genemania.domain.Tag;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.cytoscape.EdgeAttributeProvider;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.AnnotationEntry;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.model.ViewStateBuilder;
import org.genemania.plugin.proxies.EdgeProxy;
import org.genemania.plugin.proxies.NetworkProxy;
import org.genemania.plugin.proxies.NodeProxy;

public abstract class AbstractCytoscapeUtils<NETWORK, NODE, EDGE>
implements CytoscapeUtils<NETWORK, NODE, EDGE> {
    private static final String EDGE_TYPE_INTERACTION = "interaction";
    protected static final double MINIMUM_NODE_SIZE = 10.0;
    protected static final double MAXIMUM_NODE_SIZE = 40.0;
    protected static final double MINIMUM_EDGE_WIDTH = 1.0;
    protected static final double MAXIMUM_EDGE_WIDTH = 6.0;
    private final Map<EDGE, EdgeProxy<EDGE, NODE>> edgeProxies;
    private final Map<NODE, NodeProxy<NODE>> nodeProxies;
    private final Map<NETWORK, NetworkProxy<NETWORK, NODE, EDGE>> networkProxies;
    private final Map<String, AttributeHandler> attributeHandlerRegistry = this.createHandlerRegistry();
    protected final NetworkUtils networkUtils;

    public AbstractCytoscapeUtils(NetworkUtils networkUtils) {
        this.networkUtils = networkUtils;
        this.edgeProxies = new WeakHashMap<EDGE, EdgeProxy<EDGE, NODE>>();
        this.nodeProxies = new WeakHashMap<NODE, NodeProxy<NODE>>();
        this.networkProxies = new WeakHashMap<NETWORK, NetworkProxy<NETWORK, NODE, EDGE>>();
    }

    @Override
    public EdgeProxy<EDGE, NODE> getEdgeProxy(EDGE edge, NETWORK network) {
        if (edge == null) {
            return null;
        }
        if (this.edgeProxies.containsKey(edge)) {
            return this.edgeProxies.get(edge);
        }
        EdgeProxy<EDGE, NODE> proxy = this.createEdgeProxy(edge, network);
        this.edgeProxies.put(edge, proxy);
        return proxy;
    }

    @Override
    public NetworkProxy<NETWORK, NODE, EDGE> getNetworkProxy(NETWORK network) {
        if (network == null) {
            return null;
        }
        if (this.networkProxies.containsKey(network)) {
            return this.networkProxies.get(network);
        }
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.createNetworkProxy(network);
        this.networkProxies.put(network, proxy);
        return proxy;
    }

    @Override
    public NodeProxy<NODE> getNodeProxy(NODE node, NETWORK network) {
        if (node == null) {
            return null;
        }
        if (this.nodeProxies.containsKey(node)) {
            return this.nodeProxies.get(node);
        }
        NodeProxy<NODE> proxy = this.createNodeProxy(node, network);
        this.nodeProxies.put(node, proxy);
        return proxy;
    }

    protected abstract NodeProxy<NODE> createNodeProxy(NODE var1, NETWORK var2);

    protected abstract NetworkProxy<NETWORK, NODE, EDGE> createNetworkProxy(NETWORK var1);

    protected abstract EdgeProxy<EDGE, NODE> createEdgeProxy(EDGE var1, NETWORK var2);

    @Override
    public void expandAttributes(NETWORK cyNetwork, ViewState options, List<String> attributes) {
        if (attributes.size() == 0) {
            return;
        }
        NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.getNetworkProxy(cyNetwork);
        for (EDGE edge : networkProxy.getEdges()) {
            EdgeProxy<EDGE, NODE> edgeProxy = this.getEdgeProxy(edge, cyNetwork);
            String edgeId = edgeProxy.getIdentifier();
            Set<Network<?>> networks = options.getNetworksByEdge(edgeId);
            List networkNames = edgeProxy.getAttribute("networks", List.class);
            for (String attribute : attributes) {
                ArrayList<Object> values = new ArrayList<Object>();
                AttributeHandler handler = this.attributeHandlerRegistry.get(attribute);
                for (String networkName : networkNames) {
                    InteractionNetwork network = this.findNetwork(networkName, networks);
                    values.add(handler.getValue(network));
                }
                edgeProxy.setAttribute(attribute, values);
            }
        }
    }

    private InteractionNetwork findNetwork(String networkName, Set<Network<?>> networks) {
        for (Network<?> network : networks) {
            InteractionNetwork adapted = network.adapt(InteractionNetwork.class);
            if (adapted == null || !adapted.getName().equals(networkName)) continue;
            return adapted;
        }
        return null;
    }

    private Map<String, AttributeHandler> createHandlerRegistry() {
        HashMap<String, AttributeHandler> map = new HashMap<String, AttributeHandler>();
        map.put("tags", new TagAttributeHandler());
        for (String name : new String[]{"authors", "interactionCount", "pubmedId", "processingDescription", "publicationName", "yearPublished", "source", "sourceUrl", "title", "url"}) {
            map.put(name, new MetadataAttributeHandler(name));
        }
        return map;
    }

    @Override
    public NODE getNode(NETWORK network, Node node, String preferredSymbol) {
        Gene gene;
        String id = this.getNodeId(network, node);
        NODE target = this.getNode(id, network);
        if (target != null) {
            return target;
        }
        String name = preferredSymbol == null ? ((gene = this.networkUtils.getPreferredGene(node)) == null ? Strings.missingGeneName : gene.getSymbol()) : preferredSymbol;
        target = this.createNode(id, network);
        NodeProxy<NODE> nodeProxy = this.getNodeProxy(target, network);
        nodeProxy.setAttribute("gene name", name);
        this.exportSynonyms(nodeProxy, node);
        return target;
    }

    protected String getNodeId(NETWORK network, Node node) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.getNetworkProxy(network);
        return String.format("%s-%s", this.filterTitle(proxy.getTitle()), node.getName());
    }

    protected String getNodeId(NETWORK network, Attribute attribute) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.getNetworkProxy(network);
        return String.format("%s-%s", this.filterTitle(proxy.getTitle()), attribute.getName());
    }

    private String filterTitle(String title) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < title.length(); ++i) {
            char character = title.charAt(i);
            if (Character.isLetterOrDigit(character)) {
                builder.append(character);
                continue;
            }
            builder.append("_");
        }
        return builder.toString();
    }

    private void exportSynonyms(NodeProxy<NODE> proxy, Node node) {
        Collection genes = node.getGenes();
        for (Gene gene : genes) {
            GeneNamingSource source = gene.getNamingSource();
            source.getName();
            proxy.setAttribute(source.getName(), gene.getSymbol());
        }
    }

    protected abstract NODE getNode(String var1, NETWORK var2);

    protected abstract NODE createNode(String var1, NETWORK var2);

    protected abstract NETWORK createNetwork(String var1);

    protected abstract EDGE getEdge(NODE var1, NODE var2, String var3, String var4, NETWORK var5);

    protected abstract EDGE getEdge(String var1, NETWORK var2);

    @Override
    public NETWORK createNetwork(DataSet data, String name, SearchResult options, ViewStateBuilder builder, EdgeAttributeProvider attributeProvider) {
        NETWORK currentNetwork = this.createNetwork(name);
        NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.getNetworkProxy(currentNetwork);
        networkProxy.setAttribute("type", "genemania");
        networkProxy.setAttribute("data version", data.getVersion().toString());
        networkProxy.setAttribute("organism", options.getOrganism().getName());
        networkProxy.setAttribute("source-networks", this.serializeNetworks(options));
        networkProxy.setAttribute("combining method", options.getCombiningMethod().getCode());
        networkProxy.setAttribute("search limit", options.getGeneSearchLimit());
        networkProxy.setAttribute("attribute search limit", options.getAttributeSearchLimit());
        networkProxy.setAttribute("annotations", this.serializeAnnotations(options));
        for (Group<?, ?> group : builder.getAllGroups()) {
            Group<InteractionNetworkGroup, InteractionNetwork> adapted = group.adapt(InteractionNetworkGroup.class, InteractionNetwork.class);
            if (adapted == null) continue;
            for (Network<InteractionNetwork> network : adapted.getNetworks()) {
                Collection sourceInteractions = network.getModel().getInteractions();
                if (sourceInteractions == null || sourceInteractions.size() == 0) continue;
                this.buildGraph(currentNetwork, sourceInteractions, network, attributeProvider, options, builder);
            }
        }
        for (Gene gene : options.getQueryGenes().values()) {
            Node node = gene.getNode();
            this.getNode(currentNetwork, node, this.getSymbol(gene));
        }
        HashMap<Long, Network<Attribute>> attributesById = new HashMap<Long, Network<Attribute>>();
        for (Group<?, ?> group : builder.getAllGroups()) {
            Group<AttributeGroup, Attribute> adapted = group.adapt(AttributeGroup.class, Attribute.class);
            if (adapted == null) continue;
            for (Network<Attribute> network : adapted.getNetworks()) {
                attributesById.put(network.getModel().getId(), network);
            }
        }
        Map<Attribute, Double> weights = options.getAttributeWeights();
        for (Map.Entry<Long, Collection<Attribute>> entry : options.getAttributesByNodeId().entrySet()) {
            Gene gene = options.getGene(entry.getKey());
            NODE to = this.getNode(currentNetwork, gene.getNode(), null);
            for (Attribute attribute : entry.getValue()) {
                String id = this.getNodeId(currentNetwork, attribute);
                Network network = (Network)attributesById.get(attribute.getId());
                NODE from = this.getNode(id, currentNetwork);
                if (from == null) {
                    from = this.createNode(id, currentNetwork);
                    NodeProxy<NODE> nodeProxy = this.getNodeProxy(from, currentNetwork);
                    nodeProxy.setAttribute("gene name", attribute.getName());
                    nodeProxy.setAttribute("node type", "attribute");
                    nodeProxy.setAttribute("score", weights.get(attribute));
                    builder.addSourceNetworkForNode(nodeProxy.getIdentifier(), network);
                }
                String edgeLabel = attribute.getName();
                EDGE edge = this.getEdge(from, to, EDGE_TYPE_INTERACTION, edgeLabel, currentNetwork);
                EdgeProxy<EDGE, NODE> edgeProxy = this.getEdgeProxy(edge, currentNetwork);
                AttributeGroup group = options.getAttributeGroup(attribute.getId());
                edgeProxy.setAttribute("data type", group.getName());
                edgeProxy.setAttribute("attribute name", edgeLabel);
                edgeProxy.setAttribute("highlight", 1);
                String edgeId = edgeProxy.getIdentifier();
                builder.addEdge(builder.getGroup(network), edgeId);
                builder.addSourceNetworkForEdge(edgeId, network);
            }
        }
        this.decorateNodes(currentNetwork, options);
        return currentNetwork;
    }

    private String serializeAnnotations(SearchResult options) {
        StringWriter writer = new StringWriter();
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        try {
            JsonGenerator generator = jsonFactory.createJsonGenerator((Writer)writer);
            generator.writeStartArray();
            List<AnnotationEntry> enrichmentSummary = options.getEnrichmentSummary();
            for (AnnotationEntry entry : enrichmentSummary) {
                generator.writeStartObject();
                generator.writeFieldName("name");
                generator.writeString(entry.getName());
                generator.writeFieldName("description");
                generator.writeString(entry.getDescription());
                generator.writeFieldName("qValue");
                generator.writeNumber(entry.getQValue());
                generator.writeFieldName("sample");
                generator.writeNumber(entry.getSampleOccurrences());
                generator.writeFieldName("total");
                generator.writeNumber(entry.getTotalOccurrences());
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.close();
        }
        catch (IOException e) {
            LogUtils.log(this.getClass(), e);
            return "";
        }
        return writer.toString();
    }

    private String serializeNetworks(SearchResult options) {
        MappingJsonFactory factory = new MappingJsonFactory();
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = factory.createJsonGenerator((Writer)writer);
            generator.writeStartArray();
            Map<InteractionNetwork, Double> networkWeights = options.getNetworkWeights();
            for (Map.Entry<InteractionNetwork, Double> entry : networkWeights.entrySet()) {
                generator.writeStartObject();
                InteractionNetwork network = entry.getKey();
                generator.writeFieldName("group");
                generator.writeString(options.getInteractionNetworkGroup(network.getId()).getName());
                generator.writeFieldName("name");
                generator.writeString(network.getName());
                generator.writeFieldName("weight");
                generator.writeNumber(entry.getValue().doubleValue());
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.close();
        }
        catch (IOException e) {
            LogUtils.log(this.getClass(), e);
            return "";
        }
        return writer.toString();
    }

    private void buildGraph(NETWORK currentNetwork, Collection<Interaction> interactions, Network<InteractionNetwork> network, EdgeAttributeProvider attributeProvider, SearchResult options, ViewStateBuilder builder) {
        Map<Long, Gene> queryGenes = options.getQueryGenes();
        InteractionNetwork model = network.getModel();
        for (Interaction interaction : interactions) {
            Node fromNode = interaction.getFromNode();
            NODE from = this.getNode(currentNetwork, fromNode, this.getSymbol(queryGenes.get(fromNode.getId())));
            Node toNode = interaction.getToNode();
            NODE to = this.getNode(currentNetwork, toNode, this.getSymbol(queryGenes.get(toNode.getId())));
            String edgeLabel = attributeProvider.getEdgeLabel(model);
            EDGE edge = this.getEdge(from, to, EDGE_TYPE_INTERACTION, edgeLabel, currentNetwork);
            EdgeProxy<EDGE, NODE> edgeProxy = this.getEdgeProxy(edge, currentNetwork);
            String edgeId = edgeProxy.getIdentifier();
            Double rawWeight = interaction.getWeight();
            builder.addSourceNetworkForEdge(edgeId, network);
            Double weight = rawWeight * network.getWeight();
            ArrayList<String> networkNames = edgeProxy.getAttribute("networks", List.class);
            if (networkNames == null) {
                networkNames = new ArrayList<String>();
            }
            networkNames.add(network.getName());
            edgeProxy.setAttribute("networks", networkNames);
            ArrayList<Double> edgeWeights = edgeProxy.getAttribute("raw weights", List.class);
            if (edgeWeights == null) {
                edgeWeights = new ArrayList<Double>();
            }
            edgeWeights.add(Double.valueOf(interaction.getWeight()));
            edgeProxy.setAttribute("raw weights", edgeWeights);
            Double oldWeight = edgeProxy.getAttribute("normalized max weight", Double.class);
            if (oldWeight == null || oldWeight < weight) {
                edgeProxy.setAttribute("normalized max weight", weight);
            }
            edgeProxy.setAttribute("highlight", 1);
            for (Map.Entry<String, Object> entry : attributeProvider.getAttributes(model).entrySet()) {
                edgeProxy.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    private String getSymbol(Gene gene) {
        if (gene == null) {
            return null;
        }
        return gene.getSymbol();
    }

    private void decorateNodes(NETWORK currentNetwork, SearchResult options) {
        Map<Long, Gene> queryGenes = options.getQueryGenes();
        Map<Gene, Double> scores = options.getScores();
        for (Map.Entry<Gene, Double> entry : scores.entrySet()) {
            double score = entry.getValue();
            Node node = entry.getKey().getNode();
            NODE cyNode = this.getNode(currentNetwork, node, this.getSymbol(queryGenes.get(node)));
            NodeProxy<NODE> nodeProxy = this.getNodeProxy(cyNode, currentNetwork);
            nodeProxy.setAttribute("log score", Math.log(score));
            nodeProxy.setAttribute("score", score);
            String type = queryGenes.containsKey(node.getId()) ? "query" : "result";
            Collection<AnnotationEntry> nodeAnnotations = options.getAnnotations(node.getId());
            if (nodeAnnotations != null) {
                ArrayList<String> annotationIds = new ArrayList<String>();
                ArrayList<String> annotationNames = new ArrayList<String>();
                for (AnnotationEntry annotation : nodeAnnotations) {
                    annotationIds.add(annotation.getName());
                    annotationNames.add(annotation.getDescription());
                }
                nodeProxy.setAttribute("annotations", annotationIds);
                nodeProxy.setAttribute("annotation name", annotationNames);
            }
            nodeProxy.setAttribute("node type", type);
        }
    }

    @Override
    public void setHighlighted(ViewState options, NETWORK cyNetwork, boolean visible) {
        NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.getNetworkProxy(cyNetwork);
        for (EDGE edge : networkProxy.getEdges()) {
            Group<?, ?> group;
            EdgeProxy<EDGE, NODE> edgeProxy = this.getEdgeProxy(edge, cyNetwork);
            String groupName = edgeProxy.getAttribute("data type", String.class);
            if (groupName == null || (group = options.getGroup(groupName)) == null) continue;
            Integer value = options.getEnabled(group) || visible ? 1 : 0;
            edgeProxy.setAttribute("highlight", value);
        }
        this.updateVisualStyles(cyNetwork);
        this.repaint();
    }

    protected String getVisualStyleName(NETWORK network) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.getNetworkProxy(network);
        return proxy.getTitle().replace(".", "");
    }

    @Override
    public void setHighlight(ViewState config, Group<?, ?> source, NETWORK network, boolean selected) {
        Set<String> edgeIds = config.getEdgeIds(source);
        if (edgeIds == null) {
            return;
        }
        config.setEnabled(source, selected);
        if (selected) {
            for (String edgeId : edgeIds) {
                EDGE edge = this.getEdge(edgeId, network);
                EdgeProxy<EDGE, NODE> edgeProxy = this.getEdgeProxy(edge, network);
                edgeProxy.setAttribute("highlight", 1);
            }
        } else {
            for (String edgeId : edgeIds) {
                EDGE edge = this.getEdge(edgeId, network);
                EdgeProxy<EDGE, NODE> edgeProxy = this.getEdgeProxy(edge, network);
                edgeProxy.setAttribute("highlight", 0);
            }
        }
        this.updateVisualStyles(network);
        this.repaint();
    }

    static class MetadataAttributeHandler
    implements AttributeHandler {
        private String name;

        public MetadataAttributeHandler(String attributeName) {
            this.name = attributeName;
        }

        @Override
        public Object getValue(InteractionNetwork network) {
            try {
                return BeanUtils.getProperty((Object)network.getMetadata(), (String)this.name);
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }

    static class TagAttributeHandler
    implements AttributeHandler {
        TagAttributeHandler() {
        }

        @Override
        public Object getValue(InteractionNetwork network) {
            StringBuilder builder = new StringBuilder();
            for (Tag tag : network.getTags()) {
                if (builder.length() > 0) {
                    builder.append("|");
                }
                builder.append(tag.getName());
            }
            return builder.toString();
        }
    }

    static interface AttributeHandler {
        public Object getValue(InteractionNetwork var1);
    }
}

