/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.controllers;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.genemania.domain.GeneNamingSource;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.controllers.AttributesController;
import org.genemania.plugin.controllers.RankedGeneProviderWithUniprotHack;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.proxies.EdgeProxy;
import org.genemania.plugin.proxies.NetworkProxy;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.plugin.report.CytoscapeTextReportExporter;
import org.genemania.plugin.report.ManiaReport;
import org.genemania.plugin.view.AttributesDialog;
import org.genemania.plugin.view.util.FileSelectionMode;
import org.genemania.plugin.view.util.UiUtils;

public class ManiaResultsController<NETWORK, NODE, EDGE> {
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final DataSetManager dataSetManager;
    private final NetworkUtils networkUtils;
    private final UiUtils uiUtils;

    public ManiaResultsController(DataSetManager dataSetManager, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, UiUtils uiUtils, NetworkUtils networkUtils) {
        this.dataSetManager = dataSetManager;
        this.cytoscapeUtils = cytoscapeUtils;
        this.uiUtils = uiUtils;
        this.networkUtils = networkUtils;
    }

    public void showAttributesDialog(NETWORK cyNetwork, ViewState options) {
        AttributesDialog dialog = new AttributesDialog(this.cytoscapeUtils.getFrame(), true, new AttributesController());
        dialog.pack();
        dialog.setVisible(true);
        List<String> attributes = dialog.getSelectedAttributes();
        this.cytoscapeUtils.expandAttributes(cyNetwork, options, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport(Component parent, ViewState viewState) throws ApplicationException {
        SearchResult options = viewState.getSearchResult();
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("txt");
        String date = DateFormat.getDateTimeInstance(1, 1).format(new Date());
        date = date.replace(":", "-").replace("/", "-");
        String filename = String.format("GeneMANIA-Report-%s-%s.txt", options.getOrganism().getName(), date);
        File initialFile = new File(filename);
        File file = this.uiUtils.getFile(parent, Strings.maniaResultsPanelExport_title, initialFile, Strings.maniaResultsPanelExportFile_description, extensions, FileSelectionMode.SAVE_FILE);
        if (file == null) {
            return;
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                DataSet data = this.dataSetManager.getDataSet();
                List<GeneNamingSource> preferences = Collections.emptyList();
                RankedGeneProviderWithUniprotHack provider = new RankedGeneProviderWithUniprotHack(data.getAllNamingSources(), preferences);
                CytoscapeTextReportExporter exporter = new CytoscapeTextReportExporter(provider, this.networkUtils);
                ManiaReport report = new ManiaReport(viewState, data);
                exporter.export(report, stream);
                stream.flush();
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            LogUtils.log(this.getClass(), e);
        }
    }

    public void computeHighlightedNetworks(ViewState options) {
        HashSet highlightedNetworks = new HashSet();
        NETWORK cyNetwork = this.cytoscapeUtils.getCurrentNetwork();
        if (cyNetwork == null) {
            return;
        }
        NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        Set<EDGE> selectedEdges = networkProxy.getSelectedEdges();
        for (EDGE edge : selectedEdges) {
            EdgeProxy<EDGE, NODE> edgeProxy = this.cytoscapeUtils.getEdgeProxy(edge, cyNetwork);
            Set<Network<?>> set = options.getNetworksByEdge(edgeProxy.getIdentifier());
            for (Network<?> network : set) {
                highlightedNetworks.add(network);
            }
        }
        Set<NODE> selectedNodes = networkProxy.getSelectedNodes();
        for (NODE node : selectedNodes) {
            NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(node, cyNetwork);
            Set<Network<?>> networks = options.getNetworksByNode(nodeProxy.getIdentifier());
            for (Network<?> network : networks) {
                highlightedNetworks.add(network);
            }
        }
        HashSet groups = new HashSet();
        options.clearHighlightedNetworks();
        for (Network network : highlightedNetworks) {
            groups.add(options.getGroup(network));
            options.setNetworkHighlighted(network, true);
        }
        options.clearHighlightedGroups();
        for (Group group : groups) {
            options.setGroupHighlighted(group, true);
        }
    }
}

