/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class DynamicListModel<T extends Comparable<T>>
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    private final List<T> items = new ArrayList<T>();

    public DynamicListModel() {
    }

    public DynamicListModel(List<T> items) {
        this();
        this.setItems(items);
    }

    @Override
    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    public void add(T item) {
        this.items.add(item);
        int index = this.items.size() - 1;
        this.fireIntervalAdded(this, index, index);
    }

    public void remove(int index) {
        this.items.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void remove(int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            this.remove(indices[i]);
        }
    }

    public void setItems(List<T> items) {
        this.clear();
        this.items.addAll(items);
        this.fireIntervalAdded(this, 0, items.size() - 1);
    }

    public void clear() {
        if (this.items.size() == 0) {
            return;
        }
        int index = this.items.size() - 1;
        this.items.clear();
        this.fireIntervalRemoved(this, 0, index);
    }

    public void sort() {
        if (this.items.size() == 0) {
            return;
        }
        Collections.sort(this.items);
        this.fireContentsChanged(this, 0, this.items.size() - 1);
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public boolean contains(T item) {
        return this.items.contains(item);
    }
}

