/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultEditorKit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.genemania.completion.CompletionConsumer;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.Gene;
import org.genemania.domain.Organism;
import org.genemania.mediator.lucene.LuceneGeneMediator;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.CompletionTransferHandler;
import org.genemania.plugin.completion.DynamicTableModel;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ProgressReporter;

public class CompletionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String GENE_HINT = Strings.completionPanelGeneHint_label;
    private int autoTriggerThreshold;
    private JTextField textField;
    private JTable proposalTable;
    private final DynamicTableModel<Gene> resultModel;
    private final DynamicTableModel<Gene> proposalModel;
    private final CompletionConsumer consumer;
    private GeneCompletionProvider2 provider;
    private final JTable resultTable;
    private int lastCompletionCount;
    private ProgressReporter progress;
    private int limit;
    private JDialog proposalDialog;
    private String lastQuery;
    private int lastSelectionStart;
    private int lastSelectionEnd;
    private JLabel statusLabel;
    private final NetworkUtils networkUtils;
    private final UiUtils uiUtils;
    private final TaskDispatcher taskDispatcher;

    public CompletionPanel(int autoTriggerThreshold, NetworkUtils networkUtils, UiUtils uiUtils, TaskDispatcher taskDispatcher) {
        this.networkUtils = networkUtils;
        this.uiUtils = uiUtils;
        this.taskDispatcher = taskDispatcher;
        this.setOpaque(false);
        this.autoTriggerThreshold = autoTriggerThreshold;
        this.proposalModel = this.createModel();
        this.resultModel = this.createModel();
        this.limit = 15;
        this.consumer = new CompletionConsumer(){

            public void consume(String completion) {
                CompletionPanel.this.lastCompletionCount++;
                if (CompletionPanel.this.lastCompletionCount >= CompletionPanel.this.limit) {
                    return;
                }
                Gene gene = CompletionPanel.this.provider.getGene(completion);
                CompletionPanel.this.proposalModel.add(gene);
            }

            public void finish() {
                switch (CompletionPanel.this.lastCompletionCount) {
                    case -1: {
                        CompletionPanel.this.setProposalStatus(Strings.completionPanelTooManyGenes_status);
                        break;
                    }
                    case 0: {
                        CompletionPanel.this.setProposalStatus(Strings.completionPanelNoGenes_status);
                        break;
                    }
                    case 1: {
                        CompletionPanel.this.setProposalStatus(Strings.completionPanelOneGene_status);
                    }
                    default: {
                        if (CompletionPanel.this.lastCompletionCount >= CompletionPanel.this.limit) {
                            CompletionPanel.this.setProposalStatus(String.format(Strings.completionPanelTooManyGenes2_status, CompletionPanel.this.limit, CompletionPanel.this.getQuery()));
                            break;
                        }
                        CompletionPanel.this.setProposalStatus(String.format(Strings.completionPanelManyGenes_status, CompletionPanel.this.lastCompletionCount));
                    }
                }
            }

            public void tooManyCompletions() {
            }
        };
        this.setLayout(new GridBagLayout());
        this.textField = new JTextField();
        this.setShowGeneHint(true);
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CompletionPanel.this.getQuery().equals(GENE_HINT)) {
                    CompletionPanel.this.setShowGeneHint(false);
                }
                CompletionPanel.this.checkTrigger();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (CompletionPanel.this.getQuery().length() == 0) {
                    CompletionPanel.this.setShowGeneHint(true);
                }
            }
        });
        this.add((Component)this.textField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CompletionPanel.this.checkTrigger();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CompletionPanel.this.checkTrigger();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CompletionPanel.this.checkTrigger();
            }
        });
        this.resultTable = this.createTable(this.resultModel);
        this.resultTable.setAutoResizeMode(0);
        JScrollPane resultPane = new JScrollPane(this.resultTable);
        Dimension textSizeHint = uiUtils.computeTextSizeHint(this.getFontMetrics(this.getFont()), 40, 8);
        resultPane.setMinimumSize(textSizeHint);
        this.add((Component)resultPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 19, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 40: 
                    case 225: {
                        CompletionPanel.this.showProposals();
                        ListSelectionModel model = CompletionPanel.this.proposalTable.getSelectionModel();
                        model.clearSelection();
                        model.addSelectionInterval(0, 0);
                        CompletionPanel.this.proposalTable.requestFocus();
                        break;
                    }
                    case 27: {
                        CompletionPanel.this.hideProposals();
                        break;
                    }
                    case 10: {
                        if (CompletionPanel.this.proposalTable.getSelectedRowCount() > 0) {
                            CompletionPanel.this.acceptProposal();
                            break;
                        }
                        CompletionPanel.this.validateEntry(CompletionPanel.this.getQuery());
                    }
                }
            }
        });
        this.proposalDialog = new JDialog(uiUtils.getFrame(this), false);
        this.proposalDialog.setUndecorated(true);
        this.proposalDialog.setAlwaysOnTop(true);
        JRootPane rootPane = this.proposalDialog.getRootPane();
        rootPane.setLayout(new GridBagLayout());
        Color proposalBackground = new Color(255, 255, 224);
        rootPane.setBackground(proposalBackground);
        this.proposalTable = this.createTable(this.proposalModel);
        this.proposalTable.setBackground(proposalBackground);
        this.proposalTable.setSelectionMode(0);
        this.proposalTable.requestFocusInWindow();
        this.statusLabel = new JLabel();
        rootPane.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 19, 2, new Insets(0, 0, 0, 0), 0, 0));
        rootPane.add((Component)this.proposalTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.proposalDialog.pack();
        this.proposalTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CompletionPanel.this.acceptProposal();
            }
        });
        this.proposalTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        CompletionPanel.this.acceptProposal();
                        break;
                    }
                    case 27: {
                        CompletionPanel.this.hideProposals();
                    }
                }
            }
        });
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
            }

            @Override
            public void focusLost(FocusEvent event) {
                CompletionPanel.this.handleFocusLost(event);
            }
        };
        this.addFocusListener(focusListener);
        this.proposalTable.addFocusListener(focusListener);
        this.textField.addFocusListener(focusListener);
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CompletionPanel.this.saveCaret();
            }

            @Override
            public void focusGained(FocusEvent e) {
                CompletionPanel.this.restoreCaret();
            }
        });
        this.resultTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CompletionPanel.this.hideProposals();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                CompletionPanel.this.proposalDialog.setVisible(false);
            }
        });
        this.proposalDialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                CompletionPanel.this.textField.requestFocus();
            }
        });
        this.createMenu();
    }

    private void createMenu() {
        JPopupMenu contextMenu = new JPopupMenu();
        JMenuItem pasteMenu = new JMenuItem(Strings.paste_menuLabel);
        pasteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CompletionPanel.this.textField.requestFocus();
                new DefaultEditorKit.PasteAction().actionPerformed(event);
            }
        });
        contextMenu.add(pasteMenu);
        this.textField.setComponentPopupMenu(contextMenu);
    }

    public void handleParentMoved() {
        if (this.proposalDialog.isVisible()) {
            this.popUpBelow(this.textField);
        }
    }

    void restoreCaret() {
        this.textField.select(this.lastSelectionStart, this.lastSelectionEnd);
    }

    void saveCaret() {
        this.lastSelectionStart = this.textField.getSelectionStart();
        this.lastSelectionEnd = this.textField.getSelectionEnd();
    }

    private void handleFocusLost(FocusEvent event) {
        Component component = event.getOppositeComponent();
        if (component == null) {
            return;
        }
        while (component != null) {
            if (component.equals(this.proposalTable)) {
                return;
            }
            if (component.equals(this.textField)) {
                return;
            }
            if (component.equals(this)) {
                return;
            }
            component = component.getParent();
        }
        this.hideProposals();
    }

    void popUpBelow(Component control) {
        Rectangle controlBounds = control.getBounds();
        Point point = new Point();
        point.x = controlBounds.x;
        point.y = controlBounds.y;
        SwingUtilities.convertPointToScreen(point, control.getParent());
        Rectangle bounds = this.proposalDialog.getBounds();
        bounds.x = point.x;
        bounds.y = point.y + controlBounds.height;
        bounds.width = controlBounds.width;
        this.proposalDialog.setBounds(bounds);
        this.hackForTicket1439();
        this.hackForTicket1449();
        this.proposalDialog.setVisible(true);
    }

    private void hackForTicket1449() {
        String osName = System.getProperty("os.name");
        if (!osName.toLowerCase().startsWith("win")) {
            return;
        }
        this.proposalDialog.setFocusableWindowState(false);
    }

    private void hackForTicket1439() {
        String osName = System.getProperty("os.name");
        if (!"linux".equalsIgnoreCase(osName)) {
            return;
        }
        this.proposalDialog.setFocusableWindowState(false);
    }

    void setShowGeneHint(boolean visible) {
        if (visible) {
            this.textField.setText(GENE_HINT);
            this.textField.setForeground(Color.gray);
        } else {
            this.textField.setText("");
            this.textField.setForeground(Color.black);
        }
    }

    private JTable createTable(TableModel model) {
        JTable table = new JTable(model){

            @Override
            public void addNotify() {
                super.addNotify();
                CompletionPanel.this.uiUtils.packColumns(this);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                this.setForeground(column == 0 ? Color.black : Color.darkGray);
                return super.prepareRenderer(renderer, row, column);
            }
        };
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        return table;
    }

    private DynamicTableModel<Gene> createModel() {
        return new DynamicTableModel<Gene>(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Strings.completionPanelNameColumn_name;
                    }
                    case 1: {
                        return Strings.completionPanelDescriptionColumn_name;
                    }
                }
                return "";
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Gene gene = (Gene)this.get(rowIndex);
                if (gene == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return CompletionPanel.this.networkUtils.getGeneLabel(gene);
                    }
                    case 1: {
                        return gene.getNode().getGeneData().getDescription();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
            }
        };
    }

    public void setProgressReporter(ProgressReporter progress) {
        this.progress = progress;
    }

    void setStatus(String message) {
        if (this.progress != null) {
            this.progress.setStatus(message);
        }
    }

    void setProposalStatus(String message) {
        this.statusLabel.setText(String.format("<html><b>%s</b></html>", message));
    }

    public void setProvider(GeneCompletionProvider2 provider) {
        if (this.provider != null) {
            this.provider.close();
        }
        this.provider = provider;
        if (provider == null) {
            provider = this.createEmptyProvider();
        }
        this.textField.setTransferHandler(new CompletionTransferHandler(provider, new CompletionConsumer(){
            List<String> completions = new ArrayList<String>();

            public void consume(String completion) {
                this.completions.add(completion);
            }

            public void finish() {
                CompletionPanel.this.validateGene(this.completions);
                this.completions.clear();
            }

            public void tooManyCompletions() {
            }
        }, this.networkUtils, this.uiUtils, this.taskDispatcher));
    }

    private GeneCompletionProvider2 createEmptyProvider() {
        try {
            RAMDirectory directory = new RAMDirectory();
            Analyzer analyzer = LuceneGeneMediator.createDefaultAnalyzer();
            IndexWriter writer = new IndexWriter((Directory)directory, analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
            writer.commit();
            writer.close();
            IndexSearcher searcher = new IndexSearcher((Directory)directory, true);
            return new GeneCompletionProvider2((Searcher)searcher, analyzer, new Organism());
        }
        catch (IOException e) {
            return null;
        }
    }

    private void checkTrigger() {
        String text = this.getQuery();
        if (text.equals(GENE_HINT)) {
            return;
        }
        if (text.length() >= this.autoTriggerThreshold) {
            this.showProposals();
        } else {
            this.lastQuery = null;
            this.hideProposals();
        }
    }

    private boolean validateGene(String symbol) {
        Gene gene = this.provider.getGene(symbol);
        if (gene == null) {
            this.setStatus(String.format(Strings.completionPanelUnknownSymbol_status, symbol));
            return false;
        }
        for (Gene item : this.resultModel.getItems()) {
            if (item.getNode().getId() != gene.getNode().getId()) continue;
            this.setStatus(String.format(Strings.completionPanelDuplicateGene_status, this.networkUtils.getGeneLabel(gene)));
            return false;
        }
        this.resultModel.add(gene);
        return true;
    }

    private void validateGene(List<String> genes) {
        for (String symbol : genes) {
            this.validateGene(symbol);
        }
        this.repackTable();
    }

    private void repackTable() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompletionPanel.this.repackTable();
                }
            });
            return;
        }
        this.uiUtils.packColumns(this.resultTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptProposal() {
        CompletionPanel completionPanel = this;
        synchronized (completionPanel) {
            Gene gene = this.proposalModel.get(this.proposalTable.getSelectedRow());
            String proposal = gene.getSymbol();
            if (this.validateGene(proposal)) {
                this.setStatus("");
                this.repackTable();
            }
            ListSelectionModel model = this.proposalTable.getSelectionModel();
            model.clearSelection();
            model.addSelectionInterval(0, 0);
            this.hideProposals();
            this.proposalModel.clear();
            this.textField.setText("");
        }
    }

    private void validateEntry(String symbol) {
        if (symbol == null || symbol.length() == 0) {
            return;
        }
        this.validateGene(symbol);
        this.repackTable();
        this.hideProposals();
        this.proposalModel.clear();
        this.textField.setText("");
    }

    public void hideProposals() {
        this.proposalDialog.setVisible(false);
    }

    private void showProposals() {
        String query = this.getQuery();
        if (this.lastQuery != null && this.lastQuery.equals(query)) {
            return;
        }
        this.computeProposals(query);
        if (this.lastCompletionCount == 0) {
            this.hideProposals();
            return;
        }
        int selectedIndex = -1;
        int i = 0;
        for (Gene gene : this.proposalModel.getItems()) {
            if (query.equalsIgnoreCase(gene.getSymbol())) {
                selectedIndex = i;
                break;
            }
            ++i;
        }
        this.uiUtils.packColumns(this.proposalTable);
        this.proposalDialog.pack();
        this.popUpBelow(this.textField);
        if (selectedIndex != -1) {
            ListSelectionModel model = this.proposalTable.getSelectionModel();
            model.clearSelection();
            model.addSelectionInterval(selectedIndex, selectedIndex);
        }
        this.textField.requestFocus();
    }

    private void computeProposals(String query) {
        this.lastCompletionCount = 0;
        this.proposalModel.clear();
        if (this.provider != null) {
            this.provider.computeProposals(this.consumer, query);
            this.proposalModel.sort(new Comparator<Gene>(){

                @Override
                public int compare(Gene gene1, Gene gene2) {
                    return gene1.getSymbol().compareTo(gene2.getSymbol());
                }
            });
        }
        this.lastQuery = query;
    }

    private String getQuery() {
        return this.textField.getText().trim();
    }

    public List<String> getItems() {
        ArrayList<String> selection = new ArrayList<String>();
        for (Gene gene : this.resultModel.getItems()) {
            selection.add(gene.getSymbol());
        }
        return selection;
    }

    public void setItems(List<String> items) {
        this.clear();
        for (String symbol : items) {
            this.validateGene(symbol);
        }
        this.repackTable();
        this.setStatus("");
    }

    public int getItemCount() {
        return this.resultModel.getRowCount();
    }

    public int getSelectionCount() {
        return this.resultTable.getSelectedRowCount();
    }

    public void removeSelection() {
        int[] selection = this.resultTable.getSelectedRows();
        this.resultModel.removeRows(selection);
        this.uiUtils.packColumns(this.resultTable);
    }

    public void clear() {
        this.setStatus("");
        this.resultModel.clear();
        this.uiUtils.packColumns(this.resultTable);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.resultTable.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.resultTable.getSelectionModel().removeListSelectionListener(listener);
    }

    public void addTableModelEventListener(TableModelListener listener) {
        this.resultModel.addTableModelListener(listener);
    }

    public void removeTableModelEventListener(TableModelListener listener) {
        this.resultModel.removeTableModelListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.resultTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public JDialog getProposalDialog() {
        return this.proposalDialog;
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }
}

