/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.dto.AttributeDto;
import org.genemania.dto.EnrichmentEngineRequestDto;
import org.genemania.dto.EnrichmentEngineResponseDto;
import org.genemania.dto.InteractionDto;
import org.genemania.dto.InteractionVisitor;
import org.genemania.dto.NetworkCombinationRequestDto;
import org.genemania.dto.NetworkDto;
import org.genemania.dto.NodeDto;
import org.genemania.dto.RelatedGenesEngineRequestDto;
import org.genemania.dto.RelatedGenesEngineResponseDto;
import org.genemania.engine.Constants;
import org.genemania.engine.Mania2;
import org.genemania.engine.actions.CombineNetworks;
import org.genemania.engine.actions.FindRelated;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.cache.SynchronizedObjectCache;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.mania.CoreMania;
import org.genemania.engine.labels.LabelVectorGenerator;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.GeneMediator;
import org.genemania.mediator.NodeMediator;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.apps.AbstractPluginDataApp;
import org.genemania.plugin.apps.IQueryErrorHandler;
import org.genemania.plugin.controllers.IGeneProvider;
import org.genemania.plugin.controllers.RankedGeneProviderWithUniprotHack;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.formatters.FlatReportOutputFormatter;
import org.genemania.plugin.formatters.GeneListOutputFormatter;
import org.genemania.plugin.formatters.GeneScoresOutputFormatter;
import org.genemania.plugin.formatters.IOutputFormatter;
import org.genemania.plugin.formatters.XmlReportOutputFormatter;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.impl.ViewStateImpl;
import org.genemania.plugin.parsers.IQueryParser;
import org.genemania.plugin.parsers.Query;
import org.genemania.plugin.parsers.TabDelimitedQueryParser;
import org.genemania.type.CombiningMethod;
import org.genemania.type.ScoringMethod;
import org.genemania.util.NullProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public class QueryRunner
extends AbstractPluginDataApp {
    private static final int MIN_CATEGORIES = 10;
    private static final double Q_VALUE_THRESHOLD = 0.1;
    @Option(name="--in", usage="input format (one of: flat); defaults to \"flat\"")
    private String fInputFormat;
    @Option(name="--out", usage="output format (one of: genes, flat, xml, scores); defaults to \"genes\"")
    private String fOutputFormat;
    @Option(name="--results", usage="directory where results should be stored")
    private String fResultsPath = ".";
    @Option(name="--list-networks", usage="list available networks for given organism")
    private String fListNetworksFor;
    @Option(name="--list-genes", usage="list recognized gene symbols for given organism")
    private String fListGenesFor;
    @Option(name="--scoring-method", usage="gene scoring method (one of: discriminant, z); defaults to \"discriminant\"")
    private String fScoringMethod = "discriminant";
    @Option(name="--ids", usage="comma-separated list gene identifier types to use in the output")
    private String fIds;
    private Mania2 fMania;
    private IQueryParser fQueryParser;
    private File fOutputDirectory;
    private QueryHandler fQueryHandler;
    private DataCache fCache;
    private NetworkUtils fNetworkUtils;
    private static Object fJobMutex = new Object();

    private void initialize() throws ApplicationException, DataStoreException {
        try {
            DataSetManager manager = QueryRunner.createDataSetManager();
            this.fNetworkUtils = new NetworkUtils();
            this.fData = manager.open(new File(this.fDataPath));
            this.fCache = new DataCache((IObjectCache)new SynchronizedObjectCache((IObjectCache)new MemObjectCache(this.fData.getObjectCache(NullProgressReporter.instance(), false))));
            this.fMania = new Mania2(this.fCache);
            if (this.fInputFormat == null) {
                this.fQueryParser = new TabDelimitedQueryParser();
            } else if ("flat".equals(this.fInputFormat)) {
                this.fQueryParser = new TabDelimitedQueryParser();
            } else {
                throw new ApplicationException(String.format("Unrecognized input format: %s", this.fInputFormat));
            }
            IGeneProvider geneProvider = this.parseIdTypes(this.fIds);
            if (this.fOutputFormat == null) {
                this.fQueryHandler = new DefaultQueryHandler(new GeneListOutputFormatter(geneProvider));
            } else if ("genes".equals(this.fOutputFormat)) {
                this.fQueryHandler = new DefaultQueryHandler(new GeneListOutputFormatter(geneProvider));
            } else if ("scores".equals(this.fOutputFormat)) {
                this.fQueryHandler = new DefaultQueryHandler(new GeneScoresOutputFormatter(geneProvider));
            } else if ("flat".equals(this.fOutputFormat)) {
                this.fQueryHandler = new DefaultQueryHandler(new FlatReportOutputFormatter(this.fData, geneProvider));
            } else if ("xml".equals(this.fOutputFormat)) {
                this.fQueryHandler = new DefaultQueryHandler(new XmlReportOutputFormatter(this.fData, geneProvider));
            } else if ("combined-network".equals(this.fOutputFormat)) {
                this.fQueryHandler = new CombineNetworksQueryHandler(geneProvider);
            } else {
                throw new ApplicationException(String.format("Unrecognized output format: %s", this.fOutputFormat));
            }
            if (this.fThreads < 1) {
                this.fThreads = 1;
            }
            this.fOutputDirectory = new File(this.fResultsPath);
            if (!this.fOutputDirectory.exists()) {
                throw new ApplicationException(String.format("Output directory doesn't exist: %s", this.fResultsPath));
            }
            if (!this.fOutputDirectory.isDirectory()) {
                throw new ApplicationException(String.format("Output directory isn't a directory: %s", this.fResultsPath));
            }
        }
        catch (SAXException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private IGeneProvider parseIdTypes(String idList) {
        if (idList == null) {
            List<GeneNamingSource> userPreferences = Collections.emptyList();
            return new RankedGeneProviderWithUniprotHack(this.fData.getAllNamingSources(), userPreferences);
        }
        String[] items = idList.split(",");
        GeneMediator mediator = this.fData.getMediatorProvider().getGeneMediator();
        ArrayList<GeneNamingSource> userPreferences = new ArrayList<GeneNamingSource>();
        for (String item : items) {
            String name = item.trim();
            GeneNamingSource source = this.findSourceByName(mediator, name);
            if (source == null) continue;
            userPreferences.add(source);
        }
        return new RankedGeneProviderWithUniprotHack(this.fData.getAllNamingSources(), userPreferences);
    }

    private GeneNamingSource findSourceByName(GeneMediator mediator, String name) {
        if ("Uniprot AC".equals(name)) {
            GeneNamingSource prototype = mediator.findNamingSourceByName("Uniprot ID");
            if (prototype == null) {
                return null;
            }
            GeneNamingSource source = new GeneNamingSource();
            source.setId(prototype.getId());
            source.setName("Uniprot AC");
            source.setRank(prototype.getRank());
            source.setShortName(prototype.getShortName());
            return source;
        }
        return mediator.findNamingSourceByName(name);
    }

    RelatedGenesEngineRequestDto createRequest(Query query) throws ApplicationException {
        RelatedGenesEngineRequestDto request = new RelatedGenesEngineRequestDto();
        request.setNamespace("user");
        request.setOrganismId(query.getOrganism().getId());
        request.setInteractionNetworks(this.collapseNetworks(query.getNetworks()));
        request.setAttributeGroups(this.collapseAttributeGroups(query.getNetworks()));
        request.setPositiveNodes(query.getNodes());
        request.setLimitResults(query.getGeneLimit());
        request.setAttributesLimit(query.getAttributeLimit());
        request.setCombiningMethod(query.getCombiningMethod());
        if (query.getScoringMethod() != null) {
            request.setScoringMethod(query.getScoringMethod());
        } else {
            request.setScoringMethod(this.parseScoringMethod());
        }
        return request;
    }

    private ScoringMethod parseScoringMethod() throws ApplicationException {
        if ("discriminant".equals(this.fScoringMethod)) {
            return ScoringMethod.DISCRIMINANT;
        }
        if ("z".equals(this.fScoringMethod)) {
            return ScoringMethod.ZSCORE;
        }
        throw new ApplicationException(String.format("Unrecognized scoring method: %s", this.fScoringMethod));
    }

    RelatedGenesEngineResponseDto runQuery(RelatedGenesEngineRequestDto request) throws DataStoreException {
        try {
            request.setProgressReporter(NullProgressReporter.instance());
            RelatedGenesEngineResponseDto result = "scores".equals(this.fOutputFormat) ? new FindAllRelated(this.fCache, request).process() : this.fMania.findRelated(request);
            request.setCombiningMethod(result.getCombiningMethodApplied());
            this.fNetworkUtils.normalizeNetworkWeights(result);
            return result;
        }
        catch (ApplicationException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    private EnrichmentEngineRequestDto createEnrichmentRequest(Query query, RelatedGenesEngineResponseDto response) {
        if (query.getOrganism().getOntology() == null) {
            return null;
        }
        EnrichmentEngineRequestDto request = new EnrichmentEngineRequestDto();
        request.setProgressReporter(NullProgressReporter.instance());
        request.setMinCategories(10);
        request.setqValueThreshold(0.1);
        Organism organism = query.getOrganism();
        request.setOrganismId(organism.getId());
        request.setOntologyId(organism.getOntology().getId());
        HashSet<Long> nodes = new HashSet<Long>();
        for (NodeDto node : response.getNodes()) {
            nodes.add(node.getId());
        }
        request.setNodes(nodes);
        return request;
    }

    private SearchResult runAlgorithm(DataSet data, Query query) throws DataStoreException, ApplicationException {
        RelatedGenesEngineRequestDto request = this.createRequest(query);
        RelatedGenesEngineResponseDto response = this.runQuery(request);
        EnrichmentEngineRequestDto enrichmentRequest = "scores".equals(this.fOutputFormat) ? null : this.createEnrichmentRequest(query, response);
        EnrichmentEngineResponseDto enrichmentResponse = this.computeEnrichment(enrichmentRequest);
        List<String> queryGenes = query.getGenes();
        Organism organism = query.getOrganism();
        SearchResult options = this.fNetworkUtils.createSearchOptions(organism, request, response, enrichmentResponse, data, queryGenes);
        return options;
    }

    private EnrichmentEngineResponseDto computeEnrichment(EnrichmentEngineRequestDto request) throws ApplicationException {
        if (request == null) {
            return null;
        }
        return this.fMania.computeEnrichment(request);
    }

    File getOutputDirectory() {
        return this.fOutputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery(String filename, File outputDirectory) throws IOException, DataStoreException, ApplicationException {
        Query query;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
        try {
            query = this.fQueryParser.parse(this.fData, reader, new IQueryErrorHandler(){

                @Override
                public void handleUnrecognizedGene(String gene) {
                    System.err.println(String.format("WARNING: Unrecognized gene \"%s\"", gene));
                }

                @Override
                public void handleSynonym(String gene) {
                    System.err.println(String.format("WARNING: Synonym \"%s\"", gene));
                }

                @Override
                public void handleNetwork(InteractionNetwork network) {
                    if (QueryRunner.this.fVerbose) {
                        System.err.println(String.format("INFO: Using network \"%s\"", network.getName()));
                    }
                }

                @Override
                public void warn(String message) {
                    System.err.println(String.format("WARNING: %s", message));
                }

                @Override
                public void handleUnrecognizedNetwork(String network) {
                    System.err.println(String.format("WARNING: Unrecognized network \"%s\"", network));
                }
            });
        }
        finally {
            ((Reader)reader).close();
        }
        File sourceFile = new File(filename);
        String baseName = sourceFile.getName();
        this.fQueryHandler.process(query, outputDirectory, baseName);
    }

    public void handleArguments() throws InterruptedException, ApplicationException, DataStoreException {
        this.initialize();
        if (this.fListNetworksFor != null) {
            this.printNetworks(this.fListNetworksFor);
            return;
        }
        if (this.fListGenesFor != null) {
            this.printGenes(this.fListGenesFor);
            return;
        }
        Logger.getLogger((String)"org.genemania.plugin").setLevel(Level.WARN);
        Logger logger = Logger.getLogger((String)"org.genemania");
        logger.setLevel(Level.ERROR);
        List<String> arguments = this.getArguments();
        final Iterator<String> jobQueue = arguments.iterator();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.getThreads(); ++i) {
            final int threadId = i + 1;
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        String filename;
                        Object object = fJobMutex;
                        synchronized (object) {
                            if (!jobQueue.hasNext()) {
                                return;
                            }
                            filename = (String)jobQueue.next();
                        }
                        System.err.println(String.format("[Thread %d] Processing %s...", threadId, filename));
                        try {
                            QueryRunner.this.runQuery(filename, QueryRunner.this.getOutputDirectory());
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                        catch (DataStoreException e) {
                            e.printStackTrace(System.err);
                        }
                        catch (ApplicationException e) {
                            e.printStackTrace(System.err);
                        }
                        System.err.println(String.format("[Thread %d] Finished %s", threadId, filename));
                    }
                }
            });
            threads.add(thread);
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        long duration = System.currentTimeMillis() - start;
        System.err.println(String.format("Performed %d predictions in %.2fs", arguments.size(), (double)duration / 1000.0));
    }

    public static void main(String[] args) throws Exception {
        Logger.getLogger((String)"org.genemania").setLevel(Level.FATAL);
        QueryRunner runner = new QueryRunner();
        CmdLineParser parser = new CmdLineParser((Object)runner);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("\nUsage: %s options query-file-1 [query-file-2...]\n", QueryRunner.class.getSimpleName()));
            parser.printUsage((OutputStream)System.err);
            return;
        }
        runner.handleArguments();
    }

    class CombineNetworksQueryHandler
    implements QueryHandler {
        static final int INTERACTIONS_PER_DOT = 100000;
        private IGeneProvider fGeneProvider;
        Map<Long, String> fSymbolCache;
        private NodeMediator fNodeMediator;

        public CombineNetworksQueryHandler(IGeneProvider geneProvider) {
            this.fGeneProvider = geneProvider;
            this.fSymbolCache = new HashMap<Long, String>();
            this.fNodeMediator = QueryRunner.this.fData.getMediatorProvider().getNodeMediator();
        }

        String findSymbol(long nodeId, long organismId) {
            String symbol = this.fSymbolCache.get(nodeId);
            if (symbol != null) {
                return symbol;
            }
            Node node = this.fNodeMediator.getNode(nodeId, organismId);
            if (node == null) {
                return null;
            }
            Gene gene = this.fGeneProvider.getGene(node);
            if (gene == null) {
                return null;
            }
            symbol = gene.getSymbol();
            this.fSymbolCache.put(nodeId, symbol);
            return symbol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Query query, File outputDirectory, String baseName) throws ApplicationException, DataStoreException, IOException {
            CoreMania mania = new CoreMania(QueryRunner.this.fCache);
            Organism organism = query.getOrganism();
            final long organismId = organism.getId();
            String namespace = organismId < 0L ? "user" : "CORE";
            Collection<Collection<Long>> networkIds = QueryRunner.this.collapseNetworks(query.getNetworks());
            Collection<Long> attributeGroupIds = QueryRunner.this.collapseAttributeGroups(query.getNetworks());
            int attributeLimit = query.getAttributeLimit();
            if (QueryRunner.this.fVerbose) {
                System.err.println("Computing weights...");
            }
            Collection<Long> nodes = query.getNodes();
            ArrayList negativeNodes = new ArrayList();
            double posLabelValue = 1.0;
            double negLabelValue = -1.0;
            double unLabeledValueProduction = -1.0;
            DenseVector labels = LabelVectorGenerator.createLabelsFromIds((NodeIds)QueryRunner.this.fCache.getNodeIds(organismId), nodes, negativeNodes, (double)posLabelValue, (double)negLabelValue, (double)unLabeledValueProduction);
            Constants.CombiningMethod combiningMethod = Constants.convertCombiningMethod((CombiningMethod)query.getCombiningMethod(), (int)nodes.size());
            mania.computeWeights(namespace, organismId, (Vector)labels, combiningMethod, networkIds, attributeGroupIds, attributeLimit);
            if (QueryRunner.this.fVerbose) {
                System.err.println("Computing combined network...");
            }
            FeatureWeightMap featureWeights = mania.getFeatureWeights();
            ArrayList<AttributeDto> attributes = new ArrayList<AttributeDto>();
            ArrayList<NetworkDto> networks = new ArrayList<NetworkDto>();
            for (Map.Entry entry : featureWeights.entrySet()) {
                Feature feature = (Feature)entry.getKey();
                if ((Double)featureWeights.get((Object)feature) <= 0.0) continue;
                switch (feature.getType()) {
                    case ATTRIBUTE_VECTOR: {
                        AttributeDto attribute = new AttributeDto();
                        attribute.setId(feature.getId());
                        attribute.setGroupId(feature.getGroupId());
                        attribute.setWeight(((Double)entry.getValue()).doubleValue());
                        attributes.add(attribute);
                        break;
                    }
                    case SPARSE_MATRIX: {
                        NetworkDto network = new NetworkDto();
                        network.setId(feature.getId());
                        network.setWeight(((Double)entry.getValue()).doubleValue());
                        networks.add(network);
                        break;
                    }
                }
            }
            if (QueryRunner.this.fVerbose) {
                System.err.print("Writing interactions");
            }
            NetworkCombinationRequestDto request = new NetworkCombinationRequestDto();
            request.setOrganismId(organismId);
            request.setNamespace(namespace);
            request.setAttributes(attributes);
            request.setNetworks(networks);
            request.setProgressReporter(NullProgressReporter.instance());
            final PrintWriter writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(String.format("%s%s%s-results.combined-network.txt", outputDirectory.getPath(), File.separator, baseName))));
            try {
                request.setInteractionVistor(new InteractionVisitor(){
                    int counter;

                    public void visit(long node1, long node2, double weight) {
                        if (weight == 0.0) {
                            return;
                        }
                        if (QueryRunner.this.fVerbose && this.counter % 100000 == 0) {
                            System.err.print(".");
                        }
                        String symbol1 = CombineNetworksQueryHandler.this.findSymbol(node1, organismId);
                        String symbol2 = CombineNetworksQueryHandler.this.findSymbol(node2, organismId);
                        writer.printf("%s\t%s\t%s\n", symbol1, symbol2, Double.toString(weight));
                        ++this.counter;
                    }
                });
                CombineNetworks combineNetworks = new CombineNetworks(QueryRunner.this.fCache, request);
                combineNetworks.process();
            }
            finally {
                writer.close();
            }
            if (QueryRunner.this.fVerbose) {
                System.err.println("\nDone.");
            }
        }
    }

    class DefaultQueryHandler
    implements QueryHandler {
        IOutputFormatter fFormatter;

        public DefaultQueryHandler(IOutputFormatter formatter) {
            this.fFormatter = formatter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Query query, File outputDirectory, String baseName) throws ApplicationException, DataStoreException, IOException {
            SearchResult options = QueryRunner.this.runAlgorithm(QueryRunner.this.fData, query);
            ViewStateImpl viewState = new ViewStateImpl(options);
            FileOutputStream out = new FileOutputStream(String.format("%s%s%s-results.%s", outputDirectory.getPath(), File.separator, baseName, this.fFormatter.getExtension()));
            try {
                this.fFormatter.format(out, viewState);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
    }

    static interface QueryHandler {
        public void process(Query var1, File var2, String var3) throws ApplicationException, DataStoreException, IOException;
    }

    static class FindAllRelated
    extends FindRelated {
        private DataCache cache2;
        private RelatedGenesEngineRequestDto request2;

        public FindAllRelated(DataCache cache, RelatedGenesEngineRequestDto request) {
            super(cache, request);
            this.cache2 = cache;
            this.request2 = request;
        }

        protected RelatedGenesEngineResponseDto prepareResponse(Vector scores, Vector discriminant, FeatureWeightMap featureWeights, SymMatrix combinedKernel, double scoreThreshold, Constants.ScoringMethod scoringMethod, CombiningMethod combiningMethod) throws ApplicationException {
            NodeIds nodeIds = this.cache2.getNodeIds(this.request2.getOrganismId());
            List indicesForPositiveNodes = nodeIds.getIndicesForIds(this.request2.getPositiveNodes());
            scoreThreshold = Double.NEGATIVE_INFINITY;
            int[] indices = scoringMethod == Constants.ScoringMethod.CONTEXT ? MatrixUtils.getIndicesForTopScores((Vector)discriminant, (List)indicesForPositiveNodes, (int)nodeIds.getNodeIds().length, (double)scoreThreshold) : MatrixUtils.getIndicesForTopScores((Vector)scores, (List)indicesForPositiveNodes, (int)nodeIds.getNodeIds().length, (double)scoreThreshold);
            RelatedGenesEngineResponseDto result = new RelatedGenesEngineResponseDto();
            ArrayList<NetworkDto> networks = new ArrayList<NetworkDto>();
            result.setNetworks(networks);
            NetworkDto network = new NetworkDto(0L, 1.0);
            networks.add(network);
            ArrayList<NodeDto> nodes = new ArrayList<NodeDto>();
            for (int index : indices) {
                long nodeId = nodeIds.getIdForIndex(index);
                double score = scores.get(index);
                NodeDto nodeVO = new NodeDto();
                nodeVO.setId(nodeId);
                nodeVO.setScore(score);
                nodes.add(nodeVO);
                InteractionDto interaction = new InteractionDto(nodeVO, nodeVO, 1.0);
                network.addInteraction(interaction);
            }
            result.setNodes(nodes);
            return result;
        }
    }
}

