/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.genemania.engine.apps.VectorCrossValidator;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.apps.AbstractValidationApp;
import org.genemania.plugin.model.Group;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class NetworkAssessor
extends AbstractValidationApp {
    @Option(name="--networks", usage="comma delimited list of network names or group codes to assess; e.g. 'BIOGRID,coexp', or 'all', or 'default'; or 'preferred' for our selection heuristic.", required=true)
    private String fNetworkList;
    @Option(name="--exclude-networks", usage="comma delimited list of network names or group codes to exclude; e.g. 'BIOGRID,coexp', or 'all', or 'default'; or 'preferred' for our selection heuristic.")
    private String fNetworkExcludeList;
    @Option(name="--baseline", usage="comma delimited list of baseline network names or group codes to use; e.g. 'BIOGRID,coexp', or 'all', or 'default'; or 'preferred' for our selection heuristic.", required=true)
    private String fBaselineList;
    @Option(name="--exclude-baseline", usage="comma delimited list of baseline network names or group codes to exclude; e.g. 'BIOGRID,coexp', or 'all', or 'default'; or 'preferred' for our selection heuristic.")
    private String fBaselineExcludeList;

    public static void main(String[] args) throws Exception {
        Logger.getLogger((String)"org.genemania").setLevel(Level.WARN);
        NetworkAssessor assessor = new NetworkAssessor();
        CmdLineParser parser = new CmdLineParser((Object)assessor);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("\nUsage: %s options\n", assessor.getClass().getSimpleName()));
            parser.printUsage((OutputStream)System.err);
            return;
        }
        assessor.initialize();
        assessor.doAssessment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAssessment() throws ApplicationException {
        this.checkFile(this.fQueryFile);
        this.checkWritable(this.fOutputFile);
        VectorCrossValidator validator = this.createValidator(null, null);
        validator.setOutFilename(null);
        Collection<Group<?, ?>> baselineNetworks = this.parseNetworks(this.fBaselineList, this.fBaselineExcludeList, this.fOrganism);
        Collection<Group<?, ?>> subjectNetworks = this.parseNetworks(this.fNetworkList, this.fNetworkExcludeList, this.fOrganism);
        if (baselineNetworks.size() == 0) {
            throw new ApplicationException("None of the baseline networks you specified were recognized.");
        }
        if (subjectNetworks.size() == 0) {
            throw new ApplicationException("None of the subject networks you specified were recognized.");
        }
        try {
            PrintWriter writer = new PrintWriter(new File(this.fOutputFile));
            try {
                String[] names;
                validator.setNetworkIds(this.collapseNetworks(baselineNetworks));
                validator.setAttrIds(this.collapseAttributeGroups(baselineNetworks));
                validator.initValidation();
                Map baselineMeasures = validator.crossValidate();
                validator.setNetworkIds(this.collapseNetworks(subjectNetworks));
                validator.setAttrIds(this.collapseAttributeGroups(subjectNetworks));
                validator.initValidation();
                Map measures = validator.crossValidate();
                ArrayList<String> queryIds = new ArrayList<String>(baselineMeasures.keySet());
                this.sortResults(queryIds, baselineMeasures, measures);
                writer.print("QUERY");
                for (String name : names = validator.getMeasureNames()) {
                    writer.print("\tBASELINE-");
                    writer.print(name);
                    writer.print("\tSUBJECT-");
                    writer.print(name);
                    writer.print("\t%ERR-");
                    writer.print(name);
                }
                writer.println();
                for (String queryId : queryIds) {
                    writer.print(queryId);
                    if (baselineMeasures.get(queryId) == VectorCrossValidator.SKIPPED && measures.get(queryId) == VectorCrossValidator.SKIPPED) {
                        writer.print("\tskipped");
                    } else {
                        for (int i = 0; i < names.length; ++i) {
                            Double baseline = this.getMeasure(baselineMeasures, queryId, i);
                            Double subject = this.getMeasure(measures, queryId, i);
                            writer.print("\t");
                            writer.print(baseline);
                            writer.print("\t");
                            writer.print(subject);
                            writer.print("\t");
                            if (baseline != null && baseline == 0.0) {
                                writer.print("-");
                                continue;
                            }
                            if (baseline == null || subject == null) {
                                writer.print("failed");
                                continue;
                            }
                            double score = (((double[])measures.get(queryId))[i] - baseline) / baseline;
                            writer.print(String.format("%f", score));
                        }
                    }
                    writer.println();
                }
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private Double getMeasure(Map<String, double[]> measures, String queryId, int i) {
        double[] query = measures.get(queryId);
        if (query == null) {
            return null;
        }
        return query[i];
    }

    void sortResults(List<String> queryIds, final Map<String, double[]> baselineMeasures, final Map<String, double[]> measures) {
        boolean primaryMeasure = false;
        Collections.sort(queryIds, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                double[] baseline1 = (double[])baselineMeasures.get(s1);
                double[] baseline2 = (double[])baselineMeasures.get(s2);
                double[] measure1 = (double[])measures.get(s1);
                double[] measure2 = (double[])measures.get(s2);
                if (baseline1 == VectorCrossValidator.SKIPPED && baseline2 == VectorCrossValidator.SKIPPED) {
                    return s1.compareTo(s2);
                }
                if (baseline1 == VectorCrossValidator.SKIPPED) {
                    return 1;
                }
                if (baseline2 == VectorCrossValidator.SKIPPED) {
                    return -1;
                }
                if (baseline1 == null && measure1 == null && baseline2 == null && measure2 == null) {
                    return s1.compareTo(s2);
                }
                if (baseline1 == null && measure1 == null) {
                    return 1;
                }
                if (baseline2 == null && measure2 == null) {
                    return -1;
                }
                if ((baseline1 == null || measure1 == null) && baseline2 != null && measure2 != null) {
                    return 1;
                }
                if ((baseline2 == null || measure2 == null) && baseline1 != null && measure1 != null) {
                    return -1;
                }
                if (baseline2 == null && baseline1 != null) {
                    return 1;
                }
                if (baseline1 == null && baseline2 != null) {
                    return -1;
                }
                if (baseline1 == null || measure1 == null && baseline2 == null || measure2 == null) {
                    return s1.compareTo(s2);
                }
                if (baseline1[0] == 0.0 && baseline2[0] == 0.0) {
                    return s1.compareTo(s2);
                }
                if (baseline1[0] == 0.0) {
                    return 1;
                }
                if (baseline2[0] == 0.0) {
                    return -1;
                }
                double score1 = (measure1[0] - baseline1[0]) / baseline1[0];
                double score2 = (measure2[0] - baseline2[0]) / baseline2[0];
                int result = -Double.compare(score1, score2);
                if (result == 0) {
                    return s1.compareTo(s2);
                }
                return result;
            }
        });
    }
}

