/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.genemania.domain.Gene;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.NodeMediator;
import org.genemania.plugin.apps.AbstractPluginDataApp;
import org.genemania.plugin.data.DataSetManager;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public class IdMapper
extends AbstractPluginDataApp {
    public static final String NODE_ID = "node-id";
    @Option(name="--organism", usage="name of organism", required=true)
    private String fOrganismName;
    private GeneNamingSource nodeIdNamingSource = new GeneNamingSource("node-id", 127, "node-id");

    private void initialize() throws ApplicationException {
        try {
            DataSetManager manager = IdMapper.createDataSetManager();
            this.fData = manager.open(new File(this.fDataPath));
        }
        catch (SAXException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private void printMappings() throws DataStoreException, ApplicationException {
        List<String> arguments = this.getArguments();
        Organism organism = this.parseOrganism(this.fData, this.fOrganismName);
        if (organism == null) {
            System.err.println(String.format("Unrecognized organism: %s", this.fOrganismName));
            return;
        }
        List<GeneNamingSource> sources = this.extractNamingSources(arguments);
        NodeMediator mediator = this.fData.getMediatorProvider().getNodeMediator();
        List<Long> nodeIds = this.fData.getNodeIds(organism.getId());
        ArrayList<String> ids = new ArrayList<String>();
        for (Long nodeId : nodeIds) {
            Node node = mediator.getNode(nodeId.longValue(), organism.getId());
            for (GeneNamingSource source : sources) {
                if (source == this.nodeIdNamingSource) {
                    ids.add(node.getName());
                    continue;
                }
                String symbol = null;
                for (Gene gene : node.getGenes()) {
                    if (source.getId() != gene.getNamingSource().getId()) continue;
                    symbol = gene.getSymbol();
                }
                ids.add(symbol);
            }
            boolean first = true;
            for (String id : ids) {
                if (!first) {
                    System.out.print("\t");
                } else {
                    first = false;
                }
                if (id == null) continue;
                System.out.print(id);
            }
            System.out.println();
            ids.clear();
        }
    }

    private List<GeneNamingSource> extractNamingSources(List<String> arguments) throws ApplicationException {
        ArrayList<GeneNamingSource> sources = new ArrayList<GeneNamingSource>();
        List<GeneNamingSource> namingSources = this.fData.getAllNamingSources();
        namingSources.add(this.nodeIdNamingSource);
        for (String name : arguments) {
            GeneNamingSource foundSource = null;
            for (GeneNamingSource source : namingSources) {
                if (!name.equalsIgnoreCase(source.getName()) && !name.equalsIgnoreCase(source.getShortName())) continue;
                foundSource = source;
                break;
            }
            if (foundSource == null) {
                throw new ApplicationException(String.format("Unrecognized identifier type: %s", name));
            }
            sources.add(foundSource);
        }
        return sources;
    }

    public static void main(String[] args) throws Exception {
        Logger.getLogger((String)"org.genemania").setLevel(Level.FATAL);
        IdMapper mapper = new IdMapper();
        CmdLineParser parser = new CmdLineParser((Object)mapper);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("\nUsage: java %s options source-id-type target-id-type1 [target-id-type2 ...]\n", IdMapper.class.getName()));
            parser.printUsage((OutputStream)System.err);
            return;
        }
        try {
            mapper.initialize();
            mapper.printMappings();
        }
        catch (ApplicationException e) {
            String message = e.getMessage();
            if (message != null && message.length() > 0) {
                System.err.println(message);
            }
            e.printStackTrace();
        }
    }
}

